/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.management;

import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.management.OperatorContextMXBean;
import com.ibm.streams.operator.management.ProcessingElementMXBean;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Locale;
import javax.management.JMX;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class OperatorManagement {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2012, 2013    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    public static final String STREAMS_OPERATOR_JMX_DOMAIN = "com.ibm.streams.operator";

    private OperatorManagement() {
    }

    public static ObjectName getName(Type type, String name) throws MalformedObjectNameException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("type", type.type());
        if (name != null) {
            properties.put("name", name);
        }
        return new ObjectName(STREAMS_OPERATOR_JMX_DOMAIN, properties);
    }

    public static ObjectName getOperatorSpecificName(String operatorName, Type type, String name, Hashtable<String, String> properties) throws MalformedObjectNameException {
        if (properties == null) {
            properties = new Hashtable();
        }
        if (type != null) {
            properties.put("type", type.type());
        }
        if (name != null) {
            properties.put("name", name);
        }
        properties.put("operator", operatorName);
        return new ObjectName(STREAMS_OPERATOR_JMX_DOMAIN, properties);
    }

    public static ObjectName getName(OperatorContext context) {
        try {
            return OperatorManagement.getName(Type.OPERATORCONTEXT, context.getName());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ObjectName getPEName() {
        try {
            return OperatorManagement.getName(Type.PE, null);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    public static OperatorContextMXBean getOperatorContextMXBean(OperatorContext context) {
        return JMX.newMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), OperatorManagement.getName(context), OperatorContextMXBean.class, true);
    }

    public static ProcessingElementMXBean getProcessingElementMXBean() {
        return JMX.newMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), OperatorManagement.getPEName(), ProcessingElementMXBean.class, true);
    }

    public static enum Type {
        PE,
        OPERATORCONTEXT,
        METRIC;


        public String type() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

