/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.state;

import com.ibm.streams.operator.state.Checkpoint;
import com.ibm.streams.operator.state.StateHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrderedStateHandlers
implements StateHandler {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2014, 2016    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final List<StateHandler> handlers = Collections.synchronizedList(new ArrayList());

    public OrderedStateHandlers(StateHandler ... handlers) {
        for (StateHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    public final void addHandler(StateHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handlers.add(handler);
    }

    public final List<StateHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public void close() throws IOException {
        for (StateHandler handler : this.handlers) {
            handler.close();
        }
    }

    @Override
    public void drain() throws Exception {
        for (StateHandler handler : this.handlers) {
            handler.drain();
        }
    }

    @Override
    public void reset(Checkpoint checkpoint) throws Exception {
        for (StateHandler handler : this.handlers) {
            handler.reset(checkpoint);
        }
    }

    @Override
    public void checkpoint(Checkpoint checkpoint) throws Exception {
        for (StateHandler handler : this.handlers) {
            handler.checkpoint(checkpoint);
        }
    }

    @Override
    public void retireCheckpoint(long id) throws Exception {
        for (StateHandler handler : this.handlers) {
            handler.retireCheckpoint(id);
        }
    }

    @Override
    public void resetToInitialState() throws Exception {
        for (StateHandler handler : this.handlers) {
            handler.resetToInitialState();
        }
    }

    @Override
    public void prepareForNonBlockingCheckpoint(long id) throws Exception {
        for (StateHandler handler : this.handlers) {
            handler.prepareForNonBlockingCheckpoint(id);
        }
    }

    @Override
    public void regionCheckpointed(long id) throws Exception {
        for (StateHandler handler : this.handlers) {
            handler.regionCheckpointed(id);
        }
    }
}

