/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.types;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class RString
implements Serializable {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2010, 2014    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private static final long serialVersionUID = 1636707187908188702L;
    private final byte[] data;

    public RString(ByteBuffer buf, int length) {
        this.data = new byte[length];
        buf.get(this.data);
    }

    public RString(byte[] data) {
        this.data = (byte[])data.clone();
    }

    public RString(String value) {
        try {
            this.data = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLength() {
        return this.data.length;
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public String getString() {
        try {
            return new String(this.data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(String charsetName) throws IOException {
        return new String(this.data, charsetName);
    }

    public String getString(Charset charset) {
        return new String(this.data, charset);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object other) {
        if (!(other instanceof RString)) {
            return false;
        }
        RString ors = (RString)other;
        return Arrays.equals(this.data, ors.data);
    }

    public String toString() {
        return this.getString();
    }

    public ByteBuffer put(ByteBuffer buf) {
        return buf.put(this.data);
    }

    final byte[] getRawData() {
        return this.data;
    }
}

