/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;

public final class Timestamp
implements Serializable,
Comparable<Timestamp> {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2010, 2015    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private static final int NS_S = (int)TimeUnit.SECONDS.toNanos(1L);
    private static final BigDecimal NS_S_BD = new BigDecimal(NS_S);
    private static final long serialVersionUID = -153678588052923889L;
    public static final int DEFAULT_MACHINE = 0;
    private final long seconds;
    private final int nanoseconds;
    private final int machineId;

    public Timestamp(long seconds, int nanoseconds) {
        this(seconds, nanoseconds, 0);
    }

    public Timestamp(long seconds, int nanoseconds, int machineId) {
        if (nanoseconds < 0 || nanoseconds >= NS_S) {
            throw new IllegalArgumentException("Nano-second value must be in the range of 0-999999999:nanos=" + nanoseconds);
        }
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
        this.machineId = machineId;
    }

    public static Timestamp currentTime() {
        return Timestamp.currentTime(0);
    }

    public static Timestamp currentTime(int machineId) {
        return Timestamp.getTimestamp(System.currentTimeMillis(), machineId);
    }

    public static Timestamp getTimestamp(long milliseconds) {
        return Timestamp.getTimestamp(milliseconds, 0);
    }

    public static Timestamp getTimestamp(long milliseconds, int machineId) {
        long s = TimeUnit.MILLISECONDS.toSeconds(milliseconds);
        int ns = (int)TimeUnit.MILLISECONDS.toNanos(milliseconds % 1000L);
        if (ns < 0) {
            --s;
            ns += NS_S;
        }
        return new Timestamp(s, ns, machineId);
    }

    public static Timestamp getTimestamp(java.sql.Timestamp sqlTimestamp) {
        return Timestamp.getTimestamp(sqlTimestamp, 0);
    }

    public static Timestamp getTimestamp(java.sql.Timestamp sqlTimestamp, int machineId) {
        long s = TimeUnit.MILLISECONDS.toSeconds(sqlTimestamp.getTime());
        return new Timestamp(s, sqlTimestamp.getNanos(), machineId);
    }

    public static Timestamp getTimestamp(double seconds) {
        return Timestamp.getTimestamp(new BigDecimal(seconds));
    }

    public static Timestamp getTimestamp(BigDecimal seconds) {
        seconds = seconds.setScale(9, RoundingMode.DOWN);
        BigDecimal nanoseconds = seconds.remainder(BigDecimal.ONE);
        BigDecimal wholeSeconds = seconds.subtract(nanoseconds);
        return new Timestamp(wholeSeconds.longValueExact(), nanoseconds.multiply(NS_S_BD).intValueExact(), 0);
    }

    public int getMachineId() {
        return this.machineId;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getTime() {
        long msSec;
        long s = this.getSeconds();
        int ns = this.getNanoseconds();
        if (s < 0L) {
            ++s;
            ns -= NS_S;
        }
        if ((msSec = TimeUnit.SECONDS.toMillis(s)) == Long.MAX_VALUE || msSec == Long.MIN_VALUE) {
            throw this.conversionError("Timestamp.getTime()");
        }
        long msNanos = TimeUnit.NANOSECONDS.toMillis(ns);
        long ms = msSec + msNanos;
        if (ms < 0L && msSec > 0L) {
            throw this.conversionError("Timestamp.getTime()");
        }
        return ms;
    }

    public java.sql.Timestamp getSQLTimestamp() {
        long ms = TimeUnit.SECONDS.toMillis(this.getSeconds());
        if (ms == Long.MAX_VALUE || ms == Long.MIN_VALUE) {
            throw this.conversionError("Timestamp.getSQLTimestamp()");
        }
        java.sql.Timestamp sql = new java.sql.Timestamp(ms);
        sql.setNanos(this.getNanoseconds());
        return sql;
    }

    public int hashCode() {
        return this.getNanoseconds() ^ (int)this.getSeconds();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Timestamp)) {
            return false;
        }
        Timestamp ots = (Timestamp)other;
        return ots.getNanoseconds() == this.getNanoseconds() && ots.getSeconds() == this.getSeconds();
    }

    public BigDecimal getTimeAsSeconds() {
        BigDecimal s = new BigDecimal(this.getSeconds());
        BigDecimal ns = new BigDecimal(this.getNanoseconds()).scaleByPowerOfTen(-9);
        return s.add(ns);
    }

    public long convertTo(TimeUnit unit) {
        long ts = unit.convert(this.getSeconds(), TimeUnit.SECONDS);
        if (ts == Long.MAX_VALUE || ts == Long.MIN_VALUE) {
            throw this.conversionError("Timestamp.convertTo(" + (Object)((Object)unit) + ")");
        }
        long tns = unit.convert(this.getNanoseconds(), TimeUnit.NANOSECONDS);
        long tunit = ts + tns;
        if (tunit < ts) {
            throw this.conversionError("Timestamp.convertTo(" + (Object)((Object)unit) + ")");
        }
        return tunit;
    }

    private ArithmeticException conversionError(String where) {
        return new ArithmeticException(where + ": " + this.getTimeAsSeconds().toPlainString());
    }

    @Override
    public int compareTo(Timestamp o) {
        if (this.getSeconds() < o.getSeconds()) {
            return -1;
        }
        if (this.getSeconds() > o.getSeconds()) {
            return 1;
        }
        if (this.getNanoseconds() < o.getNanoseconds()) {
            return -1;
        }
        if (this.getNanoseconds() > o.getNanoseconds()) {
            return 1;
        }
        return 0;
    }

    public boolean after(Timestamp ts) {
        return this.compareTo(ts) > 0;
    }

    public boolean before(Timestamp ts) {
        return this.compareTo(ts) < 0;
    }

    public Timestamp subtract(Timestamp delta) {
        long seconds = this.getSeconds() - delta.getSeconds();
        int nanoseconds = this.getNanoseconds() - delta.getNanoseconds();
        if (nanoseconds < 0) {
            --seconds;
            nanoseconds += NS_S;
        }
        return new Timestamp(seconds, nanoseconds, this.getMachineId());
    }

    public Timestamp add(Timestamp delta) {
        long seconds = this.getSeconds() + delta.getSeconds();
        int nanoseconds = this.getNanoseconds() + delta.getNanoseconds();
        if (nanoseconds >= NS_S) {
            nanoseconds -= NS_S;
            ++seconds;
        }
        return new Timestamp(seconds, nanoseconds, this.getMachineId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(44);
        sb.append('(');
        sb.append(this.getSeconds());
        sb.append(", ");
        sb.append(this.getNanoseconds());
        sb.append(", ");
        sb.append(this.getMachineId());
        sb.append(')');
        return sb.toString();
    }
}

