/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.types;

import com.ibm.streams.operator.spi.internal.TypeProvider;
import com.ibm.streams.operator.types.Blob;
import com.ibm.streams.operator.types.RString;
import com.ibm.streams.operator.types.XML;
import com.ibm.streams.spl.messages.Message;
import com.ibm.streams.spl.messages.MessageKey;
import com.ibm.streams.spl.messages.general.StreamsSPLJavaMessagesKey;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.math.complex.Complex;

public class ValueFactory {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2012, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private static final int BUFFER_SIZE = 16384;
    private static final String Digits = "(\\d+)";
    private static final String Exp = "[eE][+-]?(\\d+)";
    private static final String FloatExpression = "[+-]?(\\d+)(\\.?(\\d+)?([eE][+-]?(\\d+))?)";
    private static final Pattern splComplexPattern = Pattern.compile("\\x28\\x20*[+-]?(\\d+)(\\.?(\\d+)?([eE][+-]?(\\d+))?)\\x20*,\\x20*[+-]?(\\d+)(\\.?(\\d+)?([eE][+-]?(\\d+))?)\\x20*\\x29");
    private static final Pattern splitter = Pattern.compile("[\\x28\\x20,\\x29]++");

    public static XML newXML(InputStream input) throws IOException {
        return TypeProvider.provider.newXML(ValueFactory.getBytes(input));
    }

    private static byte[] getBytes(InputStream input) throws IOException {
        int rc;
        byte[] b = new byte[16384];
        ByteArrayOutputStream aos = new ByteArrayOutputStream(16384);
        while ((rc = input.read(b)) != -1) {
            aos.write(b, 0, rc);
        }
        return aos.toByteArray();
    }

    public static XML newXML(ByteBuffer bytes, int length) {
        byte[] data = new byte[length];
        bytes.get(data);
        return TypeProvider.provider.newXML(data);
    }

    public static XML newXML(Transformer transformer, Source source) throws TransformerException {
        ByteArrayOutputStream aos = new ByteArrayOutputStream(16384);
        StreamResult result = new StreamResult(aos);
        transformer.transform(source, result);
        return TypeProvider.provider.newXML(aos.toByteArray());
    }

    public static Blob newBlob(ByteBuffer bytes, int length) {
        if (length == 0) {
            return ValueFactory.newBlob(null, 0, 0);
        }
        byte[] data = new byte[length];
        bytes.get(data);
        return ValueFactory.newBlobNoCopy(data);
    }

    public static Blob newBlob(RString value) {
        return ValueFactory.newBlobNoCopy(value.getRawData());
    }

    private static Blob newBlobNoCopy(byte[] data) {
        return TypeProvider.provider.newBlob(false, data, 0, data.length);
    }

    public static Blob newBlob(byte[] data, int offest, int length) {
        return TypeProvider.provider.newBlob(true, data, offest, length);
    }

    public static Blob newBlob(byte[] data) {
        return ValueFactory.newBlob(data, 0, data.length);
    }

    public static Blob readBlob(InputStream input) throws IOException {
        return ValueFactory.newBlobNoCopy(ValueFactory.getBytes(input));
    }

    public static Blob readBlob(InputStream input, long length) throws IOException {
        if (length == 0L) {
            return TypeProvider.provider.newBlob(false, null, 0, 0);
        }
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.VF_INVALID_BLOB_LENGTH, new Object[]{length}).getLocalizedMessageAndPrefix());
        }
        byte[] data = new byte[(int)length];
        DataInput din = input instanceof DataInput ? (DataInput)((Object)input) : new DataInputStream(input);
        din.readFully(data);
        return ValueFactory.newBlobNoCopy(data);
    }

    public static Blob readBlobWithPrefixLength(InputStream input) throws IOException {
        DataInput din;
        if (input instanceof DataInput) {
            din = (DataInput)((Object)input);
        } else {
            DataInputStream dis = new DataInputStream(input);
            input = dis;
            din = dis;
        }
        return ValueFactory.readBlob(input, din.readInt());
    }

    public static Complex newComplex64(CharSequence value) {
        ValueFactory.verifyComplex(value);
        String[] comps = splitter.split(value, 0);
        double real = Double.valueOf(comps[1]);
        double imaginary = Double.valueOf(comps[2]);
        return new Complex(real, imaginary);
    }

    public static Complex newComplex32(CharSequence value) {
        ValueFactory.verifyComplex(value);
        String[] comps = splitter.split(value, 0);
        float real = Float.valueOf(comps[1]).floatValue();
        float imaginary = Float.valueOf(comps[2]).floatValue();
        return new Complex((double)real, (double)imaginary);
    }

    private static void verifyComplex(CharSequence value) {
        Matcher m = splComplexPattern.matcher(value);
        if (!m.matches()) {
            throw new NumberFormatException(new Message((MessageKey)StreamsSPLJavaMessagesKey.Key.VF_INVALID_COMPLEX_FORMAT, new Object[]{value}).getLocalizedMessageAndPrefix());
        }
    }
}

