/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.version;

import com.ibm.streams.operator.version.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class Product {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2016, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private static Version currentVersion;
    public static final Version STREAMS_3_2_0;
    public static final Version STREAMS_3_2_1;
    public static final Version STREAMS_4_0_0;
    public static final Version STREAMS_4_0_1;
    public static final Version STREAMS_4_1;
    public static final Version STREAMS_4_2;

    public static Version getVersion() {
        String streamsInstall;
        if (currentVersion == null && (streamsInstall = System.getenv("STREAMS_INSTALL")) != null && streamsInstall.length() > 0) {
            File productFile = new File(streamsInstall, ".product");
            try (FileInputStream fis = new FileInputStream(productFile);){
                Properties prop = new Properties();
                prop.load(fis);
                String version = prop.getProperty("Version");
                if (version != null) {
                    currentVersion = new Version(version);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return currentVersion;
    }

    static {
        STREAMS_3_2_0 = new Version(3, 2, 0, 0);
        STREAMS_3_2_1 = new Version(3, 2, 1, 0);
        STREAMS_4_0_0 = new Version(4, 0, 0, 0);
        STREAMS_4_0_1 = new Version(4, 0, 1, 0);
        STREAMS_4_1 = new Version(4, 1, 0, 0);
        STREAMS_4_2 = new Version(4, 2, 0, 0);
    }
}

