/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.version;

public final class Version
implements Comparable<Version> {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2016, 2018    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final int version;
    private final int release;
    private final int mod;
    private final int fix;

    public int getVersion() {
        return this.version;
    }

    public int getRelease() {
        return this.release;
    }

    public int getMod() {
        return this.mod;
    }

    public int getFix() {
        return this.fix;
    }

    public Version(String version) {
        String[] parts = version.split("\\.");
        this.version = parts.length > 0 ? Integer.parseInt(parts[0]) : 0;
        this.release = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        this.mod = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        this.fix = parts.length > 3 ? Integer.parseInt(parts[3]) : 0;
    }

    public Version(int version, int release, int mod, int fix) {
        this.version = version;
        this.release = release;
        this.mod = mod;
        this.fix = fix;
    }

    @Override
    public int compareTo(Version other) {
        if (this.version > other.version) {
            return 1;
        }
        if (this.version < other.version) {
            return -1;
        }
        if (this.release > other.release) {
            return 1;
        }
        if (this.release < other.release) {
            return -1;
        }
        if (this.mod > other.mod) {
            return 1;
        }
        if (this.mod < other.mod) {
            return -1;
        }
        if (this.fix > other.fix) {
            return 1;
        }
        if (this.fix < other.fix) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fix;
        result = 31 * result + this.mod;
        result = 31 * result + this.release;
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.fix != other.fix) {
            return false;
        }
        if (this.mod != other.mod) {
            return false;
        }
        if (this.release != other.release) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return this.version + "." + this.release + "." + this.mod + "." + this.fix;
    }
}

