/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.window;

import com.ibm.streams.operator.Attribute;
import com.ibm.streams.operator.StreamSchema;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.window.StreamWindow;
import com.ibm.streams.operator.window.StreamWindowPartitioner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class WindowUtilities {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2011, 2013    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";

    public static void registerAttributePartitioner(StreamWindow<Tuple> window, String ... attributeNames) {
        if (attributeNames == null || attributeNames.length == 0) {
            throw new IllegalArgumentException();
        }
        StreamSchema schema = window.getInputPort().getStreamSchema();
        block3: for (String attributeName : attributeNames) {
            Attribute attr = schema.getAttribute(attributeName);
            if (attr == null) {
                throw new IllegalArgumentException(attributeName);
            }
            switch (attr.getType().getMetaType()) {
                case USTRING: 
                case RSTRING: 
                case BSTRING: 
                case BOOLEAN: 
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case UINT8: 
                case UINT16: 
                case UINT32: 
                case UINT64: {
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException(attr.getType().getLanguageType() + " " + attributeName);
                }
            }
        }
        if (attributeNames.length == 1) {
            final int attributeIndex = schema.getAttributeIndex(attributeNames[0]);
            window.registerPartitioner(new StreamWindowPartitioner<Tuple, Object>(){

                @Override
                public Object getPartition(Tuple tuple) {
                    return tuple.getObject(attributeIndex);
                }
            });
            return;
        }
        final int[] indexes = new int[attributeNames.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = schema.getAttributeIndex(attributeNames[i]);
        }
        window.registerPartitioner(new StreamWindowPartitioner<Tuple, List<Object>>(){

            @Override
            public List<Object> getPartition(Tuple tuple) {
                ArrayList<Object> attrs = new ArrayList<Object>(indexes.length);
                for (int i = 0; i < indexes.length; ++i) {
                    attrs.add(tuple.getObject(indexes[i]));
                }
                return Collections.unmodifiableList(attrs);
            }
        });
    }
}

