/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.window.sort;

import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.window.StatefulWindowListener;
import com.ibm.streams.operator.window.StreamWindow;
import com.ibm.streams.operator.window.StreamWindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class SortedTupleWindow
extends StatefulWindowListener<List<Tuple>, Tuple> {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2010, 2013    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final Comparator<Tuple> comparator;

    protected SortedTupleWindow(StreamWindow<Tuple> window, boolean ascending, String ... attributeNames) {
        this(window, window.getInputPort().getStreamSchema().getAttributesComparator(ascending, attributeNames));
    }

    protected SortedTupleWindow(StreamWindow<Tuple> window, boolean ascending, List<String> attributeNames) {
        this(window, ascending, attributeNames.toArray(new String[attributeNames.size()]));
    }

    protected SortedTupleWindow(StreamWindow<Tuple> window, Comparator<Tuple> comparator) {
        super(window);
        this.comparator = comparator;
    }

    @Override
    protected List<Tuple> getInitializedState(Object partition, List<Tuple> state) {
        return new LinkedList<Tuple>();
    }

    @Override
    public void handleEvent(StreamWindowEvent<Tuple> event) throws Exception {
        switch (event.getType()) {
            case INSERTION: {
                this.insertTuples(event);
                break;
            }
            case EVICTION: {
                if (this.getWindow().getType() != StreamWindow.Type.SLIDING) break;
                this.evictTuples(event);
            }
        }
    }

    private void insertTuples(StreamWindowEvent<Tuple> event) {
        List state = (List)this.getPartitionState(event.getPartition());
        for (Tuple tuple : event.getTuples()) {
            int index = this.getOrderedIndex(state, tuple);
            if (index < 0) {
                index = -(index + 1);
            }
            state.add(index, tuple);
        }
    }

    private void evictTuples(StreamWindowEvent<Tuple> event) {
        List state = (List)this.getPartitionState(event.getPartition());
        for (Tuple tuple : event.getTuples()) {
            state.remove(this.getOrderedIndex(state, tuple));
        }
    }

    private int getOrderedIndex(List<Tuple> state, Tuple tuple) {
        return Collections.binarySearch(state, tuple, this.comparator);
    }
}

