/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.operator.window.sort;

import com.ibm.streams.operator.StreamingData;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.window.StreamWindow;
import com.ibm.streams.operator.window.StreamWindowEvent;
import com.ibm.streams.operator.window.sort.SortedTupleWindow;
import java.util.List;

public final class TumblingWindowSort
extends SortedTupleWindow {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2010, 2014    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private final StreamingOutput<?> outputPort;
    private final boolean flushOnFinal;

    public TumblingWindowSort(StreamWindow<Tuple> window, boolean ascending, List<String> attributeNames, StreamingOutput<?> outputPort, boolean flushOnFinal) {
        super(window, ascending, attributeNames);
        this.outputPort = outputPort;
        this.flushOnFinal = flushOnFinal;
    }

    @Override
    protected boolean supportsWindow() {
        return this.getWindow().getType() == StreamWindow.Type.TUMBLING;
    }

    @Override
    public void handleEvent(StreamWindowEvent<Tuple> event) throws Exception {
        switch (event.getType()) {
            case EVICTION: {
                this.submitTuples(event);
                break;
            }
            case FINAL: {
                if (!this.flushOnFinal) break;
                this.submitTuples(event);
                break;
            }
        }
        super.handleEvent(event);
    }

    private void submitTuples(StreamWindowEvent<Tuple> event) throws Exception {
        List state = (List)this.getPartitionState(event.getPartition());
        if (state.isEmpty()) {
            return;
        }
        for (Tuple tuple : state) {
            this.outputPort.submit(tuple);
        }
        this.outputPort.punctuate(StreamingData.Punctuation.WINDOW_MARKER);
    }
}

