/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2013, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.flow.samples.javaprimitives;

import java.util.Random;

import com.ibm.streams.flow.declare.OperatorGraph;
import com.ibm.streams.flow.declare.OperatorGraphFactory;
import com.ibm.streams.flow.declare.OperatorInvocation;
import com.ibm.streams.flow.declare.OutputPortDeclaration;
import com.ibm.streams.flow.handlers.StreamCounter;
import com.ibm.streams.flow.javaprimitives.JavaOperatorTester;
import com.ibm.streams.flow.javaprimitives.JavaTestableGraph;
import com.ibm.streams.operator.Operator;
import com.ibm.streams.operator.StreamingData.Punctuation;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.samples.sources.RandomBeacon;

/**
 * Collection of sample tests for source operators using
 * the {@link JavaOperatorTester test framework}.
 * <BR>
 * The methods demonstrate creation of a graph and testing
 * of various aspects of that graph, include testing output.
 * A specific test framework (such as JUnit or TestNG)
 * is not used, with instead Java platform assertions
 * used to verify state. Typically it is expected that
 * testing of toolkits would use a testing framework. 
 */
public class SourceSamples {
    
    /**
     * Create and execute a graph containing a single
     * {@link RandomBeacon} operator. Verify it produces
     * the correct number of tuples and punctuation marks.
     * 
     * @throws Exception Unexpected exception declaring or executing graph
     * @see RandomBeacon
     */
    public void randomBeacon() throws Exception {
        
        final int iterations = 100;

        final OperatorGraph graph = OperatorGraphFactory.newGraph();

        // Declare a beacon operator
        OperatorInvocation<RandomBeacon> beacon = graph
                .addOperator(RandomBeacon.class);
        beacon.setIntParameter("iterations", iterations)
               .setDoubleParameter("period", 0.001);
        
        // With a single output port
        OutputPortDeclaration beaconOutput = beacon
                .addOutput("tuple<rstring name>");
              
        // Graph is now declared, create an executable version       
        JavaOperatorTester jot = new JavaOperatorTester();       
        JavaTestableGraph tg = jot.executable(graph);
        
        // Register a handler to count tuples and
        // punctuation marks
        StreamCounter<Tuple> counter = new StreamCounter<Tuple>();        
        tg.registerStreamHandler(beaconOutput, counter);
        
        // Execute the graph. RandomBeacon submits
        // a final marker after it has submitted the required
        // number of tuples (defined by the iterations parameter)
        // which will cause the graph to complete.
        tg.executeToCompletion();
        
        // Verify the output.
        assert counter.getTupleCount() == iterations;
        assert counter.getMarkCount(Punctuation.WINDOW_MARKER) == 1;
        assert counter.getMarkCount(Punctuation.FINAL_MARKER) == 1;
    }
    
    /**
     * Create a {@link RandomBeacon} and verify its parameters
     * are set correctly. This demonstrates accessing the
     * reference to instance of the {@link Operator} under test
     * using {@link JavaTestableGraph#getOperatorInstance(OperatorInvocation)}.
     */
    public void randomBeaconParameters() throws Exception {
        final OperatorGraph graph = OperatorGraphFactory.newGraph();

        // Declare a beacon operator
        OperatorInvocation<RandomBeacon> beacon = graph
                .addOperator(RandomBeacon.class);
        
        // Add required output port
        beacon.addOutput("tuple<rstring name>");
        
        Random rand = new Random();
        final long seed = rand.nextLong();
        final long delay = rand.nextInt(100)+ 1;
        beacon.setLongParameter("seed", seed);
        beacon.setLongParameter("initDelay", delay);
              
        // Graph is now declared, create an executable version       
        JavaOperatorTester jot = new JavaOperatorTester();       
        JavaTestableGraph tg = jot.executable(graph);
        
        // Initialize the operator to ensure that the setters
        // have been called by the SPL runtime.
        tg.initialize().get();
        
        // Get the instance of RandomBeacon executing in the graph
        RandomBeacon runningBeacon = tg.getOperatorInstance(beacon);
        
        // Verify its setter methods were called.
        assert seed == runningBeacon.getSeed();
        assert delay == runningBeacon.getInitialDelay();

        // Cleanup
        tg.shutdown().get();
    }
}
