/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2013, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.function.samples.jvm;

import java.lang.management.ManagementFactory;

import com.ibm.streams.function.model.Function;

public class SystemFunctions {
    
    /**
     * Only expose the static methods.
     */
    private SystemFunctions() {}
    
    /**
     * Returns the Java virtual machine implementation name. 
     * @return The Java virtual machine implementation name.
     */
    @Function(description="Returns the Java virtual machine implementation name.")
    public static String getVmName() {
        return ManagementFactory.getRuntimeMXBean().getVmName();
    }
    /**
     * Returns the Java virtual machine implementation vendor.
     * @return The Java virtual machine implementation vendor
     */
    @Function(description="Returns the Java virtual machine implementation vendor.")
    public static String getVmVendor() {
        return ManagementFactory.getRuntimeMXBean().getVmVendor();
    }
    /**
     * Returns the Java virtual machine implementation version.
     * @return The Java virtual machine implementation version
     */
    @Function(description="Returns the Java virtual machine implementation version.")
    public static String getVmVersion() {
       return ManagementFactory.getRuntimeMXBean().getVmVersion();
    }

    /**
     * Request garbage collection for the Java virtual machine.
     */
    @Function(stateful=true, // Stateful as it modified state outside the function
            description="Request garbage collection for the Java virtual machine.")
    public static void gc() {
        System.gc();
    }
    
    /**
     * Request running of {@code Object.finalize()} for
     * objects pending garbage collection in the Java virtual machine.
     */
    @Function(stateful=true, // Stateful as it modified state outside the function
            description="Request running of `Object.finalize()` for objects pending garbage collection in the Java virtual machine.")
    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }
    
    /**
     * Return the number of processors available to
     * the Java virtual machine.
     * 
     * Calls {@code Runtime.getRuntime().availableProcessors()}.
     * 
     * @return Return the number of processors available to
     * the Java virtual machine.
     */
    @Function(stateful=true, // Stateful as it might return different values
            description="Return the number of processors available to the Java virtual machine.") 
    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }
    
    /**
     * Returns the amount of free memory (in bytes) in the Java Virtual Machine. 
     * Calls {@code Runtime.getRuntime().freeMemory()}.
     * @return The amount of free memory in the Java Virtual Machine.
     */
    @Function(stateful=true, // Stateful as it might return different values
            description="Returns the amount of free memory (in bytes) in the Java Virtual Machine.")
    public static long freeMemory() {
        return Runtime.getRuntime().freeMemory();
    }
    
    /**
     * Returns the total amount of memory in the Java virtual machine. 
     * Calls {@code Runtime.getRuntime().totalMemory()}.
     * @return The total amount of memory in the Java virtual machine. 
     */
    @Function(stateful=true, // Stateful as it might return different values
            description="Returns the total amount of memory in the Java virtual machine.")
    public static long totalMemory() {
        return Runtime.getRuntime().totalMemory();
    }
    /**
     * Returns the maximum amount of memory that the Java virtual machine will
     * attempt to use. 
     * Calls {@code Runtime.getRuntime().maxMemory()}.
     * @return The maximum amount of memory that the Java virtual machine will
     * attempt to use.
     */
    @Function(stateful=true, // Stateful as it might return different values
            description="Returns the maximum amount of memory that the Java virtual machine will attempt to use.")
    public static long maxMemory() {
        return Runtime.getRuntime().maxMemory();
    }
}
