/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2013, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.function.samples.math;

import org.apache.commons.math.util.MathUtils;

import com.ibm.streams.function.model.Function;
import com.ibm.streams.operator.model.Namespace;

/**
 * Sample mathematical SPL Java native functions.
 * Functions that call static methods in
 * {@code java.lang.Math} or {@code org.apache.commons.math.util.MathUtils}
 * and are annotated with {@link Function} to expose them as SPL native functions.
 * <BR>
 * The SPL namespace of the functions is defined by the
 * {@link Namespace} annotation
 * applied to this class's package {@link com.ibm.streams.function.samples.math}.
 */
public class MathFunctions {
    
    /**
     * Only expose the static methods.
     */
    private MathFunctions() {}
    
    /**
     * Returns the hyperbolic cosine of a double value.
     * @param v The value to calculate the hyperbolic cosine of.
     * @return The hyperbolic cosine of {@code v}.
     */
    @Function(description="Returns the hyperbolic cosine of a `float64` value.")
    public static double cosh(double v) {
        return Math.cosh(v);
    }
    
    /**
     * Returns the hyperbolic sine of a double value.
     * @param v The value to calculate the hyperbolic sine of.
     * @return The hyperbolic sine of {@code v}.
     */
    @Function(description="Returns the hyperbolic sine of a `float64` value.")
    public static double sinh(double v) {
        return Math.sinh(v);
    }
    /**
     * Returns the hyperbolic tangent of a double value.
     * @param v The value to calculate the hyperbolic tangent of.
     * @return The hyperbolic tangent of {@code v}.
     */
    @Function(description="Returns the hyperbolic tangent of a `float64` value.")
    public static double tanh(double v) {
        return Math.tanh(v);
    }
    
    /**
     * Returns <code>&radic;(x<sup>2</sup> + y<sup>2</sup>)</code>.
     * @param x a value
     * @param y a value
     * @return <code>&radic;(x<sup>2</sup> + y<sup>2</sup>)</code>
     */
    @Function(name="hypotenuse", description="Returns the square root of `x` squared plus `y` squared.")
    public static double hypot(double x, double y) {
        return Math.hypot(x, y);
    }
    
    /**
     * Returns {@code n!} ({@code n} factorial).
     * @param n Value to calculate the factorial of.
     * @return {@code n!}
     */
    @Function(description="Returns `n!` (`n` factorial).")
    public static long factorial(int n) {
        return MathUtils.factorial(n);
    }
}
