/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2013, 2020  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.control.patterns;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

import com.ibm.streams.operator.AbstractOperator;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.control.Controllable;

/**
 * Abstract operator for listening to notifications
 * from the Job Control Plane and then submitting tuples
 * derived from the notification to an output port.
 * 
 */
public abstract class AbstractNotificationSource extends AbstractOperator implements Controllable {
	/* begin_generated_IBM_copyright_code                               */
	public static final String IBM_COPYRIGHT =
		" Licensed Materials-Property of IBM                              " + //$NON-NLS-1$ 
		" 5724-Y95                                                        " + //$NON-NLS-1$ 
		" (C) Copyright IBM Corp.  2013, 2014    All Rights Reserved.     " + //$NON-NLS-1$ 
		" US Government Users Restricted Rights - Use, duplication or     " + //$NON-NLS-1$ 
		" disclosure restricted by GSA ADP Schedule Contract with         " + //$NON-NLS-1$ 
		" IBM Corp.                                                       " + //$NON-NLS-1$ 
		"                                                                 " ; //$NON-NLS-1$ 
	/* end_generated_IBM_copyright_code                                 */
	
	private static Logger trace = Logger.getLogger(AbstractNotificationSource.class.getName());

	/**
	 * 
	 */
	private String[] objectNames;
	private String[] filters;

	/**
	 * Set the object names to listen to.
	 */
	public void setObjectNames(String[] objectNames) {
		this.objectNames = objectNames;
	}

	public String[] getObjectNames() {
		return objectNames;
	}

	/**
	 * Set the filters. Filters are simple filters
	 * on the notification type.
	 * @param filters
	 */
	public void setFilters(String[] filters) {
		this.filters = filters;
	}

	public String[] getFilters() {
		return filters;
	}
	
	private NotificationFilter notificationFilter;
	private NotificationListener notificationListener;

	@Override
	public void initialize(OperatorContext context)
			throws Exception {
		super.initialize(context);
		this.setLoggerAspects(trace.getName(), "jmx", "notification");
		createAvoidCompletionThread();
		
		this.notificationFilter = getFilter();
		this.notificationListener = getNotificationListener();
		
		// Attach as soon as possible, to avoid any delays during allPortsReady.
		getControlPlaneContext().connect();
	}
	
        protected NotificationListener getNotificationListener() {
            // TODO getOutput(int) includes only regular output ports.
            // It is possible that this operator has only exception ports,
            // in which case this needs to get an exception ports.  I am not
            // sure how this works.
            return new NotificationTupleSubmitter(getOperatorContext(), getOutput(0));
	}
	
    protected NotificationFilter getFilter() {
        if (getFilters() == null)
            return null;
        final NotificationFilterSupport filter = new NotificationFilterSupport();
        for (String filteredType : getFilters())
            filter.enableType(filteredType);
        return filter;
    }
	
    
    /**
     * Connect this to the Job Control Plane as
     * a {@link Controllable}. The {@link Controllable} is
     * only connected at {@link com.ibm.streams.operator.Operator#allPortsReady()}
     * to ensure no tuples are submitted before the output port is ready.
     */
	@Override
	public void allPortsReady() throws Exception {
	    getControlPlaneContext().connect(this);
	}
	
	/**
	 * Is this {@link Controllable} applicable
	 * for this invocation.
	 * Return true as the assumption is that
	 * this {@code Controllable} is always application
	 * for its own operator. Sub-classes may override this
	 * if they there is no requirement to connect to the
	 * control plane for some invocations.
	 * @return true
	 * @see Controllable#isApplicable(OperatorContext)
	 */
	@Override
	public boolean isApplicable(OperatorContext context) {
		return true;
	}
	
	/**
	 * Add the notification listener to each MBean listed in the
	 * getObjectNames() array using the filter.
	 * The standard handler will submit a tuple to port 0 for each notification 
	 */
	@Override
	public void setup(MBeanServerConnection mbs, OperatorContext context)
			throws Exception {
		
		final Set<String> objectNames = new HashSet<String>(Arrays.asList(getObjectNames()));
		trace.info("Adding listeners to:" + objectNames);

        for (String ons : objectNames) {
            ObjectName on = ObjectName.getInstance(ons);

            trace.info(MessageFormat.format(
                    "Notification listener request: {0}", on.getCanonicalName()));

            mbs.addNotificationListener(on, notificationListener,
                    notificationFilter, null);

            trace.info(MessageFormat.format(
                    "Added notification listener to: {0}",
                    on.getCanonicalName()));
        }

		trace.info("Done adding listeners.");
	}
}
