/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2013, 2018  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.control.patterns;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.StreamSchema;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.Type;
import com.ibm.streams.operator.types.RString;
import com.ibm.streams.operator.types.Timestamp;

/**
 * Notification listener that submits a tuple to an output port
 * with the attributes set from the {@code Notification}.
 * This provides a mechanism to convert notifications from the
 * Job Control Plane (or any JMX MBean) to tuples for stream processing.
 * <P>
 * The tuple is sent asynchronously so that any tuple processing
 * does not block notification handling. This also means that
 * tuples may be submitted in a different order to their notification order.
 * </P>
 * <P>
 * The tuple may have any number of attributes, and attributes not
 * set from the notification are set to their default value.
 * <BR>
 * If attribute matches one of these, then it is set from the {@code Notification}:
 * <UL>
 * <LI>{@code rstring source} - The value of {@code ObjectName.getCanonicalName()} for the value returned by {@code getSource()}.</LI>
 * <LI>{@code rstring notifyType} - The value of {@code getType()}.</LI>
 * <LI>{@code int64 sequence} - The value of {@code getSequenceNumber()}.</LI>
 * <LI>{@code timestamp ts} - The value of {@code getTimeStamp()} with machine identifier set to
 * {@link Timestamp#DEFAULT_MACHINE}.</LI>
 * <LI>{@code rstring message} - The value of {@code getMessage()}, if it is not null.</LI>
 * <LI>{@code rstring userDataString} - The value of {@code getUserData().toString()}, if {@code getUserData()} is not {@code null}.</LI>
 * <LI>{@code userData} - The value of {@code getUserData()}, note the SPL type of {@code userData} attribute must be directly assignable
 * from the object type returned by {@code getUserData()}.</LI>
 * <LI>{@code handback} - The value of {@code handback} set when this was added as a notification handler, note the SPL type of {@code handback} attribute must be directly assignable
 * from the object type of {@code handback}.</LI>
 * </UL>
 * {@code rstring} values are assigned from {@code String} objects using UTF-8 encoding.
 * </P>
 *
 */
public class NotificationTupleSubmitter implements NotificationListener {
	/* begin_generated_IBM_copyright_code                               */
	public static final String IBM_COPYRIGHT =
		" Licensed Materials-Property of IBM                              " + //$NON-NLS-1$ 
		" 5724-Y95                                                        " + //$NON-NLS-1$ 
		" (C) Copyright IBM Corp.  2013, 2014    All Rights Reserved.     " + //$NON-NLS-1$ 
		" US Government Users Restricted Rights - Use, duplication or     " + //$NON-NLS-1$ 
		" disclosure restricted by GSA ADP Schedule Contract with         " + //$NON-NLS-1$ 
		" IBM Corp.                                                       " + //$NON-NLS-1$ 
		"                                                                 " ; //$NON-NLS-1$ 
	/* end_generated_IBM_copyright_code                                 */
    
    /**
     * Base schema that includes all the fixed typed attributes that
     * can be set from a {@code Notification}, namely
     * {@code source}, {@code notifyType}, {@code sequence}, {@code ts} and {@code message}.
     */
    public static final StreamSchema BASE_NOTIFY_SCHEMA = Type.Factory.getStreamSchema(
            "tuple<rstring source, rstring notifyType, int64 sequence, timestamp ts, rstring message>");

    private final OperatorContext context;
    private final StreamingOutput<?> port;

    /**
     * Create a {@code NotificationTupleSubmitter}
     * @param context Operator context for the operator containing the output port.
     * @param port The output port to submit tuples to.
     */
    public NotificationTupleSubmitter(OperatorContext context, final StreamingOutput<?> port) {
        this.context = context;
        this.port = port;
    }

    /**
     * Handle the notification by converting {@code notification} and {code handback}
     * to a tuple using {@link #getTuple(Notification, Object)} and then calling
     * {@link #submit(Tuple)}.
     */
    @Override
    public void handleNotification(final Notification notification, final Object handback) {       
        final Tuple tuple = getTuple(notification, handback);
        submit(tuple);
    }
    
    /**
     * Asynchronously submit the tuple to the output port.
     * @param tuple Tuple to be submitted.
     */
    protected void submit(final Tuple tuple) {
        context.getScheduledExecutorService().submit(new Callable<Object>() {
            @Override
            public Object call() throws Exception {
                return port.submit(tuple);
            }
        });        
    }
    
    /**
     * Convert the notification to a tuple, using {@link #getAttributes(Notification, Object)}.
     * @param notification Notification object.
     * @param handback Handback object.
     * @return Tuple to be submitted.
     */
    protected Tuple getTuple(final Notification notification, final Object handback) {
        return port.getStreamSchema().getTuple(getAttributes(notification, handback));
    }

    /**
     * Convert the notification to a {@code Map} of attributes keyed by attribute name.
     * @param notification Notification object.
     * @param handback Handback object.
     * @return Map containing attributes
     */
    protected Map<String, Object> getAttributes(final Notification notification, final Object handback) {
        final Map<String, Object> attributes = new HashMap<String, Object>();

        Object source = notification.getSource();
        String ssource;
        if (source instanceof ObjectName)
            ssource = ((ObjectName) source).getCanonicalName();
        else
            ssource = source.toString();
        attributes.put("source", new RString(ssource));
        attributes.put("notifyType", new RString(notification.getType()));
        attributes.put("sequence", notification.getSequenceNumber());
        attributes.put("ts",
                Timestamp.getTimestamp(notification.getTimeStamp()));
        final Object userData = notification.getUserData();
        if (userData != null) {
            attributes.put("userData", userData);
            attributes.put("userDataString", new RString(userData.toString()));
        }
        if (handback != null)
            attributes.put("handback", handback);
        if (notification.getMessage() != null)
            attributes.put("message", new RString(notification.getMessage()));
        return attributes;
    }
}
