/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2014  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.operators;

import java.math.RoundingMode;

import com.ibm.streams.operator.AbstractOperator;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.operator.model.PrimitiveOperator;

/**
 * Set a decimal attribute's scale. Each input tuple results in
 * an output tuple that includes all matching attributes and
 * the modified decimal attribute. Example of a functor style
 * operator that directly extends {@link AbstractOperator}.
 * <P>
 * The operator supports two parameters:
 * <UL>
 * <LI> <code>name</code> Name of the attribute to be modified.</LI>
 * <LI> <code>scale</code> Scale for modified attribute.</LI>
 * </UL>
 * <BR>
 * The output tuple's value for attribute <code>name</code> is a result
 * of:
 * <OL>
 * <LI> Obtaining a <code>BigDecimal</code> from the input tuple attribute with the same name.</LI>
 * <LI> Setting the scale of the value with <code>RoundingMode.DOWN</code>.</LI>
 * <LI> Assigning the modified value to the output tuple's attribute
 * which may truncate the value according to its defined type:
 * {@link com.ibm.streams.operator.Type.MetaType#DECIMAL32 DECIMAL32},
 * {@link com.ibm.streams.operator.Type.MetaType#DECIMAL64 DECIMAL64} or
 * {@link com.ibm.streams.operator.Type.MetaType#DECIMAL128 DECIMAL128}.
 * </LI>
 * </OL>
 * </P>
 */
@PrimitiveOperator(comment=DecimalScaleSetter.IBM_COPYRIGHT)
@InputPortSet(cardinality=1)
@OutputPortSet(cardinality=1,windowPunctuationOutputMode=WindowPunctuationOutputMode.Preserving)
public class DecimalScaleSetter extends AbstractOperator {
    
    /**
     * Name of the attribute to set the scale on.
     */
    private String name;
    
    /**
     * Scale to set the output attribute to.
     */
    private int scale;
    
    /**
     * Initialize the operator.
     */
    @Override
    public void initialize(OperatorContext context) throws Exception {
        super.initialize(context);
    }
    
    /**
     * Set the name for the decimal attribute.
     * @param name Name of output attribute
     */
    @Parameter(description="Name of input attribute to have its decimal scale set.")
    public void setName(String name) {
        this.name = name;
    }
    /**
     * Set the scale for the decimal value.
     * @param scale Scale for the output value
     */
    @Parameter(description="Scale to set for input attributes with name `name`.")
    public void setScale(int scale) {
        this.scale = scale;
    }
    
    /**
     * Get the scale value to set the attribute's value to.
     * @return The scale value to set the attribute's value to.
     */
    private synchronized int getScale() {
        return scale;
    }
    
    /**
     * Get the name of the attribute being modified.
     * @return The attribute name being modified.
     */
    private synchronized String getAttributeName() {
        return name;
    }

    /**
     * Submit each input tuple, modifying the named attribute by setting its scale.
     * Matching attributes are copied from the input tuple to the output tuple
     * using {@link OutputTuple#assign(Tuple)}.
     */
    @Override
    public void process(StreamingInput<Tuple> port, Tuple tuple) throws Exception {
        
        final String attributeName = getAttributeName();
        StreamingOutput<OutputTuple> out = getOutput(0);
        OutputTuple outTuple = out.newTuple();
        outTuple.assign(tuple);
        outTuple.setBigDecimal(attributeName,
                tuple.getBigDecimal(attributeName).setScale(getScale(), RoundingMode.DOWN));
        out.submit(outTuple);
    }
}
