/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2014, 2020  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.operators;

import com.ibm.streams.operator.AbstractOperator;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.TupleAttribute;
import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.InputPorts;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPorts;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.operator.model.PrimitiveOperator;

/**
 * Sample operator that demonstrates the usage of CustomLiteral and Attribute
 * parameters.
 * <P>
 * The operator supports 2 parameters:
 * 
 * <BR>
 * monitorType: One of 'Max' or 'Min' custom literal to indicate whether the operator is
 * keeping track of max or min values.
 * <BR>
 * monitoredAttr: The attribute on the input schema to monitor for max or min values. The attribute
 * must be an int32.
 * <BR>
 * </P>
 * 
 * <P>
 * The operator processes incoming tuples and keeps track of max/min values (as specified by the monitorType parameter)
 * of the input schema attribute specified by the monitordAttr parameter. The current max/min value is returned as a tuple
 * on the first output port. The original tuples are also passed through on the second output port.
 * </P>
 * 
 */
@PrimitiveOperator(description="Simple sample operator that monitors the incoming tuples and sends the max or min value that is seen on the attribute specified by the monitoredAttr parameter on the first output port along with the original tuple on the second output port.")
@InputPorts(@InputPortSet(cardinality=1))
@OutputPorts(@OutputPortSet(cardinality=2))
public class MaxMinOperator extends AbstractOperator {
	
	
	/**
	 * Type of monitoring that is supported
	 */
	public enum Type {
		Max,
		Min
	}
	
	private Type monitorType;
	private TupleAttribute<Tuple, Integer> monitoredAttr;
	private int value;
	
	@Parameter(description="Set whether the operator is monitoring 'Max' or 'Min' value")
	public void setMonitorType(Type t) {
		this.monitorType = t;
	}
	
	@Parameter(description="Set the tuple attribute of type 'int32' to monitor.")
	public void setMonitoredAttr(TupleAttribute<Tuple, Integer> mAttr) {
		this.monitoredAttr = mAttr;
	}

	@Override
	public void process(StreamingInput<Tuple> stream, Tuple tuple)
			throws Exception {
		int newValue = monitoredAttr.getValue(tuple);
		
		//if we are looking for max value and the newValue is greater than the one stored
		//then the newValue is the new max value and we submit a tuple to indicate that.
		//and similarly for min.
		if(monitorType == Type.Max && newValue > value) {
			value = newValue;
                        getOutput(0).submitAsTuple(value);
		}
		else if(monitorType == Type.Min && newValue < value) {
			value = newValue;
                        getOutput(0).submitAsTuple(value);
		}
                getOutput(1).submit(tuple);
	}
}
