/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.operators;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.model.PrimitiveOperator;

/**
 * OrderedPortSequencer extends PortSequencer to provide
 * submission of tuples within a port ordered by the portSequence
 * attribute.
 */
@PrimitiveOperator(description=
            "Operator that maintains an per-input port `int64` sequence number for arriving tuples and sets it as the `portSequence` attribute of the output tuple and ensures tuples are submitted to its output port is sequence number order.",
        comment=OrderedPortSequencer.IBM_COPYRIGHT)
public class OrderedPortSequencer extends PortSequencer {
    
    /**
     * Array of locks, one per port. Note this object's access
     * is synchronized using this to guarantee visibility across threads.
     */
    private Lock[] portLocks;
    
    /**
     * Create a Lock object for each input/output port (remember the
     * class assumes a 1-1 mapping between input and output ports).
     * The lock is a "fair" lock to try and ensure the oldest waiting
     * thread is granted access first.
     */
    @Override
    public synchronized void initialize(OperatorContext context) throws Exception {
        super.initialize(context);
        portLocks = new Lock[context.getNumberOfStreamingInputs()];
        for (int p = 0; p < portLocks.length; p++)
            portLocks[p] = new ReentrantLock(true);
    }
    
    /**
     * Get the lock for a specific port. Method is synchronized
     * to guarantee visibility of the array and its contents.
     * @return Lock object for the port.
     */
    private synchronized Lock getPortLock(int port) {
        return portLocks[port];
    }
    
    /**
     * Process the tuple and submit it holding the port specific
     * lock for the entire processing of the tuple. This means
     * the assignment of the portSequence attribute and submission
     * of the tuple are in the same critical section, leading
     * to the order of submission matching the portSequence.
     */
    @Override
    public void process(StreamingInput<Tuple> port, Tuple tuple) throws Exception {
        
        final Lock portLock = getPortLock(port.getPortNumber());
        
        try {
             portLock.lock();
             super.process(port, tuple);
        } finally {
            // Ensure the lock is always released by calling the unlock
            // in a finally block.
            portLock.unlock();
        }
    }


}
