/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2013, 2014  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.operators;

import com.ibm.streams.operator.AbstractOperator;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OperatorContext.ContextCheck;
import com.ibm.streams.operator.StreamingData.Punctuation;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.compile.OperatorContextChecker;
import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.PrimitiveOperator;

/**
 * Simple sample operator that passes all input unchanged from
 * any input port to its single output port. All input ports
 * and the output port must have the same schema.
 */
@PrimitiveOperator(description="Simple sample operator that passes all input unchanged from any input port to its output port.",
        comment=PassThrough.IBM_COPYRIGHT)
@InputPortSet
@OutputPortSet(cardinality=1)
public class PassThrough extends AbstractOperator {
    
    /**
     * Verify the output port schema matches all input ports.
     */
    @ContextCheck
    public static void matchingPorts(OperatorContextChecker checker) {
        final OperatorContext context = checker.getOperatorContext();
        for (StreamingInput<?> input : context.getStreamingInputs())
            checker.checkMatchingSchemas(
                input,
                context.getStreamingOutputs().get(0));
    }
    
    /**
     * Forward the input tuple directly to output port 0.
     */
    @Override
    public void process(StreamingInput<Tuple> stream, Tuple tuple)
            throws Exception {
        getOutput(0).submit(tuple);
    }
    
    /**
     * Forward the punctuation mark directly to output port 0.
     */
    @Override
    public void processPunctuation(StreamingInput<Tuple> stream,
            Punctuation mark) throws Exception {
        getOutput(0).punctuate(mark);
    }
}
