/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.operators;

import com.ibm.streams.operator.AbstractOperator;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OperatorContext.ContextCheck;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.Type.MetaType;
import com.ibm.streams.operator.compile.OperatorContextChecker;
import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.InputPorts;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPorts;
import com.ibm.streams.operator.model.PrimitiveOperator;

/**
 * Simple class that maintains an per-input port int64 sequence number for
 * arriving tuples and sets it as the portSequence attribute of the
 * output tuple. This class is to demonstrate synchronization on a
 * per-port basis. Each incoming tuple is assigned to an output port
 * at the same index using OutputTuple.assign(), that is the code
 * assumes there are N input ports and N output ports.
 * <BR>
 * The portSequence attribute value corresponds to order arrival of the
 * tuples to the process method, there is no guarantee that this operator
 * will submit tuples in the portSequence order. See PortSequencer.process()
 * for details.
 */
@PrimitiveOperator(description=
    "Operator that maintains an per-input port `int64` sequence number for arriving tuples and sets it as the `portSequence` attribute of the output tuple.",
        comment=PortSequencer.IBM_COPYRIGHT)
@InputPorts(@InputPortSet)
@OutputPorts(@OutputPortSet)
public class PortSequencer extends AbstractOperator {
    
    /**
     * Array of sequence number for the tuples for each port.
     */
    private long[] portSequences;
    
    @ContextCheck
    public static void checkPorts(OperatorContextChecker checker) {
        final OperatorContext context = checker.getOperatorContext();
        
        // Verify the number of output ports is the same as
        // the input ports.
        if (context.getNumberOfStreamingOutputs() != context.getNumberOfStreamingInputs()) {
            checker.setInvalidContext(
                    "Number of output ports {0} must match the number of input ports {1}.",
                    new Object[] {context.getNumberOfStreamingOutputs(),
                            context.getNumberOfStreamingInputs()});
        }
        
        // Verify that each output port has a int64 portSequence attribute
        for (StreamingOutput<?> port : context.getStreamingOutputs()) {
            checker.checkRequiredAttributes(port, "portSequence");
            checker.checkAttributeType(
                    port.getStreamSchema().getAttribute("portSequence"), MetaType.INT64);
          }
    }

    /**
     * Initialize the portSequences field holding the Operator's (this)
     * synchronization to ensure later threads fetching it using
     * getPortSequences() are guaranteed to see the initialized value.
     */
    @Override
    public synchronized void initialize(OperatorContext context) throws Exception {
        super.initialize(context);
        portSequences = new long[context.getNumberOfStreamingInputs()];
    }

    /**
     * Get the portSequences instance field using synchronization.
     * The synchronization (on this) guarantees the reader will see
     * the initialized value. Accessing the field directly does not
     * guarantee a thread will see the initialized value due to the
     * visibility rules defined by the Java Memory model.
     * @return the portSequences
     */
    private synchronized long[] getPortSequences() {
        return portSequences;
    }

    /**
     * Process a tuple simply assigning it to the output port
     * with the same index and adding the portSequence field
     * set to the sequence of the arriving tuple within the port.
     * <P>
     * Synchronization is on the StreamingInput object
     * corresponding to the port the tuple arrived on. This per-port
     * synchronization allows threads processing tuples from different
     * input ports to concurrently calculate their own port sequence value.
     * </P>
     * <P>
     * Note that the order submission of tuples is <b>not</b>
     * guaranteed by this method since no lock is held between the
     * assignment of portSequence and the submission of the tuple.
     * Thus, for example, after one thread has portSequence=100
     * another thread may grab portSequence=101 and this '101' thread
     * may call submit() before the '100' thread.
     * </P>
     */
    @Override
    public void process(StreamingInput<Tuple> port, Tuple tuple)
       throws Exception {
        
        /*
         * Synchronize the port sequence on the StreamingInput
         * reference for the port the tuple arrives on. Note
         * the synchronization is only held to calculate and
         * set the portSequence to reduce contention by making
         * the critical section as small as possible.
         */
        long portSequence;
        synchronized (port) {         
            portSequence = getPortSequences()[port.getPortNumber()]++;
        }
        
        StreamingOutput<OutputTuple> outPort = getOutput(port.getPortNumber());
        
        OutputTuple outTuple = outPort.newTuple();
        
        outTuple.assign(tuple);
        outTuple.setLong("portSequence", portSequence);
        
        // No synchronization held during submission.
        getOutput(port.getPortNumber()).submit(outTuple);
    }
}
