/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2014  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.patterns;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.logging.TraceLevel;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.operator.state.ConsistentRegionContext;

/**
 * Abstract pattern class for an operator that produces tuples by polling an
 * external source for information and converting that information into outgoing
 * tuples. This class just provides the mechanism for polling, sub-classes
 * implement fetchTuples() which will be called at the polling frequency.
 * 
 * 
 */
public abstract class PollingTupleProducer extends TupleProducer {
    /* begin_generated_IBM_copyright_code */
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                              "
            + " 5724-Y95                                                        "
            + " (C) Copyright IBM Corp.  2009, 2009    All Rights Reserved.     "
            + " US Government Users Restricted Rights - Use, duplication or     "
            + " disclosure restricted by GSA ADP Schedule Contract with         "
            + " IBM Corp.                                                       "
            + "                                                                 ";
    /* end_generated_IBM_copyright_code */

    /**
     * SPL Trace facility
     */
    private final static Logger trace = Logger.getLogger(PollingTupleProducer.class.getName());
    private long pollFrequency = 1;
    private TimeUnit pollFrequencyUnit = TimeUnit.SECONDS;

    /**
     * Get the polling frequency, defaults to 1.
     * 
     * @return Current frequency.
     */
    public final synchronized long getPollFrequency() {
        return pollFrequency;
    }

    /**
     * Get the unit for the polling frequency, defaults to SECONDS.
     * 
     * @return Unit for polling frequency.
     */
    public final synchronized TimeUnit getPollFrequencyUnit() {
        return pollFrequencyUnit;
    }

    /**
     * Set the polling frequency. Must be called in a sub-class's initialize()
     * to have an effect as the values are read by startProcessing().
     * 
     * @param pollFrequency
     *            Polling frequency.
     * @param unit
     *            Unit of the polling frequency.
     */
    public final synchronized void setPollFrequency(long pollFrequency,
            TimeUnit unit) {
        this.pollFrequency = pollFrequency;
        this.pollFrequencyUnit = unit;
    }
    
    /**
     * Sets the polling period in seconds from the
     * optional operator parameter {@code float64} parameter {@code period}.
     * Resolution from the value is milliseconds.
     * @param period Polling period in seconds.
     */
    @Parameter(optional=true,
            description="Polling period in seconds. Tuples will be fetched every `period` seconds.")
    public void setPeriod(double period) {
        setPollFrequency((long) (period * 1000.0), TimeUnit.MILLISECONDS);
    }

    private ScheduledFuture<?> future;
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void initialize(OperatorContext context) throws Exception {
        super.initialize(context);
    }
    
    /**
     * {@inheritDoc}
     * <P>
     * Starts processing by scheduling a fixed rate task that will call
     * fetchTuples() at the configured poll frequency.
     * </P>
     */
    @Override
    public synchronized void allPortsReady() throws Exception {
        
        final long delay = getPollFrequencyUnit().convert(
                getInitialDelay(), getInitialDelayUnit());
        
        trace.log(TraceLevel.DEBUG, "initialDelay="+getInitialDelay()+" "+getInitialDelayUnit());
        trace.log(TraceLevel.DEBUG, "pollFrequency="+getPollFrequency()+" "+getPollFrequencyUnit());
        trace.log(TraceLevel.DEBUG, "delay="+delay);
        
        final Runnable tupleFetcher = new InvokeFetchTuples();
        final Runnable scheduledTupleFetcher;
        final ConsistentRegionContext crc = getOperatorContext().getOptionalContext(ConsistentRegionContext.class);
        if (crc == null) {
            scheduledTupleFetcher = tupleFetcher;          
        } else {
            scheduledTupleFetcher = new Runnable() {

                @Override
                public void run() {
                    if (crc.getSubmissionSemaphore().tryAcquire()) {
                        try {
                            tupleFetcher.run();  
                        } finally {
                            crc.getSubmissionSemaphore().release();
                        }
                    }                  
                }
                
            };
        }

        future = getOperatorContext().getScheduledExecutorService()
                .scheduleAtFixedRate(scheduledTupleFetcher,
                                delay, getPollFrequency(), getPollFrequencyUnit());
    }
    
    private class InvokeFetchTuples implements Runnable {
        @Override
        public void run() {
            if (trace.isLoggable(TraceLevel.TRACE))
                trace.log(TraceLevel.TRACE,
                        PollingTupleProducer.this.getClass().getName()+ ".fetchTuples()");
            try {
                fetchTuples();
            } catch (Exception e) {
                trace.log(TraceLevel.ERROR, e.toString(), e);
                throw new RuntimeException(e);
            }
        }
    }
        
    /**
     * Instead of using <code>TupleProducer.startProcessing</code>
     * to implement the initial delay, use the delay parameter of
     * <code>ScheduledExecutorService.scheduleAtFixedRate</code>.
     * 
     * @see ScheduledExecutorService#scheduleAtFixedRate(Runnable, long, long, TimeUnit)
     * @see TupleProducer#allPortsReady()
     */
    @Override
    protected final void startProcessing()
    {
    }

    /**
     * Called periodically to fetch tuples from an external source and submit
     * them to the output stream(s). Implementations will typically access
     * the external source to fetch the available data, create OutputTuples
     * based upon the data, submit them to the output ports and then return.
     * <BR>
     * Implementation must not block.
     * <P>
     * When in a {@link ConsistentRegionContext consistent region} a
     * submission permit is acquired before {@code fetchTuples()} is
     * invoked and released once it completes.
     * </P>
     */
    protected abstract void fetchTuples() throws Exception;
    
    /**
     * Complete the operator by canceling the periodic task
     * that calls <code>fetchTuples</code>.
     */
    protected synchronized void complete() throws Exception {
        if (future != null) {
            future.cancel(false);
            future = null;
        } 
    }

    /**
     * Complete this operator by canceling the
     * periodic task that implements the polling.
     * <P>
     * Sub-classes <b>must</b> call
     * <code>super.shutdown()</code> if they override this method.
     * </P>
     */
    @Override
    public void shutdown() throws Exception {
        complete();
        super.shutdown();
    }
}
