/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2014  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.patterns;

import com.ibm.streams.operator.OperatorContext;

/**
 * Abstract pattern class for an operator that produces tuples on output
 * streams using a single process method.
 * 
 * @see #process()
 */
public abstract class ProcessTupleProducer extends TupleProducer {
   
    private Thread processThread;
    
    /**
     * {@inheritDoc}
     * Create the non-daemon thread used to call the process() method.
     * The thread is created during initialization to ensure that the SPL runtime
     * will wait upon its completion before completing the operator.
     * The thread is started by <code>startProcessing</code> which
     * means the initial delay support provided by the super-class
     * <code>TupleProducer</code> is honored.
     * 
     */
    @Override
    public synchronized void initialize(OperatorContext context) throws Exception {
        super.initialize(context);
        
        /*
         * Create the thread at initialize time but do not start it.
         * The thread will be started by startProcessing() which will
         * be called at allPortsReady() time if no delay is specified,
         * otherwise it will be called once the delay has expired.
         */
        processThread = getOperatorContext().getThreadFactory().newThread(
                new Runnable() {

                    @Override
                    public void run() {
                        try {
                            process();
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    
                });
        
        /*
         * Set the thread not to be a daemon to ensure that the SPL runtime
         * will wait for the thread to complete before determining the
         * operator is complete.
         */
        processThread.setDaemon(false);
    }
    
    /**
     * Disallow use of deprecated method by a sub-class.
     * @deprecated
     */
    @Override
    protected final void producerInitialize() {
    }


    /**
     * Starts processing by starting the thread that will
     * call process().
     */
    protected synchronized void startProcessing() {
        processThread.start();
    }
    
    /**
     * Sub-classes provide a process() method that submits tuples
     * on the operator's output ports.
     * <BR>
     * When this method returns the the operator will complete.
     * <P>
     * It is guaranteed that the <code>initialize()</code> method <i>happens-before</i>
     * the <code>process()</code> method for purposes of memory visibility.
     * </P>
     * 
     * @throws Exception Exception is sub-class processing
     */
    protected abstract void process() throws Exception;

    /**
     * Shutdown this operator, which will interrupt the thread
     * executing the <code>process()</code> method.
     * <P>
     * Sub-classes <b>must</b> call
     * <code>super.shutdown()</code> if they override this method.
     * </P>
     */
    @Override
    public synchronized void shutdown() throws Exception {
        if (processThread != null) {
            processThread.interrupt();
            processThread = null;
        }
        
        super.shutdown();
    }
}
