/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.patterns;

import com.ibm.streams.operator.AbstractOperator;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.StreamSchema;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.InputPorts;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;
import com.ibm.streams.operator.model.OutputPorts;

/**
 * Abstract pattern class for an operator that receives a tuple and then
 * optionally submits a tuple. This pattern supports a number of input streams
 * and a single output stream. A sub-class provides optional filtering and
 * transformation.
 */
@InputPorts(@InputPortSet)
@OutputPorts(@OutputPortSet(cardinality=1,windowPunctuationOutputMode=WindowPunctuationOutputMode.Preserving))
public abstract class TupleInTupleOut extends AbstractOperator {
    /* begin_generated_IBM_copyright_code */
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                              "
            + " 5724-Y95                                                        "
            + " (C) Copyright IBM Corp.  2008, 2010    All Rights Reserved.     "
            + " US Government Users Restricted Rights - Use, duplication or     "
            + " disclosure restricted by GSA ADP Schedule Contract with         "
            + " IBM Corp.                                                       "
            + "                                                                 ";

    /* end_generated_IBM_copyright_code */

    /**
     * Initialize this operator. Called once before any tuples are processed.
     * Sub-classes must call super.initialize(context) to correctly setup an
     * operator.
     */
    @Override
    public void initialize(OperatorContext context) throws Exception {
        super.initialize(context);
    }

    /**
     * Get the output schema for the single output port.
     */
    public final StreamSchema getOutputSchema() {
        return getOutput().getStreamSchema();
    }

    /**
     * Get the single output.
     */
    public final StreamingOutput<OutputTuple> getOutput() {
        return getOutput(0);
    }

    /**
     * Called when a tuple is received on the input port. First filter() is
     * called on the incoming tuple, if that returns true transform() will be
     * called otherwise no further action is taken.
     */
    @Override
    public final void process(StreamingInput<Tuple> inputStream, Tuple tuple)
            throws Exception {

        if (!filter(inputStream, tuple))
            return;

        StreamingOutput<OutputTuple> outStream = getOutput();

        OutputTuple outTuple = outStream.newTuple();

        if (transform(inputStream, tuple, outTuple))
            outStream.submit(outTuple);
    }

    /**
     * Perform any filtering rules on the incoming tuple. This implementation
     * returns true. <BR>
     * Sub-classes override this method to provide specific filtering.
     * 
     * @param inputStream
     * @param tuple
     * @return True to continue processing this tuple and call transform, false
     *         to stop processing this tuple and do not send any output tuples.
     */
    protected boolean filter(StreamingInput<Tuple> inputStream, Tuple tuple) {
        return true;
    }

    /**
     * Perform any required transformation.
     * 
     * @param inputStream
     * @param tuple
     *            Incoming tuple.
     * @param outTuple
     *            An empty tuple.
     * @return True to send outTuple, false to not send the tuple.
     * @throws Exception
     */
    protected abstract boolean transform(StreamingInput<Tuple> inputStream,
            Tuple tuple, OutputTuple outTuple) throws Exception;
}
