/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2014  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.patterns;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

import com.ibm.streams.operator.AbstractOperator;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.Parameter;

/**
 * Abstract pattern class for an operator that produces tuples
 * (a <em>source operator</em>) and typically does not
 * support input ports. This class provides support for an initial
 * delay, allowing submission of tuples to occur a period of time
 * after {@link #allPortsReady()} is called by the SPL runtime.
 * This class calls the abstract method {@link #startProcessing()}
 * to indicate to the sub-class that it can begin to submit tuples.
 * <P>
 * If the operator parameter {@link #setInitDelay(long) initDelay} is set then it is taken as the
 * number of seconds before {@link #startProcessing()} is called. <BR>
 * The initial delay can also be set using the methods on this class to allow
 * delays to be specified in different units.
 * </P>
 * <P>
 * While source operators typically do not have input ports, sub-classes
 * may support input ports and implement
 * {@link #process(com.ibm.streams.operator.StreamingInput, com.ibm.streams.operator.Tuple) tuple processing}.
 * Typically these input ports are {@link InputPortSet#controlPort() control ports} that allow
 * updates how the operator fetches its tuples as changing a database connection string.
 * </P>
 */
public abstract class TupleProducer extends AbstractOperator {
    /* begin_generated_IBM_copyright_code */
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                              "
            + " 5724-Y95                                                        "
            + " (C) Copyright IBM Corp.  2009, 2009    All Rights Reserved.     "
            + " US Government Users Restricted Rights - Use, duplication or     "
            + " disclosure restricted by GSA ADP Schedule Contract with         "
            + " IBM Corp.                                                       "
            + "                                                                 ";
    /* end_generated_IBM_copyright_code */

    private long initialDelay = 0;
    private TimeUnit initialDelayUnit = TimeUnit.SECONDS;

    /**
     * ScheduledFuture of the call to startProcessing() when the initial delay
     * is non-zero.
     */
    private ScheduledFuture<?> startProcessingFuture;

    /**
     * {@inheritDoc}
    */
    @Override
    public void initialize(OperatorContext context)
            throws Exception {
        super.initialize(context);

        producerInitialize();
    }
    
    /**
     * Set the initial delay from the operator parameter
     * {@code initDelay} in seconds.
     * @param delaySeconds Delay in seconds before starting processing.
     */
    @Parameter(optional=true,
            description="Delay in seconds before the operator starts producing tuples.")
    public void setInitDelay(long delaySeconds) {
        setInitialDelay(delaySeconds, TimeUnit.SECONDS);
    }
    
    /**
     * Set the initial delay in seconds.
     * This method may be used by sub-classes to provide
     * an {@code initDelay} parameter of type {@code float64}.
     * This is achieved by hiding {@link #setInitDelay(long)}
     * in the sub-class and create a public
     * annotated version of {@link #setInitDelay(double)}.
     * <pre>
     * <code>
     * // hide the version annotated with {@literal @}Parameter
     * public void setInitDelay(long delay) { super.setInitDelay(delay); }
     * 
     * // Annotated version to create an initDelay parameter of type float64.
     * {@literal @}Parameter(optional=true,
            description="Delay in seconds before the operator starts producing tuples.")
     * public void setInitDelay(double delay) { super.setInitDelay(delay); }
     * </code>
     * </pre>
     * 
     * @param delaySeconds Delay in seconds before starting processing. This is converted to milliseconds
     * resulting in a call to
     * {@link #setInitialDelay(long, TimeUnit) setInitialDelay(delaySeconds * 1000.0, TimeUnit.MILLISECONDS)}. 
     */
    protected void setInitDelay(double delaySeconds) {
        long delayms = (long) (delaySeconds * 1000.0);
        this.setInitialDelay(delayms, TimeUnit.MILLISECONDS);
    }

    /**
     * {@inheritDoc}
     * <P>
     * Calls {@link #startProcessing()} method immediately if
     * initial delay is zero, otherwise asynchronously calls
     * {@code startProcessing()} after the required
     * initial delay.
     * </P>
     */
    @Override
    public synchronized void allPortsReady() throws Exception {

        if (getInitialDelay() == 0) {
            startProcessing();
            return;
        }

        // Kick off asynchronously a call to startProcessing() after the initial
        // delay has expired.
        startProcessingFuture = getOperatorContext()
                .getScheduledExecutorService().schedule(new Callable<Object>() {

                    public Object call() throws Exception {
                        startProcessing();
                        return null;
                    }
                }, getInitialDelay(), getInitialDelayUnit());
    }

    /**
     * Initialize this operator. Called during <code>initialize()</code>.
     * @deprecated Sub-classes should instead override {@link #initialize(OperatorContext)}
     * to be consistent with {@link AbstractOperator}.
     * 
     * @see AbstractOperator#initialize(OperatorContext)
     */
    protected void producerInitialize() throws Exception {
    }

    /**
     * Cancel the startProcessing() task if it was asynchronously kicked off due
     * to an initial delay and has not yet started.
     * <P>
     * Sub-classes <b>must</b> call
     * <code>super.shutdown()</code> if they override this method.
     * </P>
     */
    public synchronized void shutdown() throws Exception {

        if (startProcessingFuture != null) {
            if (!startProcessingFuture.isDone())
                startProcessingFuture.cancel(true);
        }
        super.shutdown();
    }

    /**
     * Get the initial delay. The default value is 0 but is overwritten by the
     * value (in seconds) of the initDelay parameter. The initDelay parameter is
     * read prior to {@link #initialize(OperatorContext)}.
     * 
     * @return Value of the initial delay.
     */
    public final synchronized long getInitialDelay() {
        return initialDelay;
    }

    /**
     * Get the unit of the initial delay. Defaults to SECONDS.
     * 
     * @return Unit for the initial delay.
     */
    public final synchronized TimeUnit getInitialDelayUnit() {
        return initialDelayUnit;
    }

    /**
     * Set the initial delay for processing tuples from the external source.
     * Sub-classes may call this from {@link #initialize(OperatorContext)} to override the
     * default.
     * 
     * @param initialDelay Value for the initial delay
     * @param unit Unit for {@code initialDelay}.
     */
    public final synchronized void setInitialDelay(long initialDelay,
            TimeUnit unit) {
        this.initialDelay = initialDelay;
        this.initialDelayUnit = unit;
    }

    /**
     * Called to indicate that the operator can start submitting tuples.
     * It will be called after any configured initial delay.
     * This method is required to return immediately to the SPL
     * runtime, by starting the processing to fetch tuples asynchronously,
     * this may be achieved using the OperatorContext's ScheduledExecutorService
     * or starting a thread created using the OperatorContext's ThreadFactory
     * during producerInitialize().
     * 
     */
    protected abstract void startProcessing() throws Exception;
}
