package com.ibm.streams.operator.samples.sinks;
import com.ibm.streams.operator.metrics.Metric.Kind;
import com.ibm.streams.operator.model.InputPortSet.WindowMode;
import com.ibm.streams.operator.model.InputPortSet.WindowPunctuationInputMode;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;

@com.ibm.streams.operator.model.PrimitiveOperator(namespace="com.ibm.streams.javaprimitivesamples.sinks", name="HTTPPost", description="Sink operator where incoming tuples are sent as an HTTP POST requests to the URL specified in the operator specific `url` parameter.", comment=" Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2009, 2009    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ")
@com.ibm.streams.operator.model.InputPortSet()
@com.ibm.streams.operator.internal.model.ShadowClass("com.ibm.streams.operator.samples.sinks.HttpPOST")
@javax.annotation.Generated("com.ibm.streams.operator.internal.model.processors.ShadowClassGenerator")
public class HttpPOST$StreamsModel extends com.ibm.streams.operator.AbstractOperator
 {

@com.ibm.streams.operator.model.Parameter(optional=true, description="Set the batch size.")
@com.ibm.streams.operator.internal.model.MethodParameters({"batchSize"})
public void setBatchSize(int batchSize) {}

@com.ibm.streams.operator.model.Parameter(name="url", description="HTTP URL of the server to POST data to.")
@com.ibm.streams.operator.internal.model.MethodParameters({"urlPath"})
public void setUrlPath(java.lang.String urlPath) {}

@com.ibm.streams.operator.model.CustomMetric(description="Number of HTTP POST requests", kind=Kind.COUNTER)
@com.ibm.streams.operator.internal.model.MethodParameters({"nPostRequests"})
public void setnPostRequests(com.ibm.streams.operator.metrics.Metric nPostRequests) {}

@com.ibm.streams.operator.model.CustomMetric(description="Number of HTTP POST requests with error response", kind=Kind.COUNTER)
@com.ibm.streams.operator.internal.model.MethodParameters({"nPostErrorCodeResponses"})
public void setnPostErrorCodeResponses(com.ibm.streams.operator.metrics.Metric nPostErrorCodeResponses) {}
}