/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2015  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.sources;

import java.util.Random;
import java.util.logging.Logger;

import com.ibm.streams.operator.Attribute;
import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;
import com.ibm.streams.operator.model.OutputPorts;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.operator.model.PrimitiveOperator;
import com.ibm.streams.operator.samples.patterns.PollingSingleTupleProducer;
import com.ibm.streams.operator.samples.state.Counter;
import com.ibm.streams.operator.state.Checkpoint;
import com.ibm.streams.operator.state.DelegateStateHandler;

/**
 * Sample source operator that creates a tuple with random values
 * on its single output port according to the defined period. 
 * <BR>
 * Accepts an optional int64 parameter {@code seed} as the seed for
 * the random value generator.
 * <P>
 * This operator provided as the sample Java primitive operator
 * <BR>
 * {@code com.ibm.streams.javaprimitivesamples.sources.RandomBeacon}
 * <BR>
 * in the sample {@code JavaOperators} toolkit located in:
 * <BR>
 * {@code $STREAMS_INSTALL/samples/spl/feature/JavaOperators}
 * </P>
 */
@PrimitiveOperator(description="Sample source operator that creates a tuple with random values on its single output port according to the defined period.",
        comment=RandomBeacon.IBM_COPYRIGHT)
@OutputPorts(
    {@OutputPortSet(cardinality=1,windowPunctuationOutputMode=WindowPunctuationOutputMode.Generating,
            description="Port that produces the generated tuples with random attribute values")})
public class RandomBeacon extends PollingSingleTupleProducer {
    /* begin_generated_IBM_copyright_code */
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                              "
            + " 5724-Y95                                                        "
            + " (C) Copyright IBM Corp.  2009, 2009    All Rights Reserved.     "
            + " US Government Users Restricted Rights - Use, duplication or     "
            + " disclosure restricted by GSA ADP Schedule Contract with         "
            + " IBM Corp.                                                       "
            + "                                                                 ";
    /* end_generated_IBM_copyright_code */
 
    protected Random rand;
    private long seed = System.currentTimeMillis();
    
    @Parameter(optional=true, description="Seed for the random number generator.")
    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return seed;
    }
    /**
     * Take the seed for the random number generator from the parameter
     * {@code seed} if it exists, otherwise use the current time.
     * Logs the seed to allow replay of generated values.
     */
    @Override
    public synchronized void initialize(OperatorContext context) throws Exception
    {
        super.initialize(context);       
        rand = new Random(getSeed());
        Logger.getAnonymousLogger().info("Random(seed)=" + getSeed());
    }

    /**
     * Set each attribute to a random value and then return true to
     * submit the tuple.
     * <P>
     * A sub-class may override this method to set specific
     * attributes while generating random values for the
     * remaining attributes.
     * An example is provided in {@link RandomBeaconWithTimestamp}.
     * </P>
     */
    @Override
    protected synchronized boolean fetchSingleTuple(final OutputTuple tuple) throws Exception {
        
        for (Attribute attribute : tuple.getStreamSchema()) {

            Object value = attribute.getType().randomValue(rand);

            tuple.setObject(attribute.getName(), value);
        }
        
        // Always submit the tuple
        return true;
    }
    
    
    @Override
    protected DelegateStateHandler<Counter> getStateHandler(Counter counter) {
        return new DelegateStateHandler<Counter>(counter) {
            @Override
            public synchronized void resetToInitialState() throws Exception {
                super.resetToInitialState();
                rand = new Random(getSeed());
            }
            
            @Override
            public synchronized void checkpoint(Checkpoint checkpoint) throws Exception {
                super.checkpoint(checkpoint);
                checkpoint.getOutputStream().writeObject(rand);
            }
            
            @Override
            public synchronized void reset(Checkpoint checkpoint) throws Exception {
                super.reset(checkpoint);
                rand = (Random) checkpoint.getInputStream().readObject();
            }
        };
    }
}
