package com.ibm.streams.operator.samples.sources;
import com.ibm.streams.operator.metrics.Metric.Kind;
import com.ibm.streams.operator.model.InputPortSet.WindowMode;
import com.ibm.streams.operator.model.InputPortSet.WindowPunctuationInputMode;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;

@com.ibm.streams.operator.model.OutputPorts(value={@com.ibm.streams.operator.model.OutputPortSet(cardinality=1, windowPunctuationOutputMode=WindowPunctuationOutputMode.Generating, description="Port that produces the generated tuples with random attribute values")})
@com.ibm.streams.operator.model.PrimitiveOperator(namespace="com.ibm.streams.javaprimitivesamples.sources", description="Sample source operator that creates a tuple with random values and a timestamp.", comment=" Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2009, 2009    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ")
@com.ibm.streams.operator.internal.model.ShadowClass("com.ibm.streams.operator.samples.sources.RandomBeaconWithTimestamp")
@javax.annotation.Generated("com.ibm.streams.operator.internal.model.processors.ShadowClassGenerator")
public class RandomBeaconWithTimestamp$StreamsModel extends com.ibm.streams.operator.AbstractOperator
 {

@com.ibm.streams.operator.model.Parameter(optional=true, description="Delay in seconds before the operator starts producing tuples.")
@com.ibm.streams.operator.internal.model.MethodParameters({"delaySeconds"})
public void setInitDelay(long delaySeconds) {}

@com.ibm.streams.operator.model.Parameter(optional=true, description="Polling period in seconds. Tuples will be fetched every `period` seconds.")
@com.ibm.streams.operator.internal.model.MethodParameters({"period"})
public void setPeriod(double period) {}

@com.ibm.streams.operator.model.Parameter(optional=true, description="The number of tuples to submit. Negative value or zero means continually fetch and submit tuples.")
@com.ibm.streams.operator.internal.model.MethodParameters({"iterations"})
public void setIterations(int iterations) {}

@com.ibm.streams.operator.model.Parameter(optional=true, description="Seed for the random number generator.")
@com.ibm.streams.operator.internal.model.MethodParameters({"seed"})
public void setSeed(long seed) {}
}