/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2011, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.sources;

import com.ibm.streams.operator.OperatorContext.ContextCheck;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.compile.OperatorContextChecker;
import com.ibm.streams.operator.model.PrimitiveOperator;
import com.ibm.streams.operator.types.Timestamp;

/**
 * Sample source operator that creates a tuple with random values
 * and a timestamp.
 * Extension of {@link RandomBeacon} that assumes the output schema
 * has a <code>timestamp ts</code> attribute, and sets it to
 * the current time when the tuple was submitted. All other attributes
 * in the output tuple are set to random values by the parent.
 * <P>
 * This operator provided as the sample Java primitive operator
 * <BR>
 * {@code com.ibm.streams.javaprimitivesamples.sources.RandomBeaconWithTimestamp}
 * <BR>
 * in the sample {@code JavaOperators} toolkit located in:
 * <BR>
 * {@code $STREAMS_INSTALL/samples/spl/feature/JavaOperators}
 * </P>
 */
@PrimitiveOperator(description="Sample source operator that creates a tuple with random values and a timestamp.",
        comment=RandomBeaconWithTimestamp.IBM_COPYRIGHT)
public class RandomBeaconWithTimestamp extends RandomBeacon {
    /* begin_generated_IBM_copyright_code */
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                              "
            + " 5724-Y95                                                        "
            + " (C) Copyright IBM Corp.  2009, 2009    All Rights Reserved.     "
            + " US Government Users Restricted Rights - Use, duplication or     "
            + " disclosure restricted by GSA ADP Schedule Contract with         "
            + " IBM Corp.                                                       "
            + "                                                                 ";
    /* end_generated_IBM_copyright_code */

    /**
     * Check that the output port schema
     * contains an attribute {@code ts} of
     * type {@code timestamp}.
     */
    @ContextCheck
    public static void checkTsAttribute(OperatorContextChecker checker) {
        final StreamingOutput<?> port = checker.getOperatorContext().getStreamingOutputs().get(0);
        checker.checkAttributes(port, false, "tuple<timestamp ts>");
    }
    
    /**
     * Use the parent-class's <code>fetchSingleTuple</code>
     * and then overwrites the <code>ts</code> attribute's value
     * with a current timestamp.
     */
    @Override
    protected boolean fetchSingleTuple(final OutputTuple tuple) throws Exception {
    	
    	super.fetchSingleTuple(tuple);
        
    	tuple.setTimestamp("ts", Timestamp.currentTime());
    	
        // Always submit the tuple
        return true;
    }
}
