package com.ibm.streams.operator.samples.sources;
import com.ibm.streams.operator.metrics.Metric.Kind;
import com.ibm.streams.operator.model.InputPortSet.WindowMode;
import com.ibm.streams.operator.model.InputPortSet.WindowPunctuationInputMode;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;

@com.ibm.streams.operator.model.PrimitiveOperator(namespace="com.ibm.streams.javaprimitivesamples.sources", description="Submits an output tuple for each Java system property.", comment=" Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2009, 2009    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ")
@com.ibm.streams.operator.model.OutputPorts(value={@com.ibm.streams.operator.model.OutputPortSet(cardinality=1, windowPunctuationOutputMode=WindowPunctuationOutputMode.Generating, description="Port requiring `name` and `value` attributes representing a system property. Optional `tags` attribute containing tags for the property")})
@com.ibm.streams.operator.internal.model.ShadowClass("com.ibm.streams.operator.samples.sources.SystemPropertySource")
@javax.annotation.Generated("com.ibm.streams.operator.internal.model.processors.ShadowClassGenerator")
public class SystemPropertySource$StreamsModel extends com.ibm.streams.operator.AbstractOperator
 {

@com.ibm.streams.operator.model.Parameter(optional=true, description="Delay in seconds before the operator starts producing tuples.")
@com.ibm.streams.operator.internal.model.MethodParameters({"delaySeconds"})
public void setInitDelay(long delaySeconds) {}

@com.ibm.streams.operator.model.Parameter(optional=true, description="Prefix for property names to be tagged with the value of `tags`.")
@com.ibm.streams.operator.internal.model.MethodParameters({"tagged"})
public void setTagged(java.lang.String tagged) {}

@com.ibm.streams.operator.model.Parameter(optional=true, description="Tags to set in `tags` output attribute when the property name starts with the value of `taggged`.")
@com.ibm.streams.operator.internal.model.MethodParameters({"tags"})
public void setTags(java.util.List<java.lang.String> tags) {}
}