/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2020  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.sources;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OperatorContext.ContextCheck;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.StreamingData.Punctuation;
import com.ibm.streams.operator.compile.OperatorContextChecker;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPorts;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.operator.model.PrimitiveOperator;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;
import com.ibm.streams.operator.samples.patterns.ProcessTupleProducer;
import com.ibm.streams.operator.state.ConsistentRegionContext;

/**
 * Sample source operator using a {@code process()} method.
 * Operator that reads the Java System property set
 * and submits an output tuple for each system property.
 * A single output port is assumed with attributes
 * {@code name} for the property name,
 * {@code value} for its value and
 * {@code tags} for a set of tags set from parameters.
 * <P>
 * The class handles two parameters to provide a simple tagging scheme.
 * This is used to demonstrate parameter handling.
 * <BR>
 * If the parameter <code>tagged</code> is set then any tuple for
 * a system property that starts with <code>tagged</code>'s value will
 * have its <code>tags</code> attribute set to the value of the
 * <code>tags</code> parameter.
 * </P>
 * <P>
 * The parameter <code>initDelay</code> is inherited from
 * the parent class TupleProducer.
 * </P>
 * <P>
 * This operator provided as the sample Java primitive operator
 * <BR>
 * {@code com.ibm.streams.javaprimitivesamples.sources.SystemPropertySource}
 * <BR>
 * in the sample {@code JavaOperators} toolkit located in:
 * <BR>
 * {@code $STREAMS_INSTALL/samples/spl/feature/JavaOperators}
 * </P>
 * 
 * @see com.ibm.streams.operator.samples.patterns.TupleProducer
 */
@PrimitiveOperator(description="Submits an output tuple for each Java system property.",
        comment=SystemPropertySource.IBM_COPYRIGHT)
@OutputPorts({@OutputPortSet(cardinality=1,windowPunctuationOutputMode=WindowPunctuationOutputMode.Generating,
        description="Port requiring `name` and `value` attributes representing a system property. Optional `tags` attribute containing tags for the property")})
public class SystemPropertySource extends ProcessTupleProducer {
    
    private String tagged;

    private Set<String> tags;
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void initialize(OperatorContext context)
            throws Exception {
        super.initialize(context);
    }
    
    /**
     * If parameter {@code tagged} is set then {@code tags} is required.
     * @param checker Checker for this invocation
     */
    @ContextCheck
    public static void checkTaggedParameters(OperatorContextChecker checker) {
        checker.checkDependentParameters("tagged", "tags");
        OperatorContext context = checker.getOperatorContext();
        if (context.getParameterNames().contains("tagged")) {
            checker.checkRequiredAttributes(
                    context.getStreamingOutputs().get(0), "tags");
        }
    }
    
    /**
     * Check the output attributes name and value are present.
     */
    @ContextCheck
    public static void checkOuputAttributes(OperatorContextChecker checker) {
        OperatorContext context = checker.getOperatorContext();
        checker.checkRequiredAttributes(
                context.getStreamingOutputs().get(0), "name", "value");
    }
    
    /**
     * Set the tagged parameter.
     * @param tagged Prefix indicated tagged system properties.
     */
    @Parameter(optional=true, description="Prefix for property names to be tagged with the value of `tags`.")
    public void setTagged(String tagged) {
        this.tagged = tagged;
    }
    
    /**
     * Set the tags parameter.
     * @param tags Tags to be associated with tagged properties.
     */
    @Parameter(optional=true,
            description="Tags to set in `tags` output attribute when the property name starts with the value of `taggged`.")
    public void setTags(List<String> tags) {
        this.tags = new HashSet<String>(tags);
    }
    
    @Override
    protected void process() throws Exception {
        
        final ConsistentRegionContext crc =
                getOperatorContext().getOptionalContext(ConsistentRegionContext.class);
        
        // makeConsistent requires a permit is held.
        if (crc != null)
            crc.acquirePermit();
        
        while (!Thread.interrupted()) {

            getPropertiesAndSubmit();
            if (crc == null) {
                // Finite set of properties so send a final mark.
                getOutput(0).punctuate(Punctuation.FINAL_MARKER);
                break;
            } else {
                // Make the region consistent.
                if (crc.makeConsistent()) {
                    break;
                }
                // else resubmit the tuples by continuing the while statement.
            }
        }
        if (crc != null)
            crc.releasePermit();
    }
    
    /**
     * Iterate over all the system properties submitting
     * a tuple for each name value pair.
     */
    protected void getPropertiesAndSubmit() throws Exception {
        
        final StreamingOutput<OutputTuple> out = getOutput(0);
        for (Enumeration<?> e = System.getProperties().propertyNames();
            e.hasMoreElements(); )
        {
            String name = (String) e.nextElement();
            String value = System.getProperty(name);
            
            OutputTuple tuple = out.newTuple();
            
            tuple.setString("name", name);
            tuple.setString("value", value);
            
            // Add the simple tagging in, if set.
            if (tagged != null) {
                if (name.startsWith(tagged))
                    tuple.setSet("tags", tags);
            }
            
            out.submit(tuple);
        }
        
        // Make the set of tuples a window.
        out.punctuate(Punctuation.WINDOW_MARKER);
    }
}
