/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2014, 2016  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.state;

import java.io.IOException;
import java.io.Serializable;

import com.ibm.streams.operator.state.Checkpoint;
import com.ibm.streams.operator.state.StateHandler;

/**
 * Generic typed {@link StateHandler} for 
 *
 * @param <T> Type of the state, instances of the state must implement
 * {@code java.io.Serializable}.
 * 
 * @since InfoSphere&reg; Streams Version 4.0
 */
public class OperatorState<T> implements StateHandler {
    
    private final Class<T> stateClass; 
    private T state;
    
    public OperatorState(Class<T> stateClass) {
        this.stateClass = stateClass;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void drain() throws Exception {
    }

    @Override
    public void reset(Checkpoint checkpoint) throws Exception {
        setState(stateClass.cast(checkpoint.getInputStream().readObject()));
    }

    @Override
    public void checkpoint(Checkpoint checkpoint) throws Exception {
        checkpoint.getOutputStream().writeObject(getState());
    }

    @Override
    public void retireCheckpoint(long id) throws Exception {
    }

    @Override
    public void resetToInitialState() {
        setState(null);
    }

    public void setState(T state) {
        if (state != null && !(state instanceof Serializable))
            throw new IllegalArgumentException();
        
        this.state = state;
    }
    
    public T getState() {
        return state;
    }
}
