/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2011  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.windows;

import java.math.BigDecimal;
import java.math.MathContext;

import com.ibm.streams.operator.Attribute;
import com.ibm.streams.operator.OutputTuple;
import com.ibm.streams.operator.StreamingData;
import com.ibm.streams.operator.StreamingOutput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.window.StatefulWindowListener;
import com.ibm.streams.operator.window.StreamWindow;
import com.ibm.streams.operator.window.StreamWindowEvent;

/**
 * Sample window listener to demonstrate window aggregation on a decimal attribute.
 * This class incrementally maintains the number of tuples in the window
 * and the sum of a decimal attribute in the AggregateInfo class. As tuples
 * are inserted their attribute's values are added to the sum and subtracted
 * from the sum as they are evicted.
 * <BR>
 * Through the facilities of StatefulWindowListener this class supports
 * partitioned and non-partitioned windows. An AggregateInfo is maintained
 * for each partition.
 * <BR>
 * Sliding and tumbling windows are supported. The trigger for a sliding
 * window or the eviction for a tumbling window results in a output tuple
 * being delivered to the specified output port. The attributes <code>sum</code>
 * and <code>count</code> will be set to the sum and count values respectively.
 * Each output tuple will be followed by a
 * {@link com.ibm.streams.operator.StreamingData.Punctuation#WINDOW_MARKER WINDOW_MARKER} punctuation mark.
 * The class supports all window definitions.
 */
public class DecimalSumAggregatorListener extends
        StatefulWindowListener<DecimalSumAggregatorListener.AggregateInfo, Tuple> {

    /**
     * Attribute being aggregated.
     */
    protected final String attributeName;

    /**
     * Math context used for arithmetic. Set from the context of the attribute
     * being aggregated.
     */
    protected final MathContext mc;
    
    /**
     * Output port tuples containing the aggregate values are delivered to.
     */
    protected final StreamingOutput<OutputTuple> outputPort;
    
    /**
     * 
     * @param window
     * @param attributeName
     * @param outputPort
     */

    public DecimalSumAggregatorListener(StreamWindow<Tuple> window,
            String attributeName,
            StreamingOutput<OutputTuple> outputPort) {
        super(window);

        this.attributeName = attributeName;
        this.outputPort = outputPort;

        Attribute attr = window.getInputPort().getStreamSchema().getAttribute(
                attributeName);

        mc = attr.getType().getMetaType().getMathContext();
    }

    /**
     * Class for the per-partition state for the aggregate.
     *
     */
    public static class AggregateInfo {
        /**
         * Sum of the attribute's value for tuples in the window.
         */
        public BigDecimal sum = BigDecimal.ZERO;
        
        /**
         * Number of tuples in the window.
         */
        public int count;
    }

    /**
     * Create a new AggregateInfo as the initial state.
     */
    @Override
    protected AggregateInfo getInitializedState(Object partition,
            AggregateInfo state) {
        return new AggregateInfo();
    }

    /**
     * Perform window based aggregation with incremental state updates.
     */
    @Override
    public void handleEvent(StreamWindowEvent<Tuple> event) throws Exception {

        AggregateInfo state = getPartitionState(event.getPartition());

        switch (event.getType()) {
        
        case INITIAL_FULL:
            /**
             * Nothing to do, StatefulWindowListener provides a utility method
             * to track if the INITIAL_FULL has occurred on a per-partition
             * basis.
             */
            break;

        case INSERTION:
            /*
             * On insertion update the sum and count with each tuple being
             * inserted by adding its attribute's value to the sum.
             */
            for (Tuple tuple : event.getTuples()) {
                state.sum = state.sum.add(tuple.getBigDecimal(attributeName),
                        mc);
                state.count++;
            }
            break;

        case EVICTION:
            if (getWindow().getType() == StreamWindow.Type.TUMBLING) {
                // No need to maintain the state incrementally,
                // each tumble will allocate a new state via
                // getInitializedState().
                // Just submit the aggregation.
                submitAggregateOutput(state);
                break;
            }
            
            /*
             * Sliding window only.
             * On eviction update the sum and count with each tuple being
             * removed by subtracting its attribute's value from the sum.
             */
            for (Tuple tuple : event.getTuples()) {
                if (mc != null)
                    state.sum = state.sum.subtract(tuple
                            .getBigDecimal(attributeName), mc);
                state.count--;
            }
            break;

        case TRIGGER:
            // Only trigger once a full window has been seen.
            if (!seenInitialFull(event.getPartition()))
                break;
            
            /**
             * Submit the aggregation to the output port.
             */
            submitAggregateOutput(state);
            break;
            
        case FINAL:
            /**
             * Submit the partial aggregation if any tuples
             * remain in the window at final marker time.
             */
            submitAggregateOutput(state);
            outputPort.punctuate(StreamingData.Punctuation.FINAL_MARKER);
            break;
        }
    }
    
    /**
     * Submit the aggregate tuple for this partition.
     * @param state State for a partition.
     * @throws Exception Exception submitting information.
     */
    protected void submitAggregateOutput(AggregateInfo state) throws Exception {
        
        // Only submit output if the window contains tuples.
        if (state.count == 0)
            return;
        
        OutputTuple tuple = outputPort.newTuple();
        setupOutputTuple(tuple, state);
        
        outputPort.submit(tuple);
        outputPort.punctuate(StreamingData.Punctuation.WINDOW_MARKER);
    }
    
    /**
     * Set attributes in the tuple representing the aggregation.
     * Sets the <code>sum</code> and <code>count</code> fields.
     * @param tuple Tuple that will be submitted.
     * @param state Partitioned aggregation state.
     */
    protected void setupOutputTuple(OutputTuple tuple, AggregateInfo state) {
        tuple.setBigDecimal("sum", state.sum);
        tuple.setInt("count", state.count);        
    }
}
