/* begin_generated_IBM_copyright_prolog                             */
/*                                                                  */
/* This is an automatically generated copyright prolog.             */
/* After initializing,  DO NOT MODIFY OR MOVE                       */
/* **************************************************************** */
/* THIS SAMPLE CODE IS PROVIDED ON AN "AS IS" BASIS. IBM MAKES NO   */
/* REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, CONCERNING    */
/* USE OF THE SAMPLE CODE, OR THE COMPLETENESS OR ACCURACY OF THE   */
/* SAMPLE CODE. IBM DOES NOT WARRANT UNINTERRUPTED OR ERROR-FREE    */
/* OPERATION OF THIS SAMPLE CODE. IBM IS NOT RESPONSIBLE FOR THE    */
/* RESULTS OBTAINED FROM THE USE OF THE SAMPLE CODE OR ANY PORTION  */
/* OF THIS SAMPLE CODE.                                             */
/*                                                                  */
/* LIMITATION OF LIABILITY. IN NO EVENT WILL IBM BE LIABLE TO ANY   */
/* PARTY FOR ANY DIRECT, INDIRECT, SPECIAL OR OTHER CONSEQUENTIAL   */
/* DAMAGES FOR ANY USE OF THIS SAMPLE CODE, THE USE OF CODE FROM    */
/* THIS [ SAMPLE PACKAGE,] INCLUDING, WITHOUT LIMITATION, ANY LOST  */
/* PROFITS, BUSINESS INTERRUPTION, LOSS OF PROGRAMS OR OTHER DATA   */
/* ON YOUR INFORMATION HANDLING SYSTEM OR OTHERWISE.                */
/*                                                                  */
/* (C) Copyright IBM Corp. 2010, 2013  All Rights reserved.         */
/*                                                                  */
/* end_generated_IBM_copyright_prolog                               */
package com.ibm.streams.operator.samples.windows;

import java.util.Collections;
import java.util.List;

import com.ibm.streams.operator.OperatorContext;
import com.ibm.streams.operator.OperatorContext.ContextCheck;
import com.ibm.streams.operator.StreamingInput;
import com.ibm.streams.operator.Tuple;
import com.ibm.streams.operator.compile.OperatorContextChecker;
import com.ibm.streams.operator.model.InputPortSet;
import com.ibm.streams.operator.model.InputPortSet.WindowPunctuationInputMode;
import com.ibm.streams.operator.model.OutputPortSet;
import com.ibm.streams.operator.model.OutputPortSet.WindowPunctuationOutputMode;
import com.ibm.streams.operator.model.Parameter;
import com.ibm.streams.operator.model.PrimitiveOperator;
import com.ibm.streams.operator.model.InputPortSet.WindowMode;
import com.ibm.streams.operator.window.AbstractWindowOperator;
import com.ibm.streams.operator.window.StreamWindow;
import com.ibm.streams.operator.window.sort.TumblingWindowSort;

/**
 * Sample ascending sort operator for a tumbling window.
 * Extends {@link AbstractWindowOperator} to ensure all tuples
 * and punctuation are handled by the
 * {@link com.ibm.streams.operator.window.StreamWindowListener StreamWindowListener}.
 * <BR>
 * {@link TumblingWindowSort} is used as the StreamWindowListener with
 * the parameter <code>sortAttributes</code> defining the set of attributes
 * used for ordering. The first attribute in the list is the most significant
 * in the sort order. All the attributes must correspond to a java.lang.Comparable
 * object type.
 * <BR>
 * The optional boolean parameter <code>flushOnFinal</code> indicates if
 * the remaining tuples in the window should be flushed and submitted to
 * the output port in sorted order when a final punctuation mark is received.
 * The default is false which means tuples remaining in the window
 * are discarded upon a final mark. Set to true to flush remaining tuples.
 * <P>
 * Requires a single tumbling windowed input port and a single output port.
 * </P>
 * <P>
 * This operator provided as the sample Java primitive operator
 * <BR>
 * {@code com.ibm.streams.javaprimitivesamples.windows.TumblingSort}
 * <BR>
 * in the sample {@code JavaOperators} toolkit located in:
 * <BR>
 * {@code $STREAMS_INSTALL/samples/spl/feature/JavaOperators}
 * </P>
 */
@PrimitiveOperator(name="TumblingSort",
        description="Sample ascending sort operator for a tumbling window.",
        comment=TumblingSortOperator.IBM_COPYRIGHT)
@InputPortSet(cardinality=1,windowingMode=WindowMode.Windowed,windowPunctuationInputMode=WindowPunctuationInputMode.WindowBound)
@OutputPortSet(cardinality=1,windowPunctuationOutputMode=WindowPunctuationOutputMode.Generating)
public class TumblingSortOperator extends AbstractWindowOperator {
    
    private boolean flushOnFinal = false;
    private List<String> sortAttributes = Collections.emptyList();
    
    /**
     * Perform a tumbling sort using the attributes
     * defined by the SPL parameter sortAttributes.
     * Assumes the operator has a single
     * input port and a single output port.
     * 
     */
    @Override
    public void initialize(OperatorContext context) throws Exception {
        super.initialize(context);
        
        StreamWindow<Tuple> window = getInput(0).getStreamWindow();
        
        new TumblingWindowSort(window, true,
                getSortAttributes(),
                getOutput(0),
                isFlushOnFinal());
    }
    
    /**
     * Check the input port is tumbling.
     */
    @ContextCheck
    public static void requireTumblingWindow(final OperatorContextChecker checker) {
        final StreamingInput<Tuple> inputPort =
            checker.getOperatorContext().getStreamingInputs().get(0);
        checker.checkTumblingWindow(inputPort);
    }

    /**
     * Flush sort buffer when final punctuation mark is processed.
     * @param flushOnFinal True to submit outstanding tuples, false to discard them.
     */
    @Parameter(optional=true,
            description="Flush sort buffer when final punctuation mark is processed."
            )
    public void setFlushOnFinal(boolean flushOnFinal) {
        this.flushOnFinal = flushOnFinal;
    }

    /**
     * True if outstanding tuples are submitted when final markers are processed, false
     * if they are discarded.
     */
    public boolean isFlushOnFinal() {
        return flushOnFinal;
    }

    /**
     * Names of the attributes to perform the sort on.
     * If not supplied then all comparable attributes
     * will be used as the sort key, with priority
     * given to attributes with the lower index.
     */
    @Parameter(optional=true, description="Names of the attributes to perform the sort on. If not supplied then all comparable attributes will be used as the sort key, with priority given to attributes with the lower index.")
    public void setSortAttributes(List<String> sortAttributes) {
        this.sortAttributes = sortAttributes;
    }

    public List<String> getSortAttributes() {
        return sortAttributes;
    }
}
