/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.spl.messages;

import com.ibm.streams.spl.messages.MessageKey;
import com.ibm.streams.spl.messages.MessageUtilities;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Message {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2011, 2019    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private MessageKey key = null;
    private Object[] substitutions = null;

    public Message(MessageKey key) {
        this.key = key;
    }

    public Message(MessageKey key, Object ... substitutions) {
        this.key = key;
        this.substitutions = substitutions;
        if (this.substitutions != null) {
            for (int i = 0; i < this.substitutions.length; ++i) {
                if (this.substitutions[i] == null || !MessageUtilities.containsScript(this.substitutions[i].toString())) continue;
                this.substitutions[i] = MessageUtilities.substCharacterEntities(this.substitutions[i].toString());
            }
        }
    }

    public MessageKey getMessageKey() {
        return this.key;
    }

    public String getMessageId() {
        return this.key.getMessageId();
    }

    public Object[] getSubstitutions() {
        return this.substitutions;
    }

    public Severity getSeverity() {
        String messageId = this.key.getMessageId();
        return Severity.getSeverity(messageId.trim().substring(9, 10));
    }

    public Component getComponent() {
        String messageId = this.key.getMessageId();
        return Component.getComponent(messageId.trim().substring(4, 5));
    }

    public boolean isInformational() {
        return this.getSeverity().equals((Object)Severity.INFORMATIONAL);
    }

    public boolean isWarning() {
        return this.getSeverity().equals((Object)Severity.WARN);
    }

    public boolean isError() {
        return this.getSeverity().equals((Object)Severity.ERROR);
    }

    public boolean isDetail() {
        return this.getSeverity().equals((Object)Severity.DETAIL);
    }

    public String getLocalizedMessage() {
        return MessageUtilities.getMessage(this.key, this.substitutions);
    }

    public String getLocalizedMessage(Locale locale) {
        return MessageUtilities.getMessage(locale, this.key, this.substitutions);
    }

    public String getLocalizedMessageAndPrefix() {
        return this.key.getMessageId() + " " + this.getLocalizedMessage();
    }

    public String getLocalizedMessageAndPrefix(Locale locale) {
        return this.key.getMessageId() + " " + this.getLocalizedMessage(locale);
    }

    public static enum Component {
        CONSOLE("A"),
        BUILD("B"),
        CLI("C"),
        INSTALL("I"),
        SPL("P"),
        RUNTIME("R"),
        IDE("S"),
        TOOLKIT("T"),
        AUDIT("U"),
        SWS("W"),
        UNKNOWN("?");

        private static final Map<String, Component> map;
        private String comp;

        private Component(String comp) {
            this.comp = comp;
        }

        public static Component getComponent(String comp) {
            Component c = map.get(comp);
            return c == null ? UNKNOWN : c;
        }

        static {
            map = new HashMap<String, Component>();
            for (Component c : EnumSet.allOf(Component.class)) {
                map.put(c.comp, c);
            }
        }
    }

    public static enum Severity {
        INFORMATIONAL("I"),
        ERROR("E"),
        WARN("W"),
        DETAIL("D"),
        UNKNOWN("?");

        private static final Map<String, Severity> map;
        private String sev;

        private Severity(String sev) {
            this.sev = sev;
        }

        public static Severity getSeverity(String sev) {
            Severity s = map.get(sev);
            return s == null ? UNKNOWN : s;
        }

        static {
            map = new HashMap<String, Severity>();
            for (Severity s : EnumSet.allOf(Severity.class)) {
                map.put(s.sev, s);
            }
        }
    }
}

