/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.spl.messages;

import com.ibm.streams.spl.messages.MessageKey;

public class MessageKeyBase
implements MessageKey {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2013, 2019    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    private String _messageId;
    private String _bundle;

    public MessageKeyBase(String msgId, String bundle) {
        this._messageId = msgId;
        this._bundle = bundle;
    }

    public MessageKeyBase(String msgId) {
        this._messageId = msgId;
        String messagePrefix = msgId.substring(0, 5);
        if (messagePrefix.equals("CDISR")) {
            this._bundle = "com.ibm.streams.messages.StreamsRuntimeMessages";
        } else if (messagePrefix.equals("CDISA")) {
            this._bundle = "com.ibm.streams.messages.StreamsAdminMessages";
        } else if (messagePrefix.equals("CDISW")) {
            this._bundle = "com.ibm.streams.messages.StreamsSwsMessages";
        } else if (messagePrefix.equals("CDISC")) {
            this._bundle = "com.ibm.streams.messages.StreamsCLIMessages";
        } else if (messagePrefix.equals("CDISI")) {
            this._bundle = "unknownUntilLauriePicks.StreamsInstallMessages";
        } else if (messagePrefix.equals("CDISU")) {
            this._bundle = "com.ibm.streams.messages.StreamsAuditMessages";
        } else if (messagePrefix.equals("CDISB")) {
            this._bundle = "com.ibm.streams.messages.StreamsBuildMessages";
        }
    }

    @Override
    public String getMessageId() {
        return this._messageId;
    }

    @Override
    public String getResourceBundleName() {
        return this._bundle;
    }

    public String toString() {
        return this._messageId + "," + this._bundle;
    }

    public boolean equals(Object m) {
        if (m instanceof MessageKey) {
            MessageKey key = (MessageKey)m;
            return key.getMessageId().equals(this._messageId);
        }
        return false;
    }
}

