/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.streams.spl.messages;

import com.ibm.icu.text.MessageFormat;
import com.ibm.streams.spl.messages.MessageKey;
import java.text.FieldPosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessageUtilities {
    public static final String IBM_COPYRIGHT = " Licensed Materials-Property of IBM                               5724-Y95                                                         (C) Copyright IBM Corp.  2011, 2020    All Rights Reserved.      US Government Users Restricted Rights - Use, duplication or      disclosure restricted by GSA ADP Schedule Contract with          IBM Corp.                                                                                                                        ";
    public static final String CLI_MESSAGE_PREFIX = "CDISC";
    public static final String RUNTIME_MESSAGE_PREFIX = "CDISR";
    public static final String ADMIN_MESSAGE_PREFIX = "CDISA";
    public static final String SWS_MESSAGE_PREFIX = "CDISW";
    public static final String AUDIT_MESSAGE_PREFIX = "CDISU";
    public static final String BUILD_MESSAGE_PREFIX = "CDISB";
    public static final String INSTALL_MESSAGE_PREFIX = "CDISI";
    public static final String STREAMS_CLI_MESSAGES_CLASS = "com.ibm.streams.messages.StreamsCLIMessages";
    public static final String STREAMS_RUNTIME_MESSAGES_CLASS = "com.ibm.streams.messages.StreamsRuntimeMessages";
    public static final String STREAMS_ADMIN_MESSAGES_CLASS = "com.ibm.streams.messages.StreamsAdminMessages";
    public static final String STREAMS_SWS_MESSAGES_CLASS = "com.ibm.streams.messages.StreamsSwsMessages";
    public static final String STREAMS_AUDIT_MESSAGES_CLASS = "com.ibm.streams.messages.StreamsAuditMessages";
    public static final String STREAMS_BUILD_MESSAGES_CLASS = "com.ibm.streams.messages.StreamsBuildMessages";
    public static final String STREAMS_INSTALL_MESSAGES_CLASS = "unknownUntilLauriePicks.StreamsInstallMessages";
    public static final String STREAMS_CLI_MESSAGES_DOC_CLASS = "com.ibm.streams.messages.StreamsCLIMessagesDoc";
    public static final String STREAMS_RUNTIME_MESSAGES_DOC_CLASS = "com.ibm.streams.messages.StreamsRuntimeMessagesDoc";
    public static final String STREAMS_ADMIN_MESSAGES_DOC_CLASS = "com.ibm.streams.messages.StreamsAdminMessagesDoc";
    public static final String STREAMS_SWS_MESSAGES_DOC_CLASS = "com.ibm.streams.messages.StreamsSwsMessagesDoc";
    public static final String STREAMS_AUDIT_MESSAGES_DOC_CLASS = "com.ibm.streams.messages.StreamsAuditMessagesDoc";
    public static final String STREAMS_BUILD_MESSAGES_DOC_CLASS = "com.ibm.streams.messages.StreamsBuildMessagesDoc";
    public static final String STREAMS_INSTALL_MESSAGES_DOC_CLASS = "unknownUntilLauriePicks.StreamsInstallMessagesDoc";
    private static Map<String, ResourceBundle> bundles = new HashMap<String, ResourceBundle>();
    private static Map<String, ResourceBundle> docbundles = new HashMap<String, ResourceBundle>();
    public static final String scriptPatternStr = ".*\\<\\s*[(script)(script/xss)(script/src)(img)(body)(iframe)(input)(style)(svg)(svg/onload)(bgsound)(br)(link)(meta)(xss)(frameset)(table)(td)(div)(base)(object)(embed)(a)]([ (%20)=])*.*>.*";
    private static Pattern scriptPattern = Pattern.compile(".*\\<\\s*[(script)(script/xss)(script/src)(img)(body)(iframe)(input)(style)(svg)(svg/onload)(bgsound)(br)(link)(meta)(xss)(frameset)(table)(td)(div)(base)(object)(embed)(a)]([ (%20)=])*.*>.*");
    private static Map<String, String> replaceHtml = new HashMap<String, String>();

    public static ResourceBundle getBundle(Locale locale, String messageId) {
        String messagePrefix;
        String key;
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (!bundles.containsKey(key = (messagePrefix = messageId.substring(0, 5)) + ":" + locale.toString())) {
            if (messagePrefix.startsWith(CLI_MESSAGE_PREFIX)) {
                bundles.put(key, ResourceBundle.getBundle(STREAMS_CLI_MESSAGES_CLASS, loc));
            } else if (messagePrefix.startsWith(RUNTIME_MESSAGE_PREFIX)) {
                bundles.put(key, ResourceBundle.getBundle(STREAMS_RUNTIME_MESSAGES_CLASS, loc));
            } else if (messagePrefix.startsWith(INSTALL_MESSAGE_PREFIX)) {
                bundles.put(key, ResourceBundle.getBundle(STREAMS_INSTALL_MESSAGES_CLASS, loc));
            } else if (messagePrefix.startsWith(ADMIN_MESSAGE_PREFIX)) {
                bundles.put(key, ResourceBundle.getBundle(STREAMS_ADMIN_MESSAGES_CLASS, loc));
            } else if (messagePrefix.startsWith(SWS_MESSAGE_PREFIX)) {
                bundles.put(key, ResourceBundle.getBundle(STREAMS_SWS_MESSAGES_CLASS, loc));
            } else if (messagePrefix.startsWith(AUDIT_MESSAGE_PREFIX)) {
                bundles.put(key, ResourceBundle.getBundle(STREAMS_AUDIT_MESSAGES_CLASS, loc));
            } else if (messagePrefix.startsWith(BUILD_MESSAGE_PREFIX)) {
                bundles.put(key, ResourceBundle.getBundle(STREAMS_BUILD_MESSAGES_CLASS, loc));
            }
        }
        return bundles.get(key);
    }

    public static ResourceBundle getBundle(Locale locale, MessageKey key) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String bundleName = key.getResourceBundleName();
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, loc);
        String hashKey = null;
        if (bundleName.equals(STREAMS_CLI_MESSAGES_CLASS)) {
            hashKey = "CDISC:" + loc.toString();
        } else if (bundleName.equals(STREAMS_RUNTIME_MESSAGES_CLASS)) {
            hashKey = "CDISR:" + loc.toString();
        } else if (bundleName.equals(STREAMS_ADMIN_MESSAGES_CLASS)) {
            hashKey = "CDISA:" + loc.toString();
        } else if (bundleName.equals(STREAMS_SWS_MESSAGES_CLASS)) {
            hashKey = "CDISW:" + loc.toString();
        } else if (bundleName.equals(STREAMS_INSTALL_MESSAGES_CLASS)) {
            hashKey = "CDISI:" + loc.toString();
        } else if (bundleName.equals(STREAMS_AUDIT_MESSAGES_CLASS)) {
            hashKey = "CDISU:" + loc.toString();
        } else if (bundleName.equals(STREAMS_BUILD_MESSAGES_CLASS)) {
            hashKey = "CDISB:" + loc.toString();
        }
        if (hashKey != null && !bundles.containsKey(hashKey)) {
            bundles.put(hashKey, bundle);
        }
        return bundle;
    }

    public static String getMessageAndPrefix(MessageKey key) {
        return key.getMessageId() + " " + MessageUtilities.getMessage(null, key);
    }

    public static String getMessage(MessageKey key) {
        return MessageUtilities.getMessage(null, key);
    }

    public static String getMessageAndPrefix(String messageId) {
        return messageId + " " + MessageUtilities.getMessage(messageId);
    }

    public static String getMessage(String messageId) {
        return MessageUtilities.getMessage(null, messageId);
    }

    public static String getMessageAndPrefix(Locale locale, MessageKey key) {
        return key.getMessageId() + " " + MessageUtilities.getMessage(locale, key);
    }

    public static String getMessage(Locale locale, MessageKey key) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String msg = null;
        ResourceBundle bundle = MessageUtilities.getBundle(loc, key);
        if (bundle != null) {
            msg = bundle.getString(key.getMessageId());
        }
        return msg;
    }

    public static String getMessageAndPrefix(Locale locale, String messageId) {
        return messageId + " " + MessageUtilities.getMessage(locale, messageId);
    }

    public static String getMessage(Locale locale, String messageId) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String msg = null;
        ResourceBundle bundle = MessageUtilities.getBundle(loc, messageId);
        if (bundle != null) {
            msg = bundle.getString(messageId);
        }
        return msg;
    }

    public static String getMessageAndPrefix(MessageKey key, Object ... subst) {
        return key.getMessageId() + " " + MessageUtilities.getMessage(null, key, subst);
    }

    public static String getMessage(MessageKey key, Object ... subst) {
        return MessageUtilities.getMessage(null, key, subst);
    }

    public static String getMessageAndPrefix(String messageId, Object ... subst) {
        return messageId + " " + MessageUtilities.getMessage(messageId, subst);
    }

    public static String getMessage(String messageId, Object ... subst) {
        return MessageUtilities.getMessage(null, messageId, subst);
    }

    public static String getMessageAndPrefix(Locale locale, MessageKey key, Object ... subst) {
        return key.getMessageId() + " " + MessageUtilities.getMessage(locale, key, subst);
    }

    public static String getMessage(Locale locale, MessageKey key, Object ... subst) {
        return MessageUtilities.formatMessage(locale, MessageUtilities.getMessage(locale, key), true, subst);
    }

    public static String getMessageAndPrefix(Locale locale, String messageId, Object ... subst) {
        return messageId + " " + MessageUtilities.getMessage(locale, messageId, subst);
    }

    public static String getMessage(Locale locale, String messageId, Object ... subst) {
        return MessageUtilities.formatMessage(locale, MessageUtilities.getMessage(locale, messageId), true, subst);
    }

    public static String getMessageAndPrefixUnmodified(Locale locale, MessageKey key, Object ... subst) {
        return key.getMessageId() + " " + MessageUtilities.formatMessage(locale, MessageUtilities.getMessage(locale, key), false, subst);
    }

    private static String formatMessage(Locale locale, String msg, boolean scanSubst, Object ... subst) {
        if (msg != null && subst != null) {
            for (int i = 0; i < subst.length; ++i) {
                if (subst[i] == null) continue;
                String s = subst[i].toString();
                if (subst[i] instanceof Number) {
                    subst[i] = s;
                }
                if (!scanSubst || !MessageUtilities.containsScript(s)) continue;
                subst[i] = MessageUtilities.substCharacterEntities(s);
            }
            MessageFormat formatter = new MessageFormat(msg, locale);
            StringBuffer sb = formatter.format(subst, new StringBuffer(), new FieldPosition(0));
            msg = sb.toString();
        }
        return msg;
    }

    public static ResourceBundle getDocBundle(Locale locale, String messageId) {
        String messagePrefix;
        String key;
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if (!docbundles.containsKey(key = (messagePrefix = messageId.substring(0, 5)) + ":" + locale.toString())) {
            if (messagePrefix.startsWith(CLI_MESSAGE_PREFIX)) {
                docbundles.put(key, ResourceBundle.getBundle(STREAMS_CLI_MESSAGES_DOC_CLASS, loc));
            } else if (messagePrefix.startsWith(RUNTIME_MESSAGE_PREFIX)) {
                docbundles.put(key, ResourceBundle.getBundle(STREAMS_RUNTIME_MESSAGES_DOC_CLASS, loc));
            } else if (messagePrefix.startsWith(INSTALL_MESSAGE_PREFIX)) {
                docbundles.put(key, ResourceBundle.getBundle(STREAMS_INSTALL_MESSAGES_DOC_CLASS, loc));
            } else if (messagePrefix.startsWith(ADMIN_MESSAGE_PREFIX)) {
                docbundles.put(key, ResourceBundle.getBundle(STREAMS_ADMIN_MESSAGES_DOC_CLASS, loc));
            } else if (messagePrefix.startsWith(SWS_MESSAGE_PREFIX)) {
                docbundles.put(key, ResourceBundle.getBundle(STREAMS_SWS_MESSAGES_DOC_CLASS, loc));
            } else if (messagePrefix.startsWith(AUDIT_MESSAGE_PREFIX)) {
                docbundles.put(key, ResourceBundle.getBundle(STREAMS_AUDIT_MESSAGES_DOC_CLASS, loc));
            } else if (messagePrefix.startsWith(BUILD_MESSAGE_PREFIX)) {
                docbundles.put(key, ResourceBundle.getBundle(STREAMS_BUILD_MESSAGES_DOC_CLASS, loc));
            }
        }
        return docbundles.get(key);
    }

    public static ResourceBundle getDocBundle(Locale locale, MessageKey key) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String bundleName = key.getResourceBundleName() + "Doc";
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, loc);
        String hashKey = null;
        if (bundleName.equals(STREAMS_CLI_MESSAGES_DOC_CLASS)) {
            hashKey = "CDISC:" + loc.toString();
        } else if (bundleName.equals(STREAMS_RUNTIME_MESSAGES_DOC_CLASS)) {
            hashKey = "CDISR:" + loc.toString();
        } else if (bundleName.equals(STREAMS_ADMIN_MESSAGES_DOC_CLASS)) {
            hashKey = "CDISA:" + loc.toString();
        } else if (bundleName.equals(STREAMS_SWS_MESSAGES_DOC_CLASS)) {
            hashKey = "CDISW:" + loc.toString();
        } else if (bundleName.equals(STREAMS_INSTALL_MESSAGES_DOC_CLASS)) {
            hashKey = "CDISI:" + loc.toString();
        } else if (bundleName.equals(STREAMS_AUDIT_MESSAGES_DOC_CLASS)) {
            hashKey = "CDISU:" + loc.toString();
        } else if (bundleName.equals(STREAMS_BUILD_MESSAGES_DOC_CLASS)) {
            hashKey = "CDISB:" + loc.toString();
        }
        if (hashKey != null && !docbundles.containsKey(hashKey)) {
            docbundles.put(hashKey, bundle);
        }
        return bundle;
    }

    public static String getExplanationMessage(MessageKey key) {
        return MessageUtilities.getExplanationMessage(null, key);
    }

    public static String getExplanationMessage(String messageId) {
        return MessageUtilities.getExplanationMessage(null, messageId);
    }

    public static String getExplanationMessage(Locale locale, MessageKey key) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String msg = null;
        ResourceBundle bundle = MessageUtilities.getDocBundle(loc, key);
        if (bundle != null) {
            msg = bundle.getString(key.getMessageId() + "_EXPLANATION");
        }
        return msg;
    }

    public static String getExplanationMessage(Locale locale, String messageId) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String msg = null;
        ResourceBundle bundle = MessageUtilities.getDocBundle(loc, messageId);
        if (bundle != null) {
            msg = bundle.getString(messageId + "_EXPLANATION");
        }
        return msg;
    }

    public static String getUserResponseMessage(MessageKey key) {
        return MessageUtilities.getUserResponseMessage(null, key);
    }

    public static String getUserResponseMessage(String messageId) {
        return MessageUtilities.getUserResponseMessage(null, messageId);
    }

    public static String getUserResponseMessage(Locale locale, MessageKey key) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String msg = null;
        ResourceBundle bundle = MessageUtilities.getDocBundle(loc, key);
        if (bundle != null) {
            msg = bundle.getString(key.getMessageId() + "_USER_RESPONSE");
        }
        return msg;
    }

    public static String getUserResponseMessage(Locale locale, String messageId) {
        Locale loc = locale;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String msg = null;
        ResourceBundle bundle = MessageUtilities.getDocBundle(loc, messageId);
        if (bundle != null) {
            msg = bundle.getString(messageId + "_USER_RESPONSE");
        }
        return msg;
    }

    public static boolean containsScript(String s) {
        if (s != null) {
            Matcher matcher = scriptPattern.matcher(s.toLowerCase());
            return matcher.matches();
        }
        return false;
    }

    public static String substCharacterEntities(String message) {
        if (message != null) {
            for (String htmlToReplace : replaceHtml.keySet()) {
                message = message.replaceAll(htmlToReplace, replaceHtml.get(htmlToReplace));
            }
        }
        return message;
    }

    static {
        replaceHtml.put("\\>", "&gt;");
        replaceHtml.put("\\<", "&lt;");
        replaceHtml.put("\\[", "&#91;");
        replaceHtml.put("\\]", "&#93;");
        replaceHtml.put("\\{", "&#123;");
        replaceHtml.put("\\}", "&#125;");
        replaceHtml.put("\\|", "&#124;");
        replaceHtml.put("\\?", "&#63;");
        replaceHtml.put("\\'", "&#39;");
    }
}

