/*
 * Decompiled with CFR 0.152.
 */
package com.idcard.service;

import com.idcard.service.IDCardData;
import com.sun.jna.Native;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class IDCard {
    String port;

    public IDCard() {
        String sMsg;
        int nRet = SynIDCardAPI.INSTANCE.Syn_FindReader();
        if (nRet == 0) {
            sMsg = "\u6ca1\u6709\u627e\u6253\u8bfb\u5361\u5668";
        } else {
            String sMsg2;
            if (nRet > 1000) {
                sMsg = String.format("\u8bfb\u5361\u5668\u8fde\u63a5\u5728USB\u7aef\u53e3 %d", nRet);
            } else {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException exc) {
                    System.out.println("error");
                }
                int uiCurrBaud = SynIDCardAPI.INSTANCE.Syn_GetCOMBaudEx(nRet);
                sMsg2 = String.format("%d", uiCurrBaud);
                sMsg = String.format("\u8bfb\u5361\u5668\u8fde\u63a5\u5728\u4e32\u53e3 %d,\u5f53\u524dSAM\u6ce2\u7279\u7387\u4e3a %d", nRet, uiCurrBaud);
            }
            this.port = sMsg2 = String.format("%d", nRet);
        }
        System.out.println(sMsg);
    }

    public static String getImageStr(String imgFile) {
        imgFile = "C:\\tmp.Jpeg";
        FileInputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = new FileInputStream(imgFile);
            data = new byte[((InputStream)inputStream).available()];
            ((InputStream)inputStream).read(data);
            ((InputStream)inputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Base64.Encoder encoder = Base64.getEncoder();
        return "data:image/jpeg;base64," + encoder.encodeToString(data);
    }

    public Map<String, String> getInfo() {
        SynIDCardAPI.INSTANCE.Syn_SetSexType(1);
        SynIDCardAPI.INSTANCE.Syn_SetNationType(1);
        SynIDCardAPI.INSTANCE.Syn_SetBornType(2);
        SynIDCardAPI.INSTANCE.Syn_SetUserLifeBType(3);
        SynIDCardAPI.INSTANCE.Syn_SetUserLifeEType(4, 1);
        SynIDCardAPI.INSTANCE.Syn_SetPhotoType(1);
        int iPort = Integer.parseInt(this.port);
        int nRet = SynIDCardAPI.INSTANCE.Syn_OpenPort(iPort);
        if (nRet == 0) {
            if (SynIDCardAPI.INSTANCE.Syn_SetMaxRFByte(iPort, 'P', 0) == 0) {
                char[] pucIIN = new char[8];
                char[] pucSN = new char[8];
                IDCardData idcardData = new IDCardData();
                nRet = SynIDCardAPI.INSTANCE.Syn_StartFindIDCard(iPort, pucIIN, 0);
                nRet = SynIDCardAPI.INSTANCE.Syn_SelectIDCard(iPort, pucSN, 0);
                if (SynIDCardAPI.INSTANCE.Syn_ReadMsg(iPort, 0, idcardData) == 0) {
                    System.out.println("\u8bfb\u53d6\u8eab\u4efd\u8bc1\u4fe1\u606f\u6210\u529f!");
                    HashMap<String, String> msg = new HashMap<String, String>();
                    try {
                        String strTemp = new String(idcardData.Name, "GBK");
                        msg.put("name", strTemp.trim());
                        strTemp = new String(idcardData.Sex, "GBK");
                        msg.put("gender", strTemp.trim());
                        strTemp = new String(idcardData.Nation, "GBK");
                        msg.put("ethnicity", strTemp.trim());
                        strTemp = new String(idcardData.Born, "GBK");
                        msg.put("birth", strTemp.trim());
                        strTemp = new String(idcardData.Address, "GBK");
                        msg.put("address", strTemp.trim());
                        strTemp = new String(idcardData.IDCardNo, "GBK");
                        msg.put("id", strTemp.trim());
                        strTemp = new String(idcardData.GrantDept, "GBK");
                        msg.put("issuing", strTemp.trim());
                        strTemp = new String(idcardData.UserLifeBegin, "GBK");
                        msg.put("start-date", strTemp.trim());
                        strTemp = new String(idcardData.UserLifeEnd, "GBK");
                        msg.put("end-date", strTemp.trim());
                        strTemp = new String(idcardData.PhotoFileName, "GBK");
                        msg.put("pic", IDCard.getImageStr(strTemp));
                        return msg;
                    }
                    catch (UnsupportedEncodingException une) {
                        une.printStackTrace();
                    }
                } else {
                    String sMsg = "null";
                    System.out.println(sMsg);
                }
            }
        } else {
            System.out.println("\u6253\u5f00\u7aef\u53e3\u9519\u8bef");
        }
        SynIDCardAPI.INSTANCE.Syn_ClosePort(iPort);
        return null;
    }

    public static interface SynIDCardAPI
    extends StdCallLibrary {
        public static final File directory = new File("");
        public static final String path = directory.getAbsolutePath().replace("/", "\\") + "\\dll\\SynIDCardAPI.dll";
        public static final SynIDCardAPI INSTANCE = (SynIDCardAPI)Native.loadLibrary(path, SynIDCardAPI.class);

        public int Syn_SetMaxRFByte(int var1, char var2, int var3);

        public int Syn_GetCOMBaudEx(int var1);

        public int Syn_SetCOMBaud(int var1, int var2, int var3);

        public int Syn_OpenPort(int var1);

        public int Syn_ClosePort(int var1);

        public int Syn_ResetSAM(int var1, int var2);

        public int Syn_GetSAMStatus(int var1, int var2);

        public int Syn_GetSAMID(int var1, char[] var2, int var3);

        public int Syn_StartFindIDCard(int var1, char[] var2, int var3);

        public int Syn_SelectIDCard(int var1, char[] var2, int var3);

        public int Syn_ReadMsg(int var1, int var2, IDCardData var3);

        public int Syn_FindReader();

        public int Syn_SetPhotoPath(int var1, String var2);

        public int Syn_SetPhotoType(int var1);

        public int Syn_SetPhotoName(int var1);

        public int Syn_SetSexType(int var1);

        public int Syn_SetNationType(int var1);

        public int Syn_SetBornType(int var1);

        public int Syn_SetUserLifeBType(int var1);

        public int Syn_SetUserLifeEType(int var1, int var2);
    }
}

