/*
 * Decompiled with CFR 0.152.
 */
package com.juggleim;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RNTypeConverter {
    public static WritableMap toWritableMap(Object obj) {
        return RNTypeConverter.toWritableMap(obj, new HashSet<Integer>());
    }

    private static WritableMap toWritableMap(Object obj, Set<Integer> visited) {
        WritableNativeMap map = new WritableNativeMap();
        if (obj == null) {
            return map;
        }
        int identityHashCode = System.identityHashCode(obj);
        if (visited.contains(identityHashCode)) {
            return map;
        }
        visited.add(identityHashCode);
        try {
            for (Field field : obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value == null) continue;
                RNTypeConverter.putValue((WritableMap)map, field.getName(), value, visited);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        visited.remove(identityHashCode);
        return map;
    }

    private static void putValue(WritableMap map, String key, Object value, Set<Integer> visited) {
        if (value instanceof String) {
            map.putString(key, (String)value);
        } else if (value instanceof Integer) {
            map.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Double) {
            map.putDouble(key, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            map.putDouble(key, ((Float)value).doubleValue());
        } else if (value instanceof Long) {
            map.putDouble(key, ((Long)value).doubleValue());
        } else if (value instanceof Boolean) {
            map.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof List) {
            WritableNativeArray array = new WritableNativeArray();
            for (Object item : (List)value) {
                if (item == null) continue;
                if (RNTypeConverter.isPrimitive(item)) {
                    RNTypeConverter.putArrayValue((WritableArray)array, item);
                    continue;
                }
                array.pushMap((ReadableMap)RNTypeConverter.toWritableMap(item, visited));
            }
            map.putArray(key, (ReadableArray)array);
        } else if (value instanceof Map) {
            WritableNativeMap nested = new WritableNativeMap();
            Map vMap = (Map)value;
            for (Map.Entry entry : vMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                RNTypeConverter.putValue((WritableMap)nested, entry.getKey().toString(), entry.getValue(), visited);
            }
            map.putMap(key, (ReadableMap)nested);
        } else {
            map.putMap(key, (ReadableMap)RNTypeConverter.toWritableMap(value, visited));
        }
    }

    private static void putArrayValue(WritableArray array, Object value) {
        if (value instanceof String) {
            array.pushString((String)value);
        } else if (value instanceof Boolean) {
            array.pushBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            array.pushInt(((Integer)value).intValue());
        } else if (value instanceof Double) {
            array.pushDouble(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            array.pushDouble(((Float)value).doubleValue());
        } else if (value instanceof Long) {
            array.pushDouble(((Long)value).doubleValue());
        }
    }

    private static boolean isPrimitive(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean;
    }

    public static <T> T fromReadableMap(ReadableMap map, Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            ReadableMapKeySetIterator iterator = map.keySetIterator();
            while (iterator.hasNextKey()) {
                Field field;
                String key = iterator.nextKey();
                try {
                    field = clazz.getDeclaredField(key);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                field.setAccessible(true);
                ReadableType type = map.getType(key);
                switch (type) {
                    case String: {
                        field.set(instance, map.getString(key));
                        break;
                    }
                    case Number: {
                        Class<?> fieldType = field.getType();
                        double num = map.getDouble(key);
                        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                            field.set(instance, (int)num);
                            break;
                        }
                        if (fieldType == Long.TYPE || fieldType == Long.class) {
                            field.set(instance, (long)num);
                            break;
                        }
                        if (fieldType == Float.TYPE || fieldType == Float.class) {
                            field.set(instance, Float.valueOf((float)num));
                            break;
                        }
                        field.set(instance, num);
                        break;
                    }
                    case Boolean: {
                        field.set(instance, map.getBoolean(key));
                        break;
                    }
                    case Map: {
                        Object nestedObj = RNTypeConverter.fromReadableMap(map.getMap(key), field.getType());
                        field.set(instance, nestedObj);
                        break;
                    }
                    case Array: {
                        ReadableArray array = map.getArray(key);
                        ArrayList<Object> list = new ArrayList<Object>();
                        block18: for (int i = 0; i < array.size(); ++i) {
                            ReadableType elementType = array.getType(i);
                            switch (elementType) {
                                case String: {
                                    list.add(array.getString(i));
                                    continue block18;
                                }
                                case Number: {
                                    list.add(array.getDouble(i));
                                    continue block18;
                                }
                                case Boolean: {
                                    list.add(array.getBoolean(i));
                                    continue block18;
                                }
                                case Map: {
                                    list.add(RNTypeConverter.fromReadableMap(array.getMap(i), Object.class));
                                    continue block18;
                                }
                            }
                        }
                        field.set(instance, list);
                    }
                }
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

