/*
 * Decompiled with CFR 0.152.
 */
package com.juggleim;

import android.content.Context;
import android.util.Log;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.juggle.im.JIM;
import com.juggle.im.JIMConst;
import com.juggle.im.interfaces.IConnectionManager;
import com.juggle.im.interfaces.IConversationManager;
import com.juggle.im.interfaces.IMessageManager;
import com.juggle.im.internal.logger.JLogConfig;
import com.juggle.im.internal.logger.JLogLevel;
import com.juggle.im.model.Conversation;
import com.juggle.im.model.ConversationInfo;
import com.juggle.im.model.ConversationMentionInfo;
import com.juggle.im.model.GetMessageOptions;
import com.juggle.im.model.GroupMessageReadInfo;
import com.juggle.im.model.MediaMessageContent;
import com.juggle.im.model.Message;
import com.juggle.im.model.MessageContent;
import com.juggle.im.model.MessageMentionInfo;
import com.juggle.im.model.MessageReaction;
import com.juggle.im.model.MessageReactionItem;
import com.juggle.im.model.UserInfo;
import com.juggle.im.model.messages.FileMessage;
import com.juggle.im.model.messages.ImageMessage;
import com.juggle.im.model.messages.TextMessage;
import com.juggle.im.model.messages.VoiceMessage;
import com.juggleim.FileUtils;
import com.juggleim.RNTypeConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class JuggleIMManager
extends ReactContextBaseJavaModule {
    private static final String MODULE_NAME = "JuggleIM";
    private Map<String, IConnectionManager.IConnectionStatusListener> connectionListeners = new HashMap<String, IConnectionManager.IConnectionStatusListener>();
    private Map<String, IMessageManager.IMessageListener> messageListeners = new HashMap<String, IMessageManager.IMessageListener>();
    private Map<String, IMessageManager.IMessageReadReceiptListener> readReceiptListeners = new HashMap<String, IMessageManager.IMessageReadReceiptListener>();
    private Map<String, IConversationManager.IConversationListener> conversationListeners = new HashMap<String, IConversationManager.IConversationListener>();

    public JuggleIMManager(@Nonnull ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Nonnull
    public String getName() {
        return MODULE_NAME;
    }

    @ReactMethod
    public void addListener(String eventName) {
    }

    @ReactMethod
    public void removeListeners(Integer count) {
    }

    @ReactMethod
    public void setServerUrls(ReadableArray urls) {
        ArrayList<String> serverList = new ArrayList<String>();
        for (int i = 0; i < urls.size(); ++i) {
            serverList.add(urls.getString(i));
        }
        JIM.getInstance().setServerUrls(serverList);
    }

    @ReactMethod
    public void init(String appKey) {
        JIM.InitConfig.Builder builder = new JIM.InitConfig.Builder();
        JLogConfig.Builder logBuilder = new JLogConfig.Builder((Context)this.getReactApplicationContext());
        logBuilder.setLogConsoleLevel(JLogLevel.JLogLevelVerbose);
        builder.setJLogConfig(new JLogConfig(logBuilder));
        JIM.getInstance().init((Context)this.getCurrentActivity(), appKey, builder.build());
    }

    @ReactMethod
    public void connect(String token) {
        JIM.getInstance().getConnectionManager().connect(token);
    }

    @ReactMethod
    public void addConnectionStatusListener(final String key) {
        IConnectionManager.IConnectionStatusListener listener = new IConnectionManager.IConnectionStatusListener(){

            public void onStatusChange(JIMConst.ConnectionStatus status, int code, String extra) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putString("status", JuggleIMManager.this.getStatusString(status));
                params.putInt("code", code);
                params.putString("extra", extra != null ? extra : "");
                JuggleIMManager.this.sendEvent("ConnectionStatusChanged", (WritableMap)params);
            }

            public void onDbOpen() {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                JuggleIMManager.this.sendEvent("DbDidOpen", (WritableMap)params);
            }

            public void onDbClose() {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                JuggleIMManager.this.sendEvent("DbDidClose", (WritableMap)params);
            }
        };
        JIM.getInstance().getConnectionManager().addConnectionStatusListener(key, listener);
    }

    private void sendEvent(String eventName, WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    private String getStatusString(JIMConst.ConnectionStatus status) {
        switch (status) {
            case CONNECTED: {
                return "connected";
            }
            case CONNECTING: {
                return "connecting";
            }
            case DISCONNECTED: {
                return "disconnected";
            }
            case FAILURE: {
                return "failure";
            }
        }
        return "unknown";
    }

    @ReactMethod
    public void addMessageListener(final String key) {
        IMessageManager.IMessageListener listener = new IMessageManager.IMessageListener(){

            public void onMessageReceive(Message message) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                JuggleIMManager.this.sendEvent("MessageReceived", (WritableMap)params);
            }

            public void onMessageRecall(Message message) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                JuggleIMManager.this.sendEvent("MessageRecalled", (WritableMap)params);
            }

            public void onMessageUpdate(Message message) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                JuggleIMManager.this.sendEvent("MessageUpdated", (WritableMap)params);
            }

            public void onMessageDelete(Conversation conversation, List<Long> clientMsgNos) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("conversation", (ReadableMap)JuggleIMManager.this.convertConversationToMap(conversation));
                WritableNativeArray msgNos = new WritableNativeArray();
                for (Long msgNo : clientMsgNos) {
                    msgNos.pushDouble(msgNo.doubleValue());
                }
                params.putArray("clientMsgNos", (ReadableArray)msgNos);
                JuggleIMManager.this.sendEvent("MessageDeleted", (WritableMap)params);
            }

            public void onMessageClear(Conversation conversation, long timestamp, String senderId) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("conversation", (ReadableMap)JuggleIMManager.this.convertConversationToMap(conversation));
                params.putDouble("timestamp", (double)timestamp);
                params.putString("senderId", senderId != null ? senderId : "");
                JuggleIMManager.this.sendEvent("MessageCleared", (WritableMap)params);
            }

            public void onMessageReactionAdd(Conversation conversation, MessageReaction reaction) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("conversation", (ReadableMap)JuggleIMManager.this.convertConversationToMap(conversation));
                params.putMap("reaction", (ReadableMap)JuggleIMManager.this.convertReactionToMap(reaction));
                JuggleIMManager.this.sendEvent("MessageReactionAdded", (WritableMap)params);
            }

            public void onMessageReactionRemove(Conversation conversation, MessageReaction reaction) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("conversation", (ReadableMap)JuggleIMManager.this.convertConversationToMap(conversation));
                params.putMap("reaction", (ReadableMap)JuggleIMManager.this.convertReactionToMap(reaction));
                JuggleIMManager.this.sendEvent("MessageReactionRemoved", (WritableMap)params);
            }
        };
        this.messageListeners.put(key, listener);
        JIM.getInstance().getMessageManager().addListener(key, listener);
    }

    @ReactMethod
    public void addMessageReadReceiptListener(final String key) {
        IMessageManager.IMessageReadReceiptListener listener = new IMessageManager.IMessageReadReceiptListener(){

            public void onMessagesRead(Conversation conversation, List<String> messageIds) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("conversation", (ReadableMap)JuggleIMManager.this.convertConversationToMap(conversation));
                WritableNativeArray msgIds = new WritableNativeArray();
                for (String msgId : messageIds) {
                    msgIds.pushString(msgId);
                }
                params.putArray("messageIds", (ReadableArray)msgIds);
                JuggleIMManager.this.sendEvent("MessagesRead", (WritableMap)params);
            }

            public void onGroupMessagesRead(Conversation conversation, Map<String, GroupMessageReadInfo> messages) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putMap("conversation", (ReadableMap)JuggleIMManager.this.convertConversationToMap(conversation));
                WritableNativeMap messagesMap = new WritableNativeMap();
                for (Map.Entry<String, GroupMessageReadInfo> entry : messages.entrySet()) {
                    messagesMap.putMap(entry.getKey(), (ReadableMap)JuggleIMManager.this.convertGroupMessageReadInfoToMap(entry.getValue()));
                }
                params.putMap("messages", (ReadableMap)messagesMap);
                JuggleIMManager.this.sendEvent("GroupMessagesRead", (WritableMap)params);
            }
        };
        this.readReceiptListeners.put(key, listener);
        JIM.getInstance().getMessageManager().addReadReceiptListener(key, listener);
    }

    @ReactMethod
    public void addConversationListener(final String key) {
        IConversationManager.IConversationListener listener = new IConversationManager.IConversationListener(){

            public void onConversationInfoAdd(List<ConversationInfo> conversationInfoList) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                WritableNativeArray conversations = new WritableNativeArray();
                for (ConversationInfo info : conversationInfoList) {
                    conversations.pushMap((ReadableMap)JuggleIMManager.this.convertConversationInfoToMap(info));
                }
                params.putArray("conversations", (ReadableArray)conversations);
                JuggleIMManager.this.sendEvent("ConversationInfoAdded", (WritableMap)params);
            }

            public void onConversationInfoUpdate(List<ConversationInfo> conversationInfoList) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                WritableNativeArray conversations = new WritableNativeArray();
                for (ConversationInfo info : conversationInfoList) {
                    conversations.pushMap((ReadableMap)JuggleIMManager.this.convertConversationInfoToMap(info));
                }
                params.putArray("conversations", (ReadableArray)conversations);
                JuggleIMManager.this.sendEvent("ConversationInfoUpdated", (WritableMap)params);
            }

            public void onConversationInfoDelete(List<ConversationInfo> conversationInfoList) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                WritableNativeArray conversations = new WritableNativeArray();
                for (ConversationInfo info : conversationInfoList) {
                    conversations.pushMap((ReadableMap)JuggleIMManager.this.convertConversationInfoToMap(info));
                }
                params.putArray("conversations", (ReadableArray)conversations);
                JuggleIMManager.this.sendEvent("ConversationInfoDeleted", (WritableMap)params);
            }

            public void onTotalUnreadMessageCountUpdate(int count) {
                WritableNativeMap params = new WritableNativeMap();
                params.putString("key", key);
                params.putInt("count", count);
                JuggleIMManager.this.sendEvent("TotalUnreadMessageCountUpdated", (WritableMap)params);
            }
        };
        this.conversationListeners.put(key, listener);
        JIM.getInstance().getConversationManager().addListener(key, listener);
    }

    private WritableMap convertMessageToMap(Message message) {
        WritableNativeMap map = new WritableNativeMap();
        map.putString("messageId", message.getMessageId());
        map.putDouble("clientMsgNo", (double)message.getClientMsgNo());
        map.putDouble("timestamp", (double)message.getTimestamp());
        map.putString("senderUserId", message.getSenderUserId());
        map.putMap("conversation", (ReadableMap)this.convertConversationToMap(message.getConversation()));
        map.putMap("content", (ReadableMap)this.convertMessageContentToMap(message.getContent()));
        if (message.getDirection() != null) {
            map.putInt("direction", message.getDirection().getValue());
        }
        if (message.getState() != null) {
            map.putInt("state", message.getState().getValue());
        }
        map.putBoolean("hasRead", message.isHasRead());
        if (message.getGroupMessageReadInfo() != null) {
            map.putMap("groupMessageReadInfo", (ReadableMap)this.convertGroupMessageReadInfoToMap(message.getGroupMessageReadInfo()));
        }
        if (message.getReferredMessage() != null) {
            map.putMap("referredMessage", (ReadableMap)this.convertMessageToMap(message.getReferredMessage()));
        }
        if (message.getMentionInfo() != null) {
            map.putMap("mentionInfo", (ReadableMap)this.convertMentionInfoToMap(message.getMentionInfo()));
        }
        map.putString("localAttribute", message.getLocalAttribute());
        map.putBoolean("isDelete", message.isDelete());
        map.putBoolean("isEdit", message.isEdit());
        return map;
    }

    private WritableMap convertConversationToMap(Conversation conversation) {
        WritableNativeMap map = new WritableNativeMap();
        map.putInt("conversationType", conversation.getConversationType().getValue());
        map.putString("conversationId", conversation.getConversationId());
        return map;
    }

    private WritableMap convertMessageContentToMap(MessageContent content) {
        WritableNativeMap map = new WritableNativeMap();
        map.putString("contentType", content.getContentType());
        if (content.getContentType().equals("jg:text")) {
            map.putString("content", ((TextMessage)content).getContent());
        } else if (content.getContentType().equals("jg:img")) {
            ImageMessage img = (ImageMessage)content;
            map.putString("url", img.getUrl());
            map.putString("localPath", img.getLocalPath());
            map.putString("thumbnailLocalPath", img.getThumbnailLocalPath());
            map.putString("thumbnailUrl", img.getThumbnailUrl());
            map.putInt("width", img.getWidth());
            map.putInt("height", img.getHeight());
        } else if (content.getContentType().equals("jg:file")) {
            FileMessage file = (FileMessage)content;
            map.putString("url", file.getUrl());
            map.putString("type", file.getType());
            map.putString("name", file.getName());
            map.putDouble("size", (double)file.getSize());
        } else if (content.getContentType().equals("jg:voice")) {
            VoiceMessage voice = (VoiceMessage)content;
            map.putString("url", voice.getUrl());
            map.putString("localPath", voice.getLocalPath());
            map.putInt("duration", voice.getDuration());
        } else {
            Log.e((String)"convertMessageContentToMap", (String)("Unknown contentType: " + content.getContentType()));
            return RNTypeConverter.toWritableMap(content);
        }
        return map;
    }

    private MessageContent convertMapToMessageContent(ReadableMap map) {
        String contentType;
        switch (contentType = map.getString("contentType")) {
            case "jg:text": {
                TextMessage text = new TextMessage(map.getString("content"));
                return text;
            }
            case "jg:img": {
                ImageMessage img = new ImageMessage();
                img.setUrl(map.getString("url"));
                img.setLocalPath(map.getString("localPath"));
                img.setThumbnailLocalPath(map.getString("thumbnailLocalPath"));
                img.setThumbnailUrl(map.getString("thumbnailUrl"));
                img.setWidth(map.getInt("width"));
                img.setHeight(map.getInt("height"));
                return img;
            }
            case "jg:file": {
                FileMessage file = new FileMessage();
                file.setUrl(map.getString("url"));
                file.setType(map.getString("type"));
                file.setName(map.getString("name"));
                file.setSize((long)map.getInt("size"));
                return file;
            }
            case "jg:voice": {
                VoiceMessage voice = new VoiceMessage();
                voice.setUrl(map.getString("url"));
                voice.setLocalPath(map.getString("localPath"));
                voice.setDuration(map.getInt("duration"));
                return voice;
            }
        }
        Log.e((String)"convertMapToMessageContent", (String)("contentType: " + contentType));
        return RNTypeConverter.fromReadableMap(map, MessageContent.class);
    }

    private WritableMap convertReactionToMap(MessageReaction reaction) {
        WritableNativeMap map = new WritableNativeMap();
        map.putString("messageId", reaction.getMessageId());
        WritableNativeArray itemList = new WritableNativeArray();
        for (MessageReactionItem item : reaction.getItemList()) {
            WritableNativeMap mi = new WritableNativeMap();
            mi.putString("reactionId", item.getReactionId());
            WritableNativeArray us = new WritableNativeArray();
            for (UserInfo user : item.getUserInfoList()) {
                us.pushMap((ReadableMap)this.convertUserInfoToMap(user));
            }
            mi.putArray("userInfoList", (ReadableArray)us);
            itemList.pushMap((ReadableMap)mi);
        }
        map.putArray("itemList", (ReadableArray)itemList);
        return map;
    }

    private WritableMap convertUserInfoToMap(UserInfo userInfo) {
        WritableNativeMap map = new WritableNativeMap();
        map.putString("userId", userInfo.getUserId());
        map.putString("nickname", userInfo.getUserName());
        map.putString("avatar", userInfo.getPortrait());
        return map;
    }

    private WritableMap convertGroupMessageReadInfoToMap(GroupMessageReadInfo info) {
        WritableNativeMap map = new WritableNativeMap();
        map.putInt("readCount", info.getReadCount());
        map.putInt("memberCount", info.getMemberCount());
        return map;
    }

    private WritableMap convertConversationMentionInfoToMap(ConversationMentionInfo mentionInfo) {
        WritableNativeMap map = new WritableNativeMap();
        if (mentionInfo.getMentionMsgList() != null) {
            WritableNativeArray mentionMsgArray = new WritableNativeArray();
            for (ConversationMentionInfo.MentionMsg mentionMsg : mentionInfo.getMentionMsgList()) {
                WritableNativeMap msgMap = new WritableNativeMap();
                msgMap.putString("senderId", mentionMsg.getSenderId());
                msgMap.putString("msgId", mentionMsg.getMsgId());
                msgMap.putDouble("msgTime", (double)mentionMsg.getMsgTime());
                msgMap.putInt("type", mentionMsg.getType().getValue());
                mentionMsgArray.pushMap((ReadableMap)msgMap);
            }
            map.putArray("mentionMsgList", (ReadableArray)mentionMsgArray);
        }
        return map;
    }

    @ReactMethod
    public void getConversationInfoList(int count, double ts, int pullDirection, Promise promise) {
        try {
            JIMConst.PullDirection direction = pullDirection == 0 ? JIMConst.PullDirection.NEWER : JIMConst.PullDirection.OLDER;
            List conversationInfos = JIM.getInstance().getConversationManager().getConversationInfoList(count, (long)ts, direction);
            Log.d((String)"getConversationInfoList", (String)("conversationInfos: " + conversationInfos.size()));
            WritableNativeArray result = new WritableNativeArray();
            for (ConversationInfo info : conversationInfos) {
                result.pushMap((ReadableMap)this.convertConversationInfoToMap(info));
            }
            promise.resolve((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            promise.reject((Throwable)e);
        }
    }

    @ReactMethod
    public void getConversationInfo(ReadableMap conversationMap, Promise promise) {
        Conversation conversation = this.convertMapToConversation(conversationMap);
        ConversationInfo conversationInfo = JIM.getInstance().getConversationManager().getConversationInfo(conversation);
        promise.resolve((Object)this.convertConversationInfoToMap(conversationInfo));
    }

    @ReactMethod
    public void createConversationInfo(ReadableMap conversationInfoMap, final Promise promise) {
        Conversation conversationInfo = this.convertMapToConversation(conversationInfoMap);
        JIM.getInstance().getConversationManager().createConversationInfo(conversationInfo, new IConversationManager.ICreateConversationInfoCallback(){

            public void onSuccess(ConversationInfo info) {
                promise.resolve((Object)JuggleIMManager.this.convertConversationInfoToMap(info));
            }

            public void onError(int errorCode) {
                promise.reject("error", "Error code: " + errorCode);
            }
        });
    }

    @ReactMethod
    public void deleteConversationInfo(ReadableMap conversationMap, final Promise promise) {
        Conversation conversation = this.convertMapToConversation(conversationMap);
        JIM.getInstance().getConversationManager().deleteConversationInfo(conversation, new IConversationManager.ISimpleCallback(){

            public void onSuccess() {
                promise.resolve((Object)true);
            }

            public void onError(int errorCode) {
                promise.reject("error", "Error code: " + errorCode);
            }
        });
    }

    @ReactMethod
    public void setMute(ReadableMap conversationMap, boolean isMute, final Promise promise) {
        Conversation conversation = this.convertMapToConversation(conversationMap);
        JIM.getInstance().getConversationManager().setMute(conversation, isMute, new IConversationManager.ISimpleCallback(){

            public void onSuccess() {
                promise.resolve((Object)true);
            }

            public void onError(int errorCode) {
                promise.reject("error", "Error code: " + errorCode);
            }
        });
    }

    @ReactMethod
    public void clearUnreadCount(ReadableMap conversationMap, final Promise promise) {
        Conversation conversation = this.convertMapToConversation(conversationMap);
        JIM.getInstance().getConversationManager().clearUnreadCount(conversation, new IConversationManager.ISimpleCallback(){

            public void onSuccess() {
                promise.resolve((Object)true);
            }

            public void onError(int errorCode) {
                promise.reject("error", "Error code: " + errorCode);
            }
        });
    }

    @ReactMethod
    public void setDraft(ReadableMap conversationMap, String draft, Promise promise) {
        Conversation conversation = this.convertMapToConversation(conversationMap);
        JIM.getInstance().getConversationManager().setDraft(conversation, draft);
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void getTotalUnreadCount(Promise promise) {
        int c = JIM.getInstance().getConversationManager().getTotalUnreadCount();
        promise.resolve((Object)c);
    }

    @ReactMethod
    public void setTop(ReadableMap conversationMap, boolean isTop, final Promise promise) {
        Conversation conversation = this.convertMapToConversation(conversationMap);
        JIM.getInstance().getConversationManager().setTop(conversation, isTop, new IConversationManager.ISimpleCallback(){

            public void onSuccess() {
                promise.resolve((Object)true);
            }

            public void onError(int errorCode) {
                promise.reject("error", "Error code: " + errorCode);
            }
        });
    }

    private Conversation convertMapToConversation(ReadableMap map) {
        Conversation.ConversationType type = Conversation.ConversationType.values()[map.getInt("conversationType")];
        Conversation conversation = new Conversation(type, map.getString("conversationId"));
        return conversation;
    }

    private ConversationInfo convertMapToConversationInfo(ReadableMap map) {
        ConversationInfo info = new ConversationInfo();
        info.setConversation(this.convertMapToConversation(map.getMap("conversation")));
        info.setUnreadCount(map.getInt("unreadMessageCount"));
        info.setTop(map.getBoolean("isTop"));
        info.setMute(map.getBoolean("isMute"));
        info.setDraft(map.getString("draft"));
        return info;
    }

    private WritableMap convertConversationInfoToMap(ConversationInfo info) {
        WritableNativeMap map = new WritableNativeMap();
        map.putMap("conversation", (ReadableMap)this.convertConversationToMap(info.getConversation()));
        map.putInt("unreadCount", info.getUnreadCount());
        map.putBoolean("isTop", info.isTop());
        map.putBoolean("isMute", info.isMute());
        map.putBoolean("hasUnread", info.hasUnread());
        map.putString("draft", info.getDraft() != null ? info.getDraft() : "");
        map.putDouble("topTime", (double)info.getTopTime());
        map.putDouble("sortTime", (double)info.getSortTime());
        if (info.getLastMessage() != null) {
            map.putMap("lastMessage", (ReadableMap)this.convertMessageToMap(info.getLastMessage()));
        }
        if (info.getMentionInfo() != null) {
            map.putMap("mentionInfo", (ReadableMap)this.convertConversationMentionInfoToMap(info.getMentionInfo()));
        }
        return map;
    }

    private WritableMap convertMentionInfoToMap(MessageMentionInfo mentionInfo) {
        WritableNativeMap map = new WritableNativeMap();
        WritableNativeArray userMap = new WritableNativeArray();
        map.putInt("type", mentionInfo.getType().getValue());
        for (UserInfo userInfo : mentionInfo.getTargetUsers()) {
            userMap.pushMap((ReadableMap)this.convertUserInfoToMap(userInfo));
        }
        map.putArray("targetUsers", (ReadableArray)userMap);
        return map;
    }

    @ReactMethod
    public void sendMessage(ReadableMap messageMap, final String messageId, Promise promise) {
        try {
            Message message = this.convertMapToMessage(messageMap);
            Log.d((String)"sendMessage", (String)message.toString());
            Message sendMsg = JIM.getInstance().getMessageManager().sendMessage(message.getContent(), message.getConversation(), new IMessageManager.ISendMessageCallback(){

                public void onSuccess(Message sentMessage) {
                    WritableMap result = JuggleIMManager.this.convertMessageToMap(sentMessage);
                    WritableNativeMap event = new WritableNativeMap();
                    event.putString("messageId", messageId);
                    event.putMap("message", (ReadableMap)result);
                    JuggleIMManager.this.sendEvent("onMessageSent", (WritableMap)event);
                }

                public void onError(Message message, int errorCode) {
                    WritableMap errorResult = JuggleIMManager.this.convertMessageToMap(message);
                    WritableNativeMap event = new WritableNativeMap();
                    event.putString("messageId", messageId);
                    event.putMap("message", (ReadableMap)errorResult);
                    event.putInt("errorCode", errorCode);
                    JuggleIMManager.this.sendEvent("onMessageSentError", (WritableMap)event);
                }
            });
            WritableMap result = this.convertMessageToMap(sendMsg);
            result.putString("messageId", messageId);
            promise.resolve((Object)result);
        }
        catch (Exception e) {
            promise.reject("SEND_MESSAGE_ERROR", e.getMessage());
        }
    }

    @ReactMethod
    public void getMessages(ReadableMap conversationMap, int direction, ReadableMap options, final Promise promise) {
        try {
            Conversation conversation = this.convertMapToConversation(conversationMap);
            GetMessageOptions getOptions = new GetMessageOptions();
            if (options.hasKey("count")) {
                getOptions.setCount(options.getInt("count"));
            }
            if (options.hasKey("startTime")) {
                getOptions.setStartTime((long)options.getDouble("startTime"));
            }
            JIMConst.PullDirection pullDirection = direction == 0 ? JIMConst.PullDirection.OLDER : JIMConst.PullDirection.NEWER;
            JIM.getInstance().getMessageManager().getMessages(conversation, pullDirection, getOptions, new IMessageManager.IGetMessagesCallbackV3(){

                public void onGetMessages(List<Message> messages, long timestamp, boolean hasMore, int code) {
                    WritableNativeMap result = new WritableNativeMap();
                    WritableNativeArray messageArray = new WritableNativeArray();
                    for (Message msg : messages) {
                        messageArray.pushMap((ReadableMap)JuggleIMManager.this.convertMessageToMap(msg));
                    }
                    result.putArray("messages", (ReadableArray)messageArray);
                    result.putDouble("timestamp", (double)timestamp);
                    result.putBoolean("hasMore", hasMore);
                    result.putInt("code", code);
                    promise.resolve((Object)result);
                }
            });
        }
        catch (Exception e) {
            promise.reject("GET_MESSAGES_ERROR", e.getMessage());
        }
    }

    @ReactMethod
    public void recallMessage(ReadableMap messageMap, ReadableMap extras, final Promise promise) {
        try {
            String messageId = messageMap.getString("messageId");
            HashMap<String, String> extrasMap = new HashMap<String, String>();
            if (extras != null) {
                ReadableMapKeySetIterator it = extras.keySetIterator();
                extrasMap = new HashMap();
                while (it.hasNextKey()) {
                    extrasMap.put(it.nextKey(), extras.getString(it.nextKey()));
                }
            }
            JIM.getInstance().getMessageManager().recallMessage(messageId, extrasMap, new IMessageManager.IRecallMessageCallback(){

                public void onSuccess(Message m) {
                    promise.resolve((Object)true);
                }

                public void onError(int errorCode) {
                    promise.reject("RECALL_MESSAGE_ERROR", errorCode + "");
                }
            });
        }
        catch (Exception e) {
            promise.reject("RECALL_MESSAGE_ERROR", e.getMessage());
        }
    }

    @ReactMethod
    public void addMessageReaction(ReadableMap messageMap, String reactionId, final Promise promise) {
        try {
            String messageId = messageMap.getString("messageId");
            Conversation conversation = this.convertMapToConversation(messageMap);
            JIM.getInstance().getMessageManager().addMessageReaction(messageId, conversation, reactionId, new IMessageManager.ISimpleCallback(){

                public void onSuccess() {
                    promise.resolve((Object)true);
                }

                public void onError(int errorCode) {
                    promise.reject("ADD_REACTION_ERROR", errorCode + "");
                }
            });
        }
        catch (Exception e) {
            promise.reject("ADD_REACTION_ERROR", e.getMessage());
        }
    }

    @ReactMethod
    public void removeMessageReaction(ReadableMap messageMap, String reactionId, final Promise promise) {
        try {
            String messageId = messageMap.getString("messageId");
            Conversation conversation = this.convertMapToConversation(messageMap);
            JIM.getInstance().getMessageManager().removeMessageReaction(messageId, conversation, reactionId, new IMessageManager.ISimpleCallback(){

                public void onSuccess() {
                    promise.resolve((Object)true);
                }

                public void onError(int errorCode) {
                    promise.reject("REMOVE_REACTION_ERROR", errorCode + "");
                }
            });
        }
        catch (Exception e) {
            promise.reject("REMOVE_REACTION_ERROR", e.getMessage());
        }
    }

    @ReactMethod
    public void sendImageMessage(ReadableMap messageMap, final String messageId, Promise promise) {
        try {
            String path;
            Conversation conversation = this.convertMapToConversation(messageMap);
            ImageMessage imageMessage = new ImageMessage();
            ReadableMap contentMap = messageMap.getMap("content");
            if (contentMap.hasKey("localPath")) {
                path = FileUtils.convertContentUriToFile((Context)this.getReactApplicationContext(), contentMap.getString("localPath"));
                imageMessage.setLocalPath(path);
            }
            if (contentMap.hasKey("thumbnailLocalPath")) {
                path = FileUtils.convertContentUriToFile((Context)this.getReactApplicationContext(), contentMap.getString("localPath"));
                imageMessage.setThumbnailLocalPath(path);
            }
            if (contentMap.hasKey("url")) {
                imageMessage.setUrl(contentMap.getString("url"));
            }
            if (contentMap.hasKey("thumbnailUrl")) {
                imageMessage.setThumbnailUrl(contentMap.getString("thumbnailUrl"));
            }
            if (contentMap.hasKey("width")) {
                imageMessage.setWidth(contentMap.getInt("width"));
            }
            if (contentMap.hasKey("height")) {
                imageMessage.setHeight(contentMap.getInt("height"));
            }
            Message message = JIM.getInstance().getMessageManager().sendMediaMessage((MediaMessageContent)imageMessage, conversation, new IMessageManager.ISendMediaMessageCallback(){

                public void onProgress(int progress, Message message) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putInt("progress", progress);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    Log.d((String)JuggleIMManager.MODULE_NAME, (String)("onMediaMessageProgress: " + progress));
                    JuggleIMManager.this.sendEvent("onMediaMessageProgress", (WritableMap)params);
                }

                public void onSuccess(Message message) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    JuggleIMManager.this.sendEvent("onMediaMessageSent", (WritableMap)params);
                }

                public void onError(Message message, int errorCode) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    params.putInt("errorCode", errorCode);
                    JuggleIMManager.this.sendEvent("onMediaMessageSentError", (WritableMap)params);
                }

                public void onCancel(Message message) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    JuggleIMManager.this.sendEvent("onMediaMessageCancelled", (WritableMap)params);
                }
            });
            WritableMap result = this.convertMessageToMap(message);
            result.putString("messageId", messageId);
            promise.resolve((Object)result);
        }
        catch (Exception e) {
            promise.reject("SEND_IMAGE_MESSAGE_ERROR", e.getMessage());
        }
    }

    @ReactMethod
    public void sendFileMessage(ReadableMap messageMap, final String messageId, Promise promise) {
        try {
            Conversation conversation = this.convertMapToConversation(messageMap);
            FileMessage fileMessage = new FileMessage();
            ReadableMap contentMap = messageMap.getMap("content");
            if (contentMap.hasKey("localPath")) {
                String path = FileUtils.convertContentUriToFile((Context)this.getReactApplicationContext(), contentMap.getString("localPath"));
                fileMessage.setLocalPath(path);
            }
            if (contentMap.hasKey("url")) {
                fileMessage.setUrl(contentMap.getString("url"));
            }
            if (contentMap.hasKey("name")) {
                fileMessage.setName(contentMap.getString("name"));
            }
            if (contentMap.hasKey("size")) {
                fileMessage.setSize((long)contentMap.getDouble("size"));
            }
            if (contentMap.hasKey("type")) {
                fileMessage.setType(contentMap.getString("type"));
            }
            Message message = JIM.getInstance().getMessageManager().sendMediaMessage((MediaMessageContent)fileMessage, conversation, new IMessageManager.ISendMediaMessageCallback(){

                public void onProgress(int progress, Message message) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putInt("progress", progress);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    JuggleIMManager.this.sendEvent("onMediaMessageProgress", (WritableMap)params);
                }

                public void onSuccess(Message message) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    JuggleIMManager.this.sendEvent("onMediaMessageSent", (WritableMap)params);
                }

                public void onError(Message message, int errorCode) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    params.putInt("errorCode", errorCode);
                    JuggleIMManager.this.sendEvent("onMediaMessageSentError", (WritableMap)params);
                }

                public void onCancel(Message message) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putString("messageId", messageId);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    JuggleIMManager.this.sendEvent("onMediaMessageCancelled", (WritableMap)params);
                }
            });
            WritableMap result = this.convertMessageToMap(message);
            result.putString("messageId", messageId);
            promise.resolve((Object)result);
        }
        catch (Exception e) {
            promise.reject("SEND_FILE_MESSAGE_ERROR", e.getMessage());
        }
    }

    @ReactMethod
    public void sendVoiceMessage(ReadableMap messageMap, Promise promise) {
        try {
            Conversation conversation = this.convertMapToConversation(messageMap);
            VoiceMessage voiceMessage = new VoiceMessage();
            ReadableMap contentMap = messageMap.getMap("content");
            if (contentMap.hasKey("localPath")) {
                String path = FileUtils.convertContentUriToFile((Context)this.getReactApplicationContext(), contentMap.getString("localPath"));
                voiceMessage.setLocalPath(path);
            }
            if (contentMap.hasKey("url")) {
                voiceMessage.setUrl(contentMap.getString("url"));
            }
            if (contentMap.hasKey("duration")) {
                voiceMessage.setDuration(contentMap.getInt("duration"));
            }
            Message message = JIM.getInstance().getMessageManager().sendMediaMessage((MediaMessageContent)voiceMessage, conversation, new IMessageManager.ISendMediaMessageCallback(){

                public void onProgress(int progress, Message message) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putInt("progress", progress);
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    Log.d((String)JuggleIMManager.MODULE_NAME, (String)("onMediaMessageProgress: " + progress));
                    JuggleIMManager.this.sendEvent("onMediaMessageProgress", (WritableMap)params);
                }

                public void onSuccess(Message message) {
                    WritableMap result = JuggleIMManager.this.convertMessageToMap(message);
                    Log.d((String)JuggleIMManager.MODULE_NAME, (String)"onMediaMessageSent");
                    JuggleIMManager.this.sendEvent("onMediaMessageSent", result);
                }

                public void onError(Message message, int errorCode) {
                    WritableNativeMap params = new WritableNativeMap();
                    params.putMap("message", (ReadableMap)JuggleIMManager.this.convertMessageToMap(message));
                    params.putInt("errorCode", errorCode);
                    JuggleIMManager.this.sendEvent("onMediaMessageSentError", (WritableMap)params);
                }

                public void onCancel(Message message) {
                    WritableMap result = JuggleIMManager.this.convertMessageToMap(message);
                    JuggleIMManager.this.sendEvent("onMediaMessageCancelled", result);
                }
            });
            WritableMap result = this.convertMessageToMap(message);
            promise.resolve((Object)result);
        }
        catch (Exception e) {
            promise.reject("SEND_VOICE_MESSAGE_ERROR", e.getMessage());
        }
    }

    private Message convertMapToMessage(ReadableMap messageMap) {
        Message message = new Message();
        Conversation conversation = this.convertMapToConversation(messageMap);
        message.setConversation(conversation);
        if (messageMap.hasKey("messageId")) {
            message.setMessageId(messageMap.getString("messageId"));
        }
        if (messageMap.hasKey("clientMsgNo")) {
            message.setClientMsgNo((long)messageMap.getDouble("clientMsgNo"));
        }
        if (messageMap.hasKey("timestamp")) {
            message.setTimestamp((long)messageMap.getDouble("timestamp"));
        }
        if (messageMap.hasKey("senderUserId")) {
            message.setSenderUserId(messageMap.getString("senderUserId"));
        }
        if (messageMap.hasKey("content")) {
            ReadableMap contentMap = messageMap.getMap("content");
            MessageContent content = this.convertMapToMessageContent(contentMap);
            message.setContent(content);
        }
        if (messageMap.hasKey("direction")) {
            Message.MessageDirection direction = Message.MessageDirection.setValue((int)messageMap.getInt("direction"));
            message.setDirection(direction);
        }
        if (messageMap.hasKey("state")) {
            Message.MessageState state = Message.MessageState.setValue((int)messageMap.getInt("state"));
            message.setState(state);
        }
        if (messageMap.hasKey("hasRead")) {
            message.setHasRead(messageMap.getBoolean("hasRead"));
        }
        if (messageMap.hasKey("localAttribute")) {
            message.setLocalAttribute(messageMap.getString("localAttribute"));
        }
        if (messageMap.hasKey("isDelete")) {
            message.setDelete(messageMap.getBoolean("isDelete"));
        }
        if (messageMap.hasKey("isEdit")) {
            message.setEdit(messageMap.getBoolean("isEdit"));
        }
        return message;
    }
}

