/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.BarHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.XAxisRendererBarChart;

public class BarChart
extends BarLineChartBase<BarData>
implements BarDataProvider {
    private boolean a = false;
    private boolean b = true;
    private boolean c = false;
    private boolean d = false;

    public BarChart(Context context) {
        super(context);
    }

    public BarChart(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public BarChart(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new BarChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mXAxisRenderer = new XAxisRendererBarChart(this.mViewPortHandler, this.mXAxis, this.mLeftAxisTransformer, this);
        this.setHighlighter(new BarHighlighter(this));
        this.mXChartMin = -0.5f;
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        this.mDeltaX += 0.5f;
        this.mDeltaX *= (float)((BarData)this.mData).getDataSetCount();
        float f = ((BarData)this.mData).getGroupSpace();
        this.mDeltaX += (float)((BarData)this.mData).getXValCount() * f;
        this.mXChartMax = this.mDeltaX - this.mXChartMin;
    }

    @Override
    public Highlight getHighlightByTouchPoint(float f, float f2) {
        if (this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        return this.getHighlighter().getHighlight(f, f2);
    }

    public RectF getBarBounds(BarEntry barEntry) {
        IBarDataSet iBarDataSet = (IBarDataSet)((BarData)this.mData).getDataSetForEntry(barEntry);
        if (iBarDataSet == null) {
            return null;
        }
        float f = iBarDataSet.getBarSpace();
        float f2 = barEntry.getVal();
        float f3 = barEntry.getXIndex();
        float f4 = 0.5f;
        float f5 = f / 2.0f;
        float f6 = f3 - f4 + f5;
        float f7 = f3 + f4 - f5;
        float f8 = f2 >= 0.0f ? f2 : 0.0f;
        float f9 = f2 <= 0.0f ? f2 : 0.0f;
        RectF rectF = new RectF(f6, f8, f7, f9);
        this.getTransformer(iBarDataSet.getAxisDependency()).rectValueToPixel(rectF);
        return rectF;
    }

    public void setDrawHighlightArrow(boolean bl) {
        this.a = bl;
    }

    @Override
    public boolean isDrawHighlightArrowEnabled() {
        return this.a;
    }

    public void setDrawValueAboveBar(boolean bl) {
        this.b = bl;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.b;
    }

    public void setDrawBarShadow(boolean bl) {
        this.c = bl;
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.c;
    }

    @Override
    public BarData getBarData() {
        return (BarData)this.mData;
    }

    @Override
    public int getLowestVisibleXIndex() {
        float f = ((BarData)this.mData).getDataSetCount();
        float f2 = f <= 1.0f ? 1.0f : f + ((BarData)this.mData).getGroupSpace();
        float[] fArray = new float[]{this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        return (int)(fArray[0] <= this.getXChartMin() ? 0.0f : fArray[0] / f2 + 1.0f);
    }

    @Override
    public int getHighestVisibleXIndex() {
        float f = ((BarData)this.mData).getDataSetCount();
        float f2 = f <= 1.0f ? 1.0f : f + ((BarData)this.mData).getGroupSpace();
        float[] fArray = new float[]{this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom()};
        this.getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        return (int)(fArray[0] >= this.getXChartMax() ? this.getXChartMax() / f2 : fArray[0] / f2);
    }

    @Override
    public void drawValueEnable(boolean bl) {
        this.d = bl;
    }

    @Override
    public boolean isDrawValueEnable() {
        return this.d;
    }
}

