/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.animation.EasingFunction;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.MarkerView;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.DefaultValueFormatter;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ChartInterface;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.listener.OnChartValueSelectedListener;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LegendRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@SuppressLint(value={"NewApi"})
public abstract class Chart<T extends ChartData<? extends IDataSet<? extends Entry>>>
extends ViewGroup
implements ChartInterface {
    public static final String LOG_TAG = "MPAndroidChart";
    protected boolean mLogEnabled = false;
    protected T mData = null;
    protected boolean mHighLightPerTapEnabled = true;
    private boolean a;
    private float b;
    protected ValueFormatter mDefaultFormatter;
    protected Paint mDescPaint;
    protected Paint mInfoPaint;
    protected String mDescription = "Description";
    protected float mDeltaX = 1.0f;
    protected float mXChartMin = 0.0f;
    protected float mXChartMax = 0.0f;
    protected boolean mTouchEnabled = true;
    protected Legend mLegend;
    protected OnChartValueSelectedListener mSelectionListener;
    protected ChartTouchListener mChartTouchListener;
    private String a;
    private OnChartGestureListener a;
    private String b;
    protected LegendRenderer mLegendRenderer;
    protected DataRenderer mRenderer;
    protected ChartHighlighter mHighlighter;
    protected ViewPortHandler mViewPortHandler;
    protected ChartAnimator mAnimator;
    private float c;
    private float d;
    private float e = 0.0f;
    private float f = 0.0f;
    private boolean b = false;
    protected Paint mDrawPaint;
    private PointF a;
    protected Highlight[] mIndicesToHighlight;
    protected boolean mDrawMarkerViews = true;
    protected MarkerView mMarkerView;
    int a;
    float a = 11.0f;
    public static final int PAINT_GRID_BACKGROUND = 4;
    public static final int PAINT_INFO = 7;
    public static final int PAINT_DESCRIPTION = 11;
    public static final int PAINT_HOLE = 13;
    public static final int PAINT_CENTER_TEXT = 14;
    public static final int PAINT_LEGEND_LABEL = 18;
    protected ArrayList<Runnable> mJobs = new ArrayList();
    private boolean c = false;
    private boolean d = true;

    public Chart(Context context) {
        super(context);
        this.init();
    }

    public Chart(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public Chart(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    protected void init() {
        this.setWillNotDraw(false);
        this.mAnimator = Build.VERSION.SDK_INT < 11 ? new ChartAnimator() : new ChartAnimator(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                Chart.this.postInvalidate();
            }
        });
        Utils.init(this.getContext());
        this.mDefaultFormatter = new DefaultValueFormatter(1);
        this.mViewPortHandler = new ViewPortHandler();
        this.mLegend = new Legend();
        this.mLegendRenderer = new LegendRenderer(this.mViewPortHandler, this.mLegend);
        this.mDescPaint = new Paint(1);
        this.mDescPaint.setColor(-16777216);
        this.mDescPaint.setTextAlign(Paint.Align.RIGHT);
        this.mDescPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mInfoPaint = new Paint(1);
        this.mInfoPaint.setColor(Color.rgb((int)247, (int)189, (int)51));
        this.mInfoPaint.setTextAlign(Paint.Align.CENTER);
        this.mInfoPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        this.mDrawPaint = new Paint(4);
        if (this.mLogEnabled) {
            Log.i((String)"", (String)"Chart.init()");
        }
    }

    public void setData(T t) {
        if (t == null) {
            Log.e((String)LOG_TAG, (String)"Cannot set data for chart. Provided data object is null.");
            return;
        }
        this.b = false;
        this.mData = t;
        this.calculateFormatter(((ChartData)t).getYMin(), ((ChartData)t).getYMax());
        for (IDataSet iDataSet : ((ChartData)this.mData).getDataSets()) {
            if (!Utils.needsDefaultFormatter(iDataSet.getValueFormatter())) continue;
            iDataSet.setValueFormatter(this.mDefaultFormatter);
        }
        this.notifyDataSetChanged();
        if (this.mLogEnabled) {
            Log.i((String)LOG_TAG, (String)"Data is set.");
        }
    }

    public void clear() {
        this.mData = null;
        this.mIndicesToHighlight = null;
        this.invalidate();
    }

    public void clearValues() {
        ((ChartData)this.mData).clearValues();
        this.invalidate();
    }

    public boolean isEmpty() {
        if (this.mData == null) {
            return true;
        }
        return ((ChartData)this.mData).getYValCount() <= 0;
    }

    public abstract void notifyDataSetChanged();

    protected abstract void calculateOffsets();

    protected abstract void calcMinMax();

    protected void calculateFormatter(float f, float f2) {
        float f3 = 0.0f;
        f3 = this.mData == null || ((ChartData)this.mData).getXValCount() < 2 ? Math.max(Math.abs(f), Math.abs(f2)) : Math.abs(f2 - f);
        int n = Utils.getDecimals(f3);
        this.mDefaultFormatter = new DefaultValueFormatter(n);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mViewPortHandler != null) {
            this.mViewPortHandler.setChartDimens(this.getWidth(), this.getHeight());
        }
        if (this.mData == null) {
            boolean bl = !TextUtils.isEmpty((CharSequence)this.a);
            boolean bl2 = !TextUtils.isEmpty((CharSequence)this.b);
            float f = bl ? (float)Utils.calcTextHeight(this.mInfoPaint, this.a) : 0.0f;
            float f2 = bl2 ? (float)Utils.calcTextHeight(this.mInfoPaint, this.b) : 0.0f;
            float f3 = bl && bl2 ? this.mInfoPaint.getFontSpacing() - f : 0.0f;
            float f4 = ((float)this.getHeight() - (f + f3 + f2)) / 2.0f + f;
            if (bl) {
                canvas.drawText(this.a, (float)(this.getWidth() / 2), f4, this.mInfoPaint);
                if (bl2) {
                    f4 = f4 + f + f3;
                }
            }
            if (bl2) {
                canvas.drawText(this.b, (float)(this.getWidth() / 2), f4, this.mInfoPaint);
            }
            return;
        }
        if (!this.b) {
            this.calculateOffsets();
            this.b = true;
        }
    }

    protected void drawDescription(Canvas canvas) {
        if (!this.mDescription.equals("")) {
            if (this.a == null) {
                canvas.drawText(this.mDescription, (float)this.getWidth() - this.mViewPortHandler.offsetRight() - 10.0f, (float)this.getHeight() - this.mViewPortHandler.offsetBottom() - 10.0f, this.mDescPaint);
            } else {
                canvas.drawText(this.mDescription, this.a.x, this.a.y, this.mDescPaint);
            }
        }
    }

    public Highlight[] getHighlighted() {
        return this.mIndicesToHighlight;
    }

    public boolean isHighlightPerTapEnabled() {
        return this.mHighLightPerTapEnabled;
    }

    public void setHighlightPerTapEnabled(boolean bl) {
        this.mHighLightPerTapEnabled = bl;
    }

    public boolean valuesToHighlight() {
        return this.mIndicesToHighlight != null && this.mIndicesToHighlight.length > 0 && this.mIndicesToHighlight[0] != null;
    }

    public void highlightValues(Highlight[] highlightArray) {
        this.mIndicesToHighlight = highlightArray;
        if (highlightArray == null || highlightArray.length <= 0 || highlightArray[0] == null) {
            this.mChartTouchListener.setLastHighlighted(null);
        } else {
            this.mChartTouchListener.setLastHighlighted(highlightArray[0]);
        }
        this.invalidate();
    }

    public void highlightValue(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= ((ChartData)this.mData).getXValCount() || n2 >= ((ChartData)this.mData).getDataSetCount()) {
            this.highlightValues(null);
        } else {
            this.highlightValues(new Highlight[]{new Highlight(n, n2)});
        }
    }

    public void highlightValue(Highlight highlight) {
        this.highlightValue(highlight, false);
    }

    public void highlightValue(Highlight highlight, boolean bl) {
        Entry entry = null;
        if (highlight == null) {
            this.mIndicesToHighlight = null;
        } else {
            if (this.mLogEnabled) {
                Log.i((String)LOG_TAG, (String)("Highlighted: " + highlight.toString()));
            }
            if ((entry = ((ChartData)this.mData).getEntryForHighlight(highlight)) == null || entry.getXIndex() != highlight.getXIndex()) {
                this.mIndicesToHighlight = null;
                highlight = null;
            } else {
                this.mIndicesToHighlight = new Highlight[]{highlight};
            }
        }
        if (bl && this.mSelectionListener != null) {
            if (!this.valuesToHighlight()) {
                this.mSelectionListener.onNothingSelected();
            } else {
                this.mSelectionListener.onValueSelected(entry, highlight.getDataSetIndex(), highlight);
            }
        }
        this.invalidate();
    }

    @Deprecated
    public void highlightTouch(Highlight highlight) {
        this.highlightValue(highlight, true);
    }

    public void setOnTouchListener(ChartTouchListener chartTouchListener) {
        this.mChartTouchListener = chartTouchListener;
    }

    public void setMarkerColor(int n) {
        this.a = n;
    }

    public void setMarkerSize(float f) {
        this.a = f;
    }

    protected void drawMarkers(Canvas canvas) {
        float[] fArray;
        Entry entry;
        int n;
        int n2;
        Highlight highlight;
        int n3;
        if (this.mMarkerView == null && this.valuesToHighlight() && this.d) {
            n3 = 0;
            while (n3 < this.mIndicesToHighlight.length) {
                highlight = this.mIndicesToHighlight[n3];
                n2 = highlight.getXIndex();
                n = highlight.getDataSetIndex();
                if ((float)n2 <= this.mDeltaX && (float)n2 <= this.mDeltaX * this.mAnimator.getPhaseX() && (entry = ((ChartData)this.mData).getEntryForHighlight(this.mIndicesToHighlight[n3])) != null && entry.getXIndex() == this.mIndicesToHighlight[n3].getXIndex() && this.mViewPortHandler.isInBounds((fArray = this.getMarkerPosition(entry, highlight))[0], fArray[1])) {
                    String string = String.valueOf(entry.getVal());
                    Paint paint = new Paint();
                    paint.setTextSize(this.a);
                    paint.setColor(this.a);
                    paint.setTextAlign(Paint.Align.CENTER);
                    canvas.drawText(string, fArray[0], fArray[1] - 8.0f, paint);
                }
                ++n3;
            }
        }
        if (!(this.mMarkerView != null && this.mDrawMarkerViews && this.valuesToHighlight() && this.d)) {
            return;
        }
        n3 = 0;
        while (n3 < this.mIndicesToHighlight.length) {
            highlight = this.mIndicesToHighlight[n3];
            n2 = highlight.getXIndex();
            n = highlight.getDataSetIndex();
            if ((float)n2 <= this.mDeltaX && (float)n2 <= this.mDeltaX * this.mAnimator.getPhaseX() && (entry = ((ChartData)this.mData).getEntryForHighlight(this.mIndicesToHighlight[n3])) != null && entry.getXIndex() == this.mIndicesToHighlight[n3].getXIndex() && this.mViewPortHandler.isInBounds((fArray = this.getMarkerPosition(entry, highlight))[0], fArray[1])) {
                this.mMarkerView.refreshContent(entry, highlight);
                this.mMarkerView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                this.mMarkerView.layout(0, 0, this.mMarkerView.getMeasuredWidth(), this.mMarkerView.getMeasuredHeight());
                if (fArray[1] - (float)this.mMarkerView.getHeight() <= 0.0f) {
                    float f = (float)this.mMarkerView.getHeight() - fArray[1];
                    this.mMarkerView.draw(canvas, fArray[0], fArray[1] + f);
                } else {
                    this.mMarkerView.draw(canvas, fArray[0], fArray[1]);
                }
            }
            ++n3;
        }
    }

    protected abstract float[] getMarkerPosition(Entry var1, Highlight var2);

    public ChartAnimator getAnimator() {
        return this.mAnimator;
    }

    public boolean isDragDecelerationEnabled() {
        return this.a;
    }

    public void setDragDecelerationEnabled(boolean bl) {
        this.a = bl;
    }

    public float getDragDecelerationFrictionCoef() {
        return this.b;
    }

    public void setDragDecelerationFrictionCoef(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f >= 1.0f) {
            f = 0.999f;
        }
        this.b = f;
    }

    public void animateXY(int n, int n2, EasingFunction easingFunction, EasingFunction easingFunction2) {
        this.mAnimator.animateXY(n, n2, easingFunction, easingFunction2);
    }

    public void animateX(int n, EasingFunction easingFunction) {
        this.mAnimator.animateX(n, easingFunction);
    }

    public void animateY(int n, EasingFunction easingFunction) {
        this.mAnimator.animateY(n, easingFunction);
    }

    public void animateXY(int n, int n2, Easing.EasingOption easingOption, Easing.EasingOption easingOption2) {
        this.mAnimator.animateXY(n, n2, easingOption, easingOption2);
    }

    public void animateX(int n, Easing.EasingOption easingOption) {
        this.mAnimator.animateX(n, easingOption);
    }

    public void animateY(int n, Easing.EasingOption easingOption) {
        this.mAnimator.animateY(n, easingOption);
    }

    public void animateX(int n) {
        this.mAnimator.animateX(n);
    }

    public void animateY(int n) {
        this.mAnimator.animateY(n);
    }

    public void animateXY(int n, int n2) {
        this.mAnimator.animateXY(n, n2);
    }

    @Override
    public ValueFormatter getDefaultValueFormatter() {
        return this.mDefaultFormatter;
    }

    public void setOnChartValueSelectedListener(OnChartValueSelectedListener onChartValueSelectedListener) {
        this.mSelectionListener = onChartValueSelectedListener;
    }

    public void setOnChartGestureListener(OnChartGestureListener onChartGestureListener) {
        this.a = onChartGestureListener;
    }

    public OnChartGestureListener getOnChartGestureListener() {
        return this.a;
    }

    public float getYMax() {
        return ((ChartData)this.mData).getYMax();
    }

    public float getYMin() {
        return ((ChartData)this.mData).getYMin();
    }

    @Override
    public float getXChartMax() {
        return this.mXChartMax;
    }

    @Override
    public float getXChartMin() {
        return this.mXChartMin;
    }

    @Override
    public int getXValCount() {
        return ((ChartData)this.mData).getXValCount();
    }

    public int getValueCount() {
        return ((ChartData)this.mData).getYValCount();
    }

    public PointF getCenter() {
        return new PointF((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    @Override
    public PointF getCenterOffsets() {
        return this.mViewPortHandler.getContentCenter();
    }

    public void setDescription(String string) {
        if (string == null) {
            string = "";
        }
        this.mDescription = string;
    }

    public void setDescriptionPosition(float f, float f2) {
        this.a = new PointF(f, f2);
    }

    public void setDescriptionTypeface(Typeface typeface) {
        this.mDescPaint.setTypeface(typeface);
    }

    public void setDescriptionTextSize(float f) {
        if (f > 16.0f) {
            f = 16.0f;
        }
        if (f < 6.0f) {
            f = 6.0f;
        }
        this.mDescPaint.setTextSize(Utils.convertDpToPixel(f));
    }

    public void setDescriptionColor(int n) {
        this.mDescPaint.setColor(n);
    }

    public void setExtraOffsets(float f, float f2, float f3, float f4) {
        this.setExtraLeftOffset(f);
        this.setExtraTopOffset(f2);
        this.setExtraRightOffset(f3);
        this.setExtraBottomOffset(f4);
    }

    public void setExtraTopOffset(float f) {
        this.c = Utils.convertDpToPixel(f);
    }

    public float getExtraTopOffset() {
        return this.c;
    }

    public void setExtraRightOffset(float f) {
        this.d = Utils.convertDpToPixel(f);
    }

    public float getExtraRightOffset() {
        return this.d;
    }

    public void setExtraBottomOffset(float f) {
        this.e = Utils.convertDpToPixel(f);
    }

    public float getExtraBottomOffset() {
        return this.e;
    }

    public void setExtraLeftOffset(float f) {
        this.f = Utils.convertDpToPixel(f);
    }

    public float getExtraLeftOffset() {
        return this.f;
    }

    public void setLogEnabled(boolean bl) {
        this.mLogEnabled = bl;
    }

    public boolean isLogEnabled() {
        return this.mLogEnabled;
    }

    public void setNoDataText(String string) {
        this.a = string;
    }

    public void setNoDataTextDescription(String string) {
        this.b = string;
    }

    public void setTouchEnabled(boolean bl) {
        this.mTouchEnabled = bl;
    }

    public void setMarkerView(MarkerView markerView) {
        this.mMarkerView = markerView;
    }

    public MarkerView getMarkerView() {
        return this.mMarkerView;
    }

    public Legend getLegend() {
        return this.mLegend;
    }

    public LegendRenderer getLegendRenderer() {
        return this.mLegendRenderer;
    }

    @Override
    public RectF getContentRect() {
        return this.mViewPortHandler.getContentRect();
    }

    public void disableScroll() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void enableScroll() {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(false);
        }
    }

    public void setPaint(Paint paint, int n) {
        switch (n) {
            case 7: {
                this.mInfoPaint = paint;
                break;
            }
            case 11: {
                this.mDescPaint = paint;
            }
        }
    }

    public Paint getPaint(int n) {
        switch (n) {
            case 7: {
                return this.mInfoPaint;
            }
            case 11: {
                return this.mDescPaint;
            }
        }
        return null;
    }

    public boolean isDrawMarkerViewEnabled() {
        return this.mDrawMarkerViews;
    }

    public void setDrawMarkerViews(boolean bl) {
        this.mDrawMarkerViews = bl;
    }

    public String getXValue(int n) {
        if (this.mData == null || ((ChartData)this.mData).getXValCount() <= n) {
            return null;
        }
        return ((ChartData)this.mData).getXVals().get(n);
    }

    public List<Entry> getEntriesAtIndex(int n) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        int n2 = 0;
        while (n2 < ((ChartData)this.mData).getDataSetCount()) {
            Object t = ((ChartData)this.mData).getDataSetByIndex(n2);
            Object t2 = t.getEntryForXIndex(n);
            if (t2 != null) {
                arrayList.add((Entry)t2);
            }
            ++n2;
        }
        return arrayList;
    }

    public T getData() {
        return this.mData;
    }

    public ViewPortHandler getViewPortHandler() {
        return this.mViewPortHandler;
    }

    public DataRenderer getRenderer() {
        return this.mRenderer;
    }

    public void setRenderer(DataRenderer dataRenderer) {
        if (dataRenderer != null) {
            this.mRenderer = dataRenderer;
        }
    }

    public ChartHighlighter getHighlighter() {
        return this.mHighlighter;
    }

    public void setHighlighter(ChartHighlighter chartHighlighter) {
        this.mHighlighter = chartHighlighter;
    }

    @Override
    public PointF getCenterOfView() {
        return this.getCenter();
    }

    public Bitmap getChartBitmap() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        Drawable drawable = this.getBackground();
        if (drawable != null) {
            drawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        this.draw(canvas);
        return bitmap;
    }

    public boolean saveToPath(String string, String string2) {
        Bitmap bitmap = this.getChartBitmap();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + string2 + "/" + string + ".png");
            bitmap.compress(Bitmap.CompressFormat.PNG, 40, (OutputStream)fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveToGallery(String string, String string2, String string3, Bitmap.CompressFormat compressFormat, int n) {
        if (n < 0 || n > 100) {
            n = 50;
        }
        long l = System.currentTimeMillis();
        File file = Environment.getExternalStorageDirectory();
        File file2 = new File(String.valueOf(file.getAbsolutePath()) + "/DCIM/" + string2);
        if (!file2.exists() && !file2.mkdirs()) {
            return false;
        }
        String string4 = "";
        switch (compressFormat) {
            case PNG: {
                string4 = "image/png";
                if (string.endsWith(".png")) break;
                string = String.valueOf(string) + ".png";
                break;
            }
            case WEBP: {
                string4 = "image/webp";
                if (string.endsWith(".webp")) break;
                string = String.valueOf(string) + ".webp";
                break;
            }
            default: {
                string4 = "image/jpeg";
                if (string.endsWith(".jpg") || string.endsWith(".jpeg")) break;
                string = String.valueOf(string) + ".jpg";
            }
        }
        String string5 = String.valueOf(file2.getAbsolutePath()) + "/" + string;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string5);
            Bitmap bitmap = this.getChartBitmap();
            bitmap.compress(compressFormat, n, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        long l2 = new File(string5).length();
        ContentValues contentValues = new ContentValues(8);
        contentValues.put("title", string);
        contentValues.put("_display_name", string);
        contentValues.put("date_added", Long.valueOf(l));
        contentValues.put("mime_type", string4);
        contentValues.put("description", string3);
        contentValues.put("orientation", Integer.valueOf(0));
        contentValues.put("_data", string5);
        contentValues.put("_size", Long.valueOf(l2));
        return this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues) != null;
    }

    public boolean saveToGallery(String string, int n) {
        return this.saveToGallery(string, "", "MPAndroidChart-Library Save", Bitmap.CompressFormat.JPEG, n);
    }

    public void removeViewportJob(Runnable runnable) {
        this.mJobs.remove(runnable);
    }

    public void clearAllViewportJobs() {
        this.mJobs.clear();
    }

    public void addViewportJob(Runnable runnable) {
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(runnable);
        } else {
            this.mJobs.add(runnable);
        }
    }

    public ArrayList<Runnable> getJobs() {
        return this.mJobs;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < this.getChildCount()) {
            this.getChildAt(n5).layout(n, n2, n3, n4);
            ++n5;
        }
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = (int)Utils.convertDpToPixel(50.0f);
        this.setMeasuredDimension(Math.max(this.getSuggestedMinimumWidth(), Chart.resolveSize((int)n3, (int)n)), Math.max(this.getSuggestedMinimumHeight(), Chart.resolveSize((int)n3, (int)n2)));
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        if (this.mLogEnabled) {
            Log.i((String)LOG_TAG, (String)"OnSizeChanged()");
        }
        if (n > 0 && n2 > 0 && n < 10000 && n2 < 10000) {
            this.mViewPortHandler.setChartDimens(n, n2);
            if (this.mLogEnabled) {
                Log.i((String)LOG_TAG, (String)("Setting chart dimens, width: " + n + ", height: " + n2));
            }
            for (Runnable runnable : this.mJobs) {
                this.post(runnable);
            }
            this.mJobs.clear();
        }
        this.notifyDataSetChanged();
        super.onSizeChanged(n, n2, n3, n4);
    }

    public void setHardwareAccelerationEnabled(boolean bl) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (bl) {
                this.setLayerType(2, null);
            } else {
                this.setLayerType(1, null);
            }
        } else {
            Log.e((String)LOG_TAG, (String)"Cannot enable/disable hardware acceleration for devices below API level 11.");
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.c) {
            this.a((View)this);
        }
    }

    private void a(View view) {
        if (view.getBackground() != null) {
            view.getBackground().setCallback(null);
        }
        if (view instanceof ViewGroup) {
            int n = 0;
            while (n < ((ViewGroup)view).getChildCount()) {
                this.a(((ViewGroup)view).getChildAt(n));
                ++n;
            }
            ((ViewGroup)view).removeAllViews();
        }
    }

    public void setUnbindEnabled(boolean bl) {
        this.c = bl;
    }

    public void drawHighLightValueEnable(boolean bl) {
        this.d = bl;
    }

    public boolean isDrawHighLightEnable() {
        return this.d;
    }
}

