/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.CombinedHighlighter;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.BubbleDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.CandleDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.renderer.CombinedChartRenderer;

public class CombinedChart
extends BarLineChartBase<CombinedData>
implements BarDataProvider,
BubbleDataProvider,
CandleDataProvider,
LineDataProvider,
ScatterDataProvider {
    private boolean a = false;
    private boolean b = true;
    private boolean c = false;
    protected DrawOrder[] mDrawOrder = new DrawOrder[]{DrawOrder.BAR, DrawOrder.BUBBLE, DrawOrder.LINE, DrawOrder.CANDLE, DrawOrder.SCATTER};

    public CombinedChart(Context context) {
        super(context);
    }

    public CombinedChart(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public CombinedChart(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void init() {
        super.init();
        this.setHighlighter(new CombinedHighlighter(this));
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        if (this.getBarData() != null || this.getCandleData() != null || this.getBubbleData() != null) {
            this.mXChartMin = -0.5f;
            this.mXChartMax = (float)((CombinedData)this.mData).getXVals().size() - 0.5f;
            if (this.getBubbleData() != null) {
                for (IBubbleDataSet iBubbleDataSet : this.getBubbleData().getDataSets()) {
                    float f = iBubbleDataSet.getXMin();
                    float f2 = iBubbleDataSet.getXMax();
                    if (f < this.mXChartMin) {
                        this.mXChartMin = f;
                    }
                    if (!(f2 > this.mXChartMax)) continue;
                    this.mXChartMax = f2;
                }
            }
        }
        this.mDeltaX = Math.abs(this.mXChartMax - this.mXChartMin);
        if (this.mDeltaX == 0.0f && this.getLineData() != null && this.getLineData().getYValCount() > 0) {
            this.mDeltaX = 1.0f;
        }
    }

    @Override
    public void setData(CombinedData combinedData) {
        this.mData = null;
        this.mRenderer = null;
        super.setData(combinedData);
        this.mRenderer = new CombinedChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mRenderer.initBuffers();
    }

    @Override
    public LineData getLineData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getLineData();
    }

    @Override
    public BarData getBarData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBarData();
    }

    @Override
    public ScatterData getScatterData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getScatterData();
    }

    @Override
    public CandleData getCandleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getCandleData();
    }

    @Override
    public BubbleData getBubbleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBubbleData();
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.c;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.b;
    }

    @Override
    public boolean isDrawHighlightArrowEnabled() {
        return this.a;
    }

    public void setDrawHighlightArrow(boolean bl) {
        this.a = bl;
    }

    public void setDrawValueAboveBar(boolean bl) {
        this.b = bl;
    }

    public void setDrawBarShadow(boolean bl) {
        this.c = bl;
    }

    public DrawOrder[] getDrawOrder() {
        return this.mDrawOrder;
    }

    public void setDrawOrder(DrawOrder[] drawOrderArray) {
        if (drawOrderArray == null || drawOrderArray.length <= 0) {
            return;
        }
        this.mDrawOrder = drawOrderArray;
    }

    @Override
    public void drawValueEnable(boolean bl) {
    }

    @Override
    public boolean isDrawValueEnable() {
        return false;
    }

    public static enum DrawOrder {
        BAR,
        BUBBLE,
        LINE,
        CANDLE,
        SCATTER;

    }
}

