/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.PieRadarChartBase;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.PieData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.PieChartRenderer;
import com.github.mikephil.charting.utils.Utils;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PieChart
extends PieRadarChartBase<PieData> {
    private RectF a;
    private boolean a;
    private float[] a;
    private float[] b;
    private boolean b;
    private boolean c;
    private boolean d = false;
    private boolean e = false;
    private CharSequence a = "";
    private float b = 50.0f;
    protected float mTransparentCircleRadiusPercent = 55.0f;
    private boolean f = true;
    private float c = 100.0f;
    protected float mMaxAngle = 360.0f;

    public PieChart(Context context) {
        super(context);
    }

    public PieChart(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public PieChart(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new PieChartRenderer(this, this.mAnimator, this.mViewPortHandler);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mData == null) {
            return;
        }
        this.mRenderer.drawData(canvas);
        if (this.valuesToHighlight()) {
            this.mRenderer.drawHighlighted(canvas, this.mIndicesToHighlight);
        }
        this.mRenderer.drawExtras(canvas);
        this.mRenderer.drawValues(canvas);
        this.mLegendRenderer.renderLegend(canvas);
        this.drawDescription(canvas);
        this.drawMarkers(canvas);
    }

    @Override
    public void calculateOffsets() {
        super.calculateOffsets();
        if (this.mData == null) {
            return;
        }
        float f = this.getDiameter();
        float f2 = f / 2.0f;
        PointF pointF = this.getCenterOffsets();
        float f3 = ((PieData)this.mData).getDataSet().getSelectionShift();
        this.a.set(pointF.x - f2 + f3, pointF.y - f2 + f3, pointF.x + f2 - f3, pointF.y + f2 - f3);
    }

    @Override
    protected void calcMinMax() {
        super.calcMinMax();
        this.a();
    }

    @Override
    protected float[] getMarkerPosition(Entry entry, Highlight highlight) {
        PointF pointF = this.getCenterCircleBox();
        float f = this.getRadius();
        float f2 = f / 10.0f * 3.6f;
        if (this.isDrawHoleEnabled()) {
            f2 = (f - f / 100.0f * this.getHoleRadius()) / 2.0f;
        }
        float f3 = this.getRotationAngle();
        int n = entry.getXIndex();
        float f4 = this.a[n] / 2.0f;
        float f5 = (float)((double)(f -= f2) * Math.cos(Math.toRadians((f3 + this.b[n] - f4) * this.mAnimator.getPhaseY())) + (double)pointF.x);
        float f6 = (float)((double)f * Math.sin(Math.toRadians((f3 + this.b[n] - f4) * this.mAnimator.getPhaseY())) + (double)pointF.y);
        return new float[]{f5, f6 - this.a};
    }

    private void a() {
        this.a = new float[((PieData)this.mData).getYValCount()];
        this.b = new float[((PieData)this.mData).getYValCount()];
        float f = ((PieData)this.mData).getYValueSum();
        List list = ((PieData)this.mData).getDataSets();
        int n = 0;
        int n2 = 0;
        while (n2 < ((PieData)this.mData).getDataSetCount()) {
            IPieDataSet iPieDataSet = (IPieDataSet)list.get(n2);
            int n3 = 0;
            while (n3 < iPieDataSet.getEntryCount()) {
                this.a[n] = this.a(Math.abs(((Entry)iPieDataSet.getEntryForIndex(n3)).getVal()), f);
                this.b[n] = n == 0 ? this.a[n] : this.b[n - 1] + this.a[n];
                ++n;
                ++n3;
            }
            ++n2;
        }
    }

    public boolean needsHighlight(int n, int n2) {
        if (!this.valuesToHighlight() || n2 < 0) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.mIndicesToHighlight.length) {
            if (this.mIndicesToHighlight[n3].getXIndex() == n && this.mIndicesToHighlight[n3].getDataSetIndex() == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private float a(float f, float f2) {
        return f / f2 * this.mMaxAngle;
    }

    @Override
    public int getIndexForAngle(float f) {
        float f2 = Utils.getNormalizedAngle(f - this.getRotationAngle());
        int n = 0;
        while (n < this.b.length) {
            if (this.b[n] > f2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getDataSetIndexForIndex(int n) {
        List list = ((PieData)this.mData).getDataSets();
        int n2 = 0;
        while (n2 < list.size()) {
            if (((IPieDataSet)list.get(n2)).getEntryForXIndex(n) != null) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public float[] getDrawAngles() {
        return this.a;
    }

    public float[] getAbsoluteAngles() {
        return this.b;
    }

    public void setHoleColor(int n) {
        ((PieChartRenderer)this.mRenderer).getPaintHole().setColor(n);
    }

    public void setDrawSlicesUnderHole(boolean bl) {
        this.c = bl;
    }

    public boolean isDrawSlicesUnderHoleEnabled() {
        return this.c;
    }

    public void setDrawHoleEnabled(boolean bl) {
        this.b = bl;
    }

    public boolean isDrawHoleEnabled() {
        return this.b;
    }

    public void setCenterText(CharSequence charSequence) {
        this.a = charSequence == null ? "" : charSequence;
    }

    public CharSequence getCenterText() {
        return this.a;
    }

    public void setDrawCenterText(boolean bl) {
        this.f = bl;
    }

    public boolean isDrawCenterTextEnabled() {
        return this.f;
    }

    @Override
    protected float getRequiredLegendOffset() {
        return this.mLegendRenderer.getLabelPaint().getTextSize() * 2.0f;
    }

    @Override
    protected float getRequiredBaseOffset() {
        return 0.0f;
    }

    @Override
    public float getRadius() {
        if (this.a == null) {
            return 0.0f;
        }
        return Math.min(this.a.width() / 2.0f, this.a.height() / 2.0f);
    }

    public RectF getCircleBox() {
        return this.a;
    }

    public PointF getCenterCircleBox() {
        return new PointF(this.a.centerX(), this.a.centerY());
    }

    public void setCenterTextTypeface(Typeface typeface) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setTypeface(typeface);
    }

    public void setCenterTextSize(float f) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setTextSize(Utils.convertDpToPixel(f));
    }

    public void setCenterTextSizePixels(float f) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setTextSize(f);
    }

    public void setCenterTextColor(int n) {
        ((PieChartRenderer)this.mRenderer).getPaintCenterText().setColor(n);
    }

    public void setHoleRadius(float f) {
        this.b = f;
    }

    public float getHoleRadius() {
        return this.b;
    }

    public void setTransparentCircleColor(int n) {
        Paint paint = ((PieChartRenderer)this.mRenderer).getPaintTransparentCircle();
        int n2 = paint.getAlpha();
        paint.setColor(n);
        paint.setAlpha(n2);
    }

    public void setTransparentCircleRadius(float f) {
        this.mTransparentCircleRadiusPercent = f;
    }

    public float getTransparentCircleRadius() {
        return this.mTransparentCircleRadiusPercent;
    }

    public void setTransparentCircleAlpha(int n) {
        ((PieChartRenderer)this.mRenderer).getPaintTransparentCircle().setAlpha(n);
    }

    public void setDrawSliceText(boolean bl) {
        this.a = bl;
    }

    public boolean isDrawSliceTextEnabled() {
        return this.a;
    }

    public boolean isDrawRoundedSlicesEnabled() {
        return this.e;
    }

    public void setUsePercentValues(boolean bl) {
        this.d = bl;
    }

    public boolean isUsePercentValuesEnabled() {
        return this.d;
    }

    public void setCenterTextRadiusPercent(float f) {
        this.c = f;
    }

    public float getCenterTextRadiusPercent() {
        return this.c;
    }

    public float getMaxAngle() {
        return this.mMaxAngle;
    }

    public void setMaxAngle(float f) {
        if (f > 360.0f) {
            f = 360.0f;
        }
        if (f < 90.0f) {
            f = 90.0f;
        }
        this.mMaxAngle = f;
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.mRenderer != null && this.mRenderer instanceof PieChartRenderer) {
            ((PieChartRenderer)this.mRenderer).releaseBitmap();
        }
        super.onDetachedFromWindow();
    }
}

