/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Typeface;
import android.util.Log;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class ChartData<T extends IDataSet<? extends Entry>> {
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;
    protected float mLeftAxisMax = 0.0f;
    protected float mLeftAxisMin = 0.0f;
    protected float mRightAxisMax = 0.0f;
    protected float mRightAxisMin = 0.0f;
    private int a;
    private float a = 0.0f;
    protected List<String> mXVals;
    protected List<T> mDataSets;

    public ChartData() {
        this.mXVals = new ArrayList<String>();
        this.mDataSets = new ArrayList<T>();
    }

    public ChartData(List<String> list) {
        this.mXVals = list;
        this.mDataSets = new ArrayList<T>();
        this.init();
    }

    public ChartData(String[] stringArray) {
        this.mXVals = this.a(stringArray);
        this.mDataSets = new ArrayList<T>();
        this.init();
    }

    public ChartData(List<String> list, List<T> list2) {
        this.mXVals = list;
        this.mDataSets = list2;
        this.init();
    }

    public ChartData(String[] stringArray, List<T> list) {
        this.mXVals = this.a(stringArray);
        this.mDataSets = list;
        this.init();
    }

    private List<String> a(String[] stringArray) {
        return Arrays.asList(stringArray);
    }

    protected void init() {
        this.b();
        this.calcYValueCount();
        this.calcMinMax(0, this.a);
        this.a();
    }

    private void a() {
        if (this.mXVals.size() <= 0) {
            this.a = 1.0f;
            return;
        }
        int n = 1;
        int n2 = 0;
        while (n2 < this.mXVals.size()) {
            int n3 = this.mXVals.get(n2).length();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        this.a = n;
    }

    private void b() {
        if (this.mDataSets == null) {
            return;
        }
        if (this instanceof ScatterData) {
            return;
        }
        int n = 0;
        while (n < this.mDataSets.size()) {
            if (((IDataSet)this.mDataSets.get(n)).getEntryCount() > this.mXVals.size()) {
                throw new IllegalArgumentException("One or more of the DataSet Entry arrays are longer than the x-values array of this ChartData object.");
            }
            ++n;
        }
    }

    public void notifyDataChanged() {
        this.init();
    }

    public void calcMinMax(int n, int n2) {
        if (this.mDataSets == null || this.mDataSets.size() < 1) {
            this.mYMax = 0.0f;
            this.mYMin = 0.0f;
        } else {
            T t;
            IDataSet iDataSet2;
            this.mYMin = Float.MAX_VALUE;
            this.mYMax = -3.4028235E38f;
            int n3 = 0;
            while (n3 < this.mDataSets.size()) {
                iDataSet2 = (IDataSet)this.mDataSets.get(n3);
                iDataSet2.calcMinMax(n, n2);
                if (iDataSet2.getYMin() < this.mYMin) {
                    this.mYMin = iDataSet2.getYMin();
                }
                if (iDataSet2.getYMax() > this.mYMax) {
                    this.mYMax = iDataSet2.getYMax();
                }
                ++n3;
            }
            if (this.mYMin == Float.MAX_VALUE) {
                this.mYMin = 0.0f;
                this.mYMax = 0.0f;
            }
            if ((t = this.getFirstLeft()) != null) {
                this.mLeftAxisMax = t.getYMax();
                this.mLeftAxisMin = t.getYMin();
                for (IDataSet iDataSet2 : this.mDataSets) {
                    if (iDataSet2.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
                    if (iDataSet2.getYMin() < this.mLeftAxisMin) {
                        this.mLeftAxisMin = iDataSet2.getYMin();
                    }
                    if (!(iDataSet2.getYMax() > this.mLeftAxisMax)) continue;
                    this.mLeftAxisMax = iDataSet2.getYMax();
                }
            }
            if ((iDataSet2 = this.getFirstRight()) != null) {
                this.mRightAxisMax = iDataSet2.getYMax();
                this.mRightAxisMin = iDataSet2.getYMin();
                for (Object object : this.mDataSets) {
                    if (object.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
                    if (object.getYMin() < this.mRightAxisMin) {
                        this.mRightAxisMin = object.getYMin();
                    }
                    if (!(object.getYMax() > this.mRightAxisMax)) continue;
                    this.mRightAxisMax = object.getYMax();
                }
            }
            this.a(t, iDataSet2);
        }
    }

    protected void calcYValueCount() {
        this.a = 0;
        if (this.mDataSets == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.mDataSets.size()) {
            n += ((IDataSet)this.mDataSets.get(n2)).getEntryCount();
            ++n2;
        }
        this.a = n;
    }

    public int getDataSetCount() {
        if (this.mDataSets == null) {
            return 0;
        }
        return this.mDataSets.size();
    }

    public float getYMin() {
        return this.mYMin;
    }

    public float getYMin(YAxis.AxisDependency axisDependency) {
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisMin;
        }
        return this.mRightAxisMin;
    }

    public float getYMax() {
        return this.mYMax;
    }

    public float getYMax(YAxis.AxisDependency axisDependency) {
        if (axisDependency == YAxis.AxisDependency.LEFT) {
            return this.mLeftAxisMax;
        }
        return this.mRightAxisMax;
    }

    public float getXValMaximumLength() {
        return this.a;
    }

    public int getYValCount() {
        this.calcYValueCount();
        return this.a;
    }

    public List<String> getXVals() {
        return this.mXVals;
    }

    public void addXValue(String string) {
        if (string != null && (float)string.length() > this.a) {
            this.a = string.length();
        }
        this.mXVals.add(string);
    }

    public void removeXValue(int n) {
        this.mXVals.remove(n);
    }

    public List<T> getDataSets() {
        return this.mDataSets;
    }

    protected int getDataSetIndexByLabel(List<T> list, String string, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < list.size()) {
                if (string.equalsIgnoreCase(((IDataSet)list.get(n)).getLabel())) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < list.size()) {
                if (string.equals(((IDataSet)list.get(n)).getLabel())) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int getXValCount() {
        return this.mXVals.size();
    }

    protected String[] getDataSetLabels() {
        String[] stringArray = new String[this.mDataSets.size()];
        int n = 0;
        while (n < this.mDataSets.size()) {
            stringArray[n] = ((IDataSet)this.mDataSets.get(n)).getLabel();
            ++n;
        }
        return stringArray;
    }

    public Entry getEntryForHighlight(Highlight highlight) {
        if (highlight.getDataSetIndex() >= this.mDataSets.size()) {
            return null;
        }
        return ((IDataSet)this.mDataSets.get(highlight.getDataSetIndex())).getEntryForXIndex(highlight.getXIndex());
    }

    public T getDataSetByLabel(String string, boolean bl) {
        int n = this.getDataSetIndexByLabel(this.mDataSets, string, bl);
        if (n < 0 || n >= this.mDataSets.size()) {
            return null;
        }
        return (T)((IDataSet)this.mDataSets.get(n));
    }

    public T getDataSetByIndex(int n) {
        if (this.mDataSets == null || n < 0 || n >= this.mDataSets.size()) {
            return null;
        }
        return (T)((IDataSet)this.mDataSets.get(n));
    }

    public void addDataSet(T t) {
        if (t == null) {
            return;
        }
        this.a += t.getEntryCount();
        if (this.mDataSets.size() <= 0) {
            this.mYMax = t.getYMax();
            this.mYMin = t.getYMin();
            if (t.getAxisDependency() == YAxis.AxisDependency.LEFT) {
                this.mLeftAxisMax = t.getYMax();
                this.mLeftAxisMin = t.getYMin();
            } else {
                this.mRightAxisMax = t.getYMax();
                this.mRightAxisMin = t.getYMin();
            }
        } else {
            if (this.mYMax < t.getYMax()) {
                this.mYMax = t.getYMax();
            }
            if (this.mYMin > t.getYMin()) {
                this.mYMin = t.getYMin();
            }
            if (t.getAxisDependency() == YAxis.AxisDependency.LEFT) {
                if (this.mLeftAxisMax < t.getYMax()) {
                    this.mLeftAxisMax = t.getYMax();
                }
                if (this.mLeftAxisMin > t.getYMin()) {
                    this.mLeftAxisMin = t.getYMin();
                }
            } else {
                if (this.mRightAxisMax < t.getYMax()) {
                    this.mRightAxisMax = t.getYMax();
                }
                if (this.mRightAxisMin > t.getYMin()) {
                    this.mRightAxisMin = t.getYMin();
                }
            }
        }
        this.mDataSets.add(t);
        this.a(this.getFirstLeft(), this.getFirstRight());
    }

    private void a(T t, T t2) {
        if (t == null) {
            this.mLeftAxisMax = this.mRightAxisMax;
            this.mLeftAxisMin = this.mRightAxisMin;
        } else if (t2 == null) {
            this.mRightAxisMax = this.mLeftAxisMax;
            this.mRightAxisMin = this.mLeftAxisMin;
        }
    }

    public boolean removeDataSet(T t) {
        if (t == null) {
            return false;
        }
        boolean bl = this.mDataSets.remove(t);
        if (bl) {
            this.a -= t.getEntryCount();
            this.calcMinMax(0, this.a);
        }
        return bl;
    }

    public boolean removeDataSet(int n) {
        if (n >= this.mDataSets.size() || n < 0) {
            return false;
        }
        IDataSet iDataSet = (IDataSet)this.mDataSets.get(n);
        return this.removeDataSet(iDataSet);
    }

    public void addEntry(Entry entry, int n) {
        if (this.mDataSets.size() > n && n >= 0) {
            IDataSet iDataSet = (IDataSet)this.mDataSets.get(n);
            if (!iDataSet.addEntry(entry)) {
                return;
            }
            float f = entry.getVal();
            if (this.a == 0) {
                this.mYMin = f;
                this.mYMax = f;
                if (iDataSet.getAxisDependency() == YAxis.AxisDependency.LEFT) {
                    this.mLeftAxisMax = entry.getVal();
                    this.mLeftAxisMin = entry.getVal();
                } else {
                    this.mRightAxisMax = entry.getVal();
                    this.mRightAxisMin = entry.getVal();
                }
            } else {
                if (this.mYMax < f) {
                    this.mYMax = f;
                }
                if (this.mYMin > f) {
                    this.mYMin = f;
                }
                if (iDataSet.getAxisDependency() == YAxis.AxisDependency.LEFT) {
                    if (this.mLeftAxisMax < entry.getVal()) {
                        this.mLeftAxisMax = entry.getVal();
                    }
                    if (this.mLeftAxisMin > entry.getVal()) {
                        this.mLeftAxisMin = entry.getVal();
                    }
                } else {
                    if (this.mRightAxisMax < entry.getVal()) {
                        this.mRightAxisMax = entry.getVal();
                    }
                    if (this.mRightAxisMin > entry.getVal()) {
                        this.mRightAxisMin = entry.getVal();
                    }
                }
            }
            ++this.a;
            this.a(this.getFirstLeft(), this.getFirstRight());
        } else {
            Log.e((String)"addEntry", (String)"Cannot add Entry because dataSetIndex too high or too low.");
        }
    }

    public boolean removeEntry(Entry entry, int n) {
        if (entry == null || n >= this.mDataSets.size()) {
            return false;
        }
        IDataSet iDataSet = (IDataSet)this.mDataSets.get(n);
        if (iDataSet != null) {
            boolean bl = iDataSet.removeEntry(entry);
            if (bl) {
                --this.a;
                this.calcMinMax(0, this.a);
            }
            return bl;
        }
        return false;
    }

    public boolean removeEntry(int n, int n2) {
        if (n2 >= this.mDataSets.size()) {
            return false;
        }
        IDataSet iDataSet = (IDataSet)this.mDataSets.get(n2);
        Object t = iDataSet.getEntryForXIndex(n);
        if (t == null || ((Entry)t).getXIndex() != n) {
            return false;
        }
        return this.removeEntry((Entry)t, n2);
    }

    public T getDataSetForEntry(Entry entry) {
        if (entry == null) {
            return null;
        }
        int n = 0;
        while (n < this.mDataSets.size()) {
            IDataSet iDataSet = (IDataSet)this.mDataSets.get(n);
            int n2 = 0;
            while (n2 < iDataSet.getEntryCount()) {
                if (entry.equalTo((Entry)iDataSet.getEntryForXIndex(entry.getXIndex()))) {
                    return (T)iDataSet;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public int[] getColors() {
        if (this.mDataSets == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.mDataSets.size()) {
            n += ((IDataSet)this.mDataSets.get(n2)).getColors().size();
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.mDataSets.size()) {
            List<Integer> list = ((IDataSet)this.mDataSets.get(n4)).getColors();
            for (Integer n5 : list) {
                nArray[n3] = n5;
                ++n3;
            }
            ++n4;
        }
        return nArray;
    }

    public int getIndexOfDataSet(T t) {
        int n = 0;
        while (n < this.mDataSets.size()) {
            if (this.mDataSets.get(n) == t) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public T getFirstLeft() {
        for (IDataSet iDataSet : this.mDataSets) {
            if (iDataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
            return (T)iDataSet;
        }
        return null;
    }

    public T getFirstRight() {
        for (IDataSet iDataSet : this.mDataSets) {
            if (iDataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
            return (T)iDataSet;
        }
        return null;
    }

    public static List<String> generateXVals(int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n;
        while (n3 < n2) {
            arrayList.add("" + n3);
            ++n3;
        }
        return arrayList;
    }

    public void setValueFormatter(ValueFormatter valueFormatter) {
        if (valueFormatter == null) {
            return;
        }
        for (IDataSet iDataSet : this.mDataSets) {
            iDataSet.setValueFormatter(valueFormatter);
        }
    }

    public void setValueTextColor(int n) {
        for (IDataSet iDataSet : this.mDataSets) {
            iDataSet.setValueTextColor(n);
        }
    }

    public void setValueTextColors(List<Integer> list) {
        for (IDataSet iDataSet : this.mDataSets) {
            iDataSet.setValueTextColors(list);
        }
    }

    public void setValueTypeface(Typeface typeface) {
        for (IDataSet iDataSet : this.mDataSets) {
            iDataSet.setValueTypeface(typeface);
        }
    }

    public void setValueTextSize(float f) {
        for (IDataSet iDataSet : this.mDataSets) {
            iDataSet.setValueTextSize(f);
        }
    }

    public void setDrawValues(boolean bl) {
        for (IDataSet iDataSet : this.mDataSets) {
            iDataSet.setDrawValues(bl);
        }
    }

    public void setHighlightEnabled(boolean bl) {
        for (IDataSet iDataSet : this.mDataSets) {
            iDataSet.setHighlightEnabled(bl);
        }
    }

    public boolean isHighlightEnabled() {
        for (IDataSet iDataSet : this.mDataSets) {
            if (iDataSet.isHighlightEnabled()) continue;
            return false;
        }
        return true;
    }

    public void clearValues() {
        this.mDataSets.clear();
        this.notifyDataChanged();
    }

    public boolean contains(T t) {
        for (IDataSet iDataSet : this.mDataSets) {
            if (!iDataSet.equals(t)) continue;
            return true;
        }
        return false;
    }
}

