/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BaseDataSet;
import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSet<T extends Entry>
extends BaseDataSet<T> {
    protected List<T> mYVals = null;
    protected float mYMax = 0.0f;
    protected float mYMin = 0.0f;

    public DataSet(List<T> list, String string) {
        super(string);
        this.mYVals = list;
        if (this.mYVals == null) {
            this.mYVals = new ArrayList<T>();
        }
        this.calcMinMax(0, this.mYVals.size());
    }

    @Override
    public void calcMinMax(int n, int n2) {
        if (this.mYVals == null) {
            return;
        }
        int n3 = this.mYVals.size();
        if (n3 == 0) {
            return;
        }
        int n4 = n2 == 0 || n2 >= n3 ? n3 - 1 : n2;
        this.mYMin = Float.MAX_VALUE;
        this.mYMax = -3.4028235E38f;
        int n5 = n;
        while (n5 <= n4) {
            Entry entry = (Entry)this.mYVals.get(n5);
            if (entry != null && !Float.isNaN(entry.getVal())) {
                if (entry.getVal() < this.mYMin) {
                    this.mYMin = entry.getVal();
                }
                if (entry.getVal() > this.mYMax) {
                    this.mYMax = entry.getVal();
                }
            }
            ++n5;
        }
        if (this.mYMin == Float.MAX_VALUE) {
            this.mYMin = 0.0f;
            this.mYMax = 0.0f;
        }
    }

    @Override
    public int getEntryCount() {
        return this.mYVals.size();
    }

    public List<T> getYVals() {
        return this.mYVals;
    }

    public abstract DataSet<T> copy();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toSimpleString());
        int n = 0;
        while (n < this.mYVals.size()) {
            stringBuffer.append(String.valueOf(((Entry)this.mYVals.get(n)).toString()) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toSimpleString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataSet, label: " + (this.getLabel() == null ? "" : this.getLabel()) + ", entries: " + this.mYVals.size() + "\n");
        return stringBuffer.toString();
    }

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    @Override
    public void addEntryOrdered(T t) {
        if (t == null) {
            return;
        }
        float f = ((Entry)t).getVal();
        if (this.mYVals == null) {
            this.mYVals = new ArrayList<T>();
        }
        if (this.mYVals.size() == 0) {
            this.mYMax = f;
            this.mYMin = f;
        } else {
            if (this.mYMax < f) {
                this.mYMax = f;
            }
            if (this.mYMin > f) {
                this.mYMin = f;
            }
        }
        if (this.mYVals.size() > 0 && ((Entry)this.mYVals.get(this.mYVals.size() - 1)).getXIndex() > ((Entry)t).getXIndex()) {
            int n = this.getEntryIndex(((Entry)t).getXIndex(), Rounding.UP);
            this.mYVals.add(n, t);
            return;
        }
        this.mYVals.add(t);
    }

    @Override
    public void clear() {
        this.mYVals.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean addEntry(T t) {
        if (t == null) {
            return false;
        }
        float f = ((Entry)t).getVal();
        List<T> list = this.getYVals();
        if (list == null) {
            list = new ArrayList<T>();
        }
        if (list.size() == 0) {
            this.mYMax = f;
            this.mYMin = f;
        } else {
            if (this.mYMax < f) {
                this.mYMax = f;
            }
            if (this.mYMin > f) {
                this.mYMin = f;
            }
        }
        list.add(t);
        return true;
    }

    @Override
    public boolean removeEntry(T t) {
        if (t == null) {
            return false;
        }
        if (this.mYVals == null) {
            return false;
        }
        boolean bl = this.mYVals.remove(t);
        if (bl) {
            this.calcMinMax(0, this.mYVals.size());
        }
        return bl;
    }

    @Override
    public int getEntryIndex(Entry entry) {
        return this.mYVals.indexOf(entry);
    }

    @Override
    public T getEntryForXIndex(int n, Rounding rounding) {
        int n2 = this.getEntryIndex(n, rounding);
        if (n2 > -1) {
            return (T)((Entry)this.mYVals.get(n2));
        }
        return null;
    }

    @Override
    public T getEntryForXIndex(int n) {
        return this.getEntryForXIndex(n, Rounding.CLOSEST);
    }

    @Override
    public T getEntryForIndex(int n) {
        return (T)((Entry)this.mYVals.get(n));
    }

    @Override
    public int getEntryIndex(int n, Rounding rounding) {
        int n2;
        int n3 = 0;
        int n4 = this.mYVals.size() - 1;
        int n5 = -1;
        while (n3 <= n4) {
            n2 = (n4 + n3) / 2;
            if (n == ((Entry)this.mYVals.get(n2)).getXIndex()) {
                while (n2 > 0 && ((Entry)this.mYVals.get(n2 - 1)).getXIndex() == n) {
                    --n2;
                }
                return n2;
            }
            if (n > ((Entry)this.mYVals.get(n2)).getXIndex()) {
                n3 = n2 + 1;
            } else {
                n4 = n2 - 1;
            }
            n5 = n2;
        }
        if (n5 != -1) {
            n2 = ((Entry)this.mYVals.get(n5)).getXIndex();
            if (rounding == Rounding.UP) {
                if (n2 < n && n5 < this.mYVals.size() - 1) {
                    ++n5;
                }
            } else if (rounding == Rounding.DOWN && n2 > n && n5 > 0) {
                --n5;
            }
        }
        return n5;
    }

    @Override
    public float getYValForXIndex(int n) {
        T t = this.getEntryForXIndex(n);
        if (t != null && ((Entry)t).getXIndex() == n) {
            return ((Entry)t).getVal();
        }
        return Float.NaN;
    }

    public List<T> getEntriesForXIndex(int n) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        int n2 = 0;
        int n3 = this.mYVals.size() - 1;
        while (n2 <= n3) {
            int n4 = (n3 + n2) / 2;
            Entry entry = (Entry)this.mYVals.get(n4);
            if (n == entry.getXIndex()) {
                while (n4 > 0 && ((Entry)this.mYVals.get(n4 - 1)).getXIndex() == n) {
                    --n4;
                }
                n3 = this.mYVals.size();
                while (n4 < n3) {
                    entry = (Entry)this.mYVals.get(n4);
                    if (entry.getXIndex() != n) break;
                    arrayList.add(entry);
                    ++n4;
                }
            }
            if (n > entry.getXIndex()) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return arrayList;
    }

    public static enum Rounding {
        UP,
        DOWN,
        CLOSEST;

    }
}

