/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.filter;

import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Approximator {
    private ApproximatorType a;
    private double a;
    private float a;
    private float b = 1.0f;
    private boolean[] a = 1.0f;

    public Approximator() {
        this.a = ApproximatorType.NONE;
    }

    public Approximator(ApproximatorType approximatorType, double d) {
        this.setup(approximatorType, d);
    }

    public void setup(ApproximatorType approximatorType, double d) {
        this.a = approximatorType;
        this.a = d;
    }

    public void setTolerance(double d) {
        this.a = d;
    }

    public void setType(ApproximatorType approximatorType) {
        this.a = approximatorType;
    }

    public void setRatios(float f, float f2) {
        this.b = f;
        this.a = f2;
    }

    public List<Entry> filter(List<Entry> list) {
        return this.filter(list, this.a);
    }

    public List<Entry> filter(List<Entry> list, double d) {
        if (d <= 0.0) {
            return list;
        }
        this.a = new boolean[list.size()];
        switch (this.a) {
            case DOUGLAS_PEUCKER: {
                return this.a(list, d);
            }
            case NONE: {
                return list;
            }
        }
        return list;
    }

    private List<Entry> a(List<Entry> list, double d) {
        if (d <= 0.0 || list.size() < 3) {
            return list;
        }
        this.a[0] = true;
        this.a[list.size() - 1] = true;
        this.a(list, d, 0, list.size() - 1);
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        int n = 0;
        while (n < list.size()) {
            if (this.a[n]) {
                Entry entry = list.get(n);
                arrayList.add(new Entry(entry.getVal(), entry.getXIndex()));
            }
            ++n;
        }
        return arrayList;
    }

    private void a(List<Entry> list, double d, int n, int n2) {
        if (n2 <= n + 1) {
            return;
        }
        int n3 = 0;
        double d2 = 0.0;
        Entry entry = list.get(n);
        Entry entry2 = list.get(n2);
        int n4 = n + 1;
        while (n4 < n2) {
            double d3 = this.calcAngleBetweenLines(entry, entry2, entry, list.get(n4));
            if (d3 > d2) {
                d2 = d3;
                n3 = n4;
            }
            ++n4;
        }
        if (d2 > d) {
            this.a[n3] = true;
            this.a(list, d, n, n3);
            this.a(list, d, n3, n2);
        }
    }

    public double calcPointToLineDistance(Entry entry, Entry entry2, Entry entry3) {
        float f = (float)entry2.getXIndex() - (float)entry.getXIndex();
        float f2 = (float)entry3.getXIndex() - (float)entry.getXIndex();
        double d = Math.sqrt(f * f + (entry2.getVal() - entry.getVal()) * (entry2.getVal() - entry.getVal()));
        return (double)Math.abs(f2 * (entry2.getVal() - entry.getVal()) - (entry3.getVal() - entry.getVal()) * f) / d;
    }

    public double calcAngleBetweenLines(Entry entry, Entry entry2, Entry entry3, Entry entry4) {
        double d = this.calcAngleWithRatios(entry, entry2);
        double d2 = this.calcAngleWithRatios(entry3, entry4);
        return Math.abs(d - d2);
    }

    public double calcAngleWithRatios(Entry entry, Entry entry2) {
        float f = (float)entry2.getXIndex() * this.b - (float)entry.getXIndex() * this.b;
        float f2 = entry2.getVal() * this.a - entry.getVal() * this.a;
        double d = Math.atan2(f2, f) * 180.0 / Math.PI;
        return d;
    }

    public double calcAngle(Entry entry, Entry entry2) {
        float f = entry2.getXIndex() - entry.getXIndex();
        float f2 = entry2.getVal() - entry.getVal();
        double d = Math.atan2(f2, f) * 180.0 / Math.PI;
        return d;
    }

    public static enum ApproximatorType {
        NONE,
        DOUGLAS_PEUCKER;

    }
}

