/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.highlight;

import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;

public class BarHighlighter
extends ChartHighlighter<BarDataProvider> {
    public BarHighlighter(BarDataProvider barDataProvider) {
        super(barDataProvider);
    }

    @Override
    public Highlight getHighlight(float f, float f2) {
        Highlight highlight = super.getHighlight(f, f2);
        if (highlight == null) {
            return highlight;
        }
        IBarDataSet iBarDataSet = (IBarDataSet)((BarDataProvider)this.mChart).getBarData().getDataSetByIndex(highlight.getDataSetIndex());
        if (iBarDataSet.isStacked()) {
            float[] fArray = new float[2];
            fArray[1] = f2;
            ((BarDataProvider)this.mChart).getTransformer(iBarDataSet.getAxisDependency()).pixelsToValue(fArray);
            return this.getStackedHighlight(highlight, iBarDataSet, highlight.getXIndex(), highlight.getDataSetIndex(), fArray[1]);
        }
        return highlight;
    }

    @Override
    protected int getXIndex(float f) {
        if (!((BarDataProvider)this.mChart).getBarData().isGrouped()) {
            return super.getXIndex(f);
        }
        float f2 = this.getBase(f);
        int n = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int n2 = (int)f2 / n;
        int n3 = ((BarDataProvider)this.mChart).getData().getXValCount();
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= n3) {
            n2 = n3 - 1;
        }
        return n2;
    }

    @Override
    protected int getDataSetIndex(int n, float f, float f2) {
        int n2;
        if (!((BarDataProvider)this.mChart).getBarData().isGrouped()) {
            return 0;
        }
        float f3 = this.getBase(f);
        int n3 = (int)f3 % (n2 = ((BarDataProvider)this.mChart).getBarData().getDataSetCount());
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= n2) {
            n3 = n2 - 1;
        }
        return n3;
    }

    protected Highlight getStackedHighlight(Highlight highlight, IBarDataSet iBarDataSet, int n, int n2, double d) {
        BarEntry barEntry = (BarEntry)iBarDataSet.getEntryForXIndex(n);
        if (barEntry == null || barEntry.getVals() == null) {
            return highlight;
        }
        Range[] rangeArray = this.getRanges(barEntry);
        int n3 = this.getClosestStackIndex(rangeArray, (float)d);
        if (rangeArray.length > 0) {
            return new Highlight(n, n2, n3, rangeArray[n3]);
        }
        return null;
    }

    protected int getClosestStackIndex(Range[] rangeArray, float f) {
        if (rangeArray == null || rangeArray.length == 0) {
            return 0;
        }
        int n = 0;
        Range[] rangeArray2 = rangeArray;
        int n2 = rangeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Range range = rangeArray2[n3];
            if (range.contains(f)) {
                return n;
            }
            ++n;
            ++n3;
        }
        int n4 = Math.max(rangeArray.length - 1, 0);
        return f > rangeArray[n4].to ? n4 : 0;
    }

    protected float getBase(float f) {
        float[] fArray = new float[2];
        fArray[0] = f;
        ((BarDataProvider)this.mChart).getTransformer(YAxis.AxisDependency.LEFT).pixelsToValue(fArray);
        float f2 = fArray[0];
        int n = ((BarDataProvider)this.mChart).getBarData().getDataSetCount();
        int n2 = (int)(f2 / ((float)n + ((BarDataProvider)this.mChart).getBarData().getGroupSpace()));
        float f3 = ((BarDataProvider)this.mChart).getBarData().getGroupSpace() * (float)n2;
        float f4 = f2 - f3;
        return f4;
    }

    protected Range[] getRanges(BarEntry barEntry) {
        float[] fArray = barEntry.getVals();
        if (fArray == null || fArray.length == 0) {
            return new Range[0];
        }
        Range[] rangeArray = new Range[fArray.length];
        float f = -barEntry.getNegativeSum();
        float f2 = 0.0f;
        int n = 0;
        while (n < rangeArray.length) {
            float f3 = fArray[n];
            if (f3 < 0.0f) {
                rangeArray[n] = new Range(f, f + Math.abs(f3));
                f += Math.abs(f3);
            } else {
                rangeArray[n] = new Range(f2, f2 + f3);
                f2 += f3;
            }
            ++n;
        }
        return rangeArray;
    }
}

