/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BarLineChartTouchListener
extends ChartTouchListener<BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>>> {
    private Matrix a;
    private Matrix b;
    private PointF a;
    private PointF b;
    private float a;
    private float b = 1.0f;
    private float c;
    private IDataSet a;
    private VelocityTracker a;
    private long a = 0L;
    private PointF c = 1.0f;
    private PointF d;
    private float d;
    private float e;

    public BarLineChartTouchListener(BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>> barLineChartBase, Matrix matrix) {
        super(barLineChartBase);
        this.b = new Matrix();
        this.a = new PointF();
        this.b = new PointF();
        this.c = new PointF();
        this.d = new PointF();
        this.a = matrix;
        this.d = Utils.convertDpToPixel(3.0f);
        this.e = Utils.convertDpToPixel(3.5f);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.a == null) {
            this.a = VelocityTracker.obtain();
        }
        this.a.addMovement(motionEvent);
        if (motionEvent.getActionMasked() == 3 && this.a != null) {
            this.a.recycle();
            this.a = null;
        }
        if (this.mTouchMode == 0) {
            this.mGestureDetector.onTouchEvent(motionEvent);
        }
        if (!(((BarLineChartBase)this.mChart).isDragEnabled() || ((BarLineChartBase)this.mChart).isScaleXEnabled() || ((BarLineChartBase)this.mChart).isScaleYEnabled())) {
            return true;
        }
        switch (motionEvent.getAction() & 0xFF) {
            case 0: {
                this.startAction(motionEvent);
                this.stopDeceleration();
                this.a(motionEvent);
                break;
            }
            case 5: {
                if (motionEvent.getPointerCount() < 2) break;
                ((BarLineChartBase)this.mChart).disableScroll();
                this.a(motionEvent);
                this.a = BarLineChartTouchListener.getXDist(motionEvent);
                this.b = BarLineChartTouchListener.getYDist(motionEvent);
                this.c = BarLineChartTouchListener.spacing(motionEvent);
                if (this.c > 10.0f) {
                    this.mTouchMode = ((BarLineChartBase)this.mChart).isPinchZoomEnabled() ? 4 : (this.a > this.b ? 2 : 3);
                }
                BarLineChartTouchListener.midPoint(this.b, motionEvent);
                break;
            }
            case 2: {
                if (this.mTouchMode == 1) {
                    ((BarLineChartBase)this.mChart).disableScroll();
                    this.b(motionEvent);
                    break;
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4) {
                    ((BarLineChartBase)this.mChart).disableScroll();
                    if (!((BarLineChartBase)this.mChart).isScaleXEnabled() && !((BarLineChartBase)this.mChart).isScaleYEnabled()) break;
                    this.c(motionEvent);
                    break;
                }
                if (this.mTouchMode != 0 || !(Math.abs(BarLineChartTouchListener.distance(motionEvent.getX(), this.a.x, motionEvent.getY(), this.a.y)) > this.d)) break;
                if (((BarLineChartBase)this.mChart).hasNoDragOffset()) {
                    if (!((BarLineChartBase)this.mChart).isFullyZoomedOut() && ((BarLineChartBase)this.mChart).isDragEnabled()) {
                        this.mTouchMode = 1;
                        break;
                    }
                    this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
                    if (!((BarLineChartBase)this.mChart).isHighlightPerDragEnabled()) break;
                    this.d(motionEvent);
                    break;
                }
                if (!((BarLineChartBase)this.mChart).isDragEnabled()) break;
                this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
                this.mTouchMode = 1;
                break;
            }
            case 1: {
                VelocityTracker velocityTracker = this.a;
                int n = motionEvent.getPointerId(0);
                velocityTracker.computeCurrentVelocity(1000, (float)Utils.getMaximumFlingVelocity());
                float f = velocityTracker.getYVelocity(n);
                float f2 = velocityTracker.getXVelocity(n);
                if ((Math.abs(f2) > (float)Utils.getMinimumFlingVelocity() || Math.abs(f) > (float)Utils.getMinimumFlingVelocity()) && this.mTouchMode == 1 && ((BarLineChartBase)this.mChart).isDragDecelerationEnabled()) {
                    this.stopDeceleration();
                    this.a = AnimationUtils.currentAnimationTimeMillis();
                    this.c = new PointF(motionEvent.getX(), motionEvent.getY());
                    this.d = new PointF(f2, f);
                    Utils.postInvalidateOnAnimation((View)this.mChart);
                }
                if (this.mTouchMode == 2 || this.mTouchMode == 3 || this.mTouchMode == 4 || this.mTouchMode == 5) {
                    ((BarLineChartBase)this.mChart).calculateOffsets();
                    ((BarLineChartBase)this.mChart).postInvalidate();
                }
                this.mTouchMode = 0;
                ((BarLineChartBase)this.mChart).enableScroll();
                if (this.a != null) {
                    this.a.recycle();
                    this.a = null;
                }
                this.endAction(motionEvent);
                break;
            }
            case 6: {
                Utils.velocityTrackerPointerUpCleanUpIfNecessary(motionEvent, this.a);
                this.mTouchMode = 5;
                break;
            }
            case 3: {
                this.mTouchMode = 0;
                this.endAction(motionEvent);
            }
        }
        this.a = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.a, (View)this.mChart, true);
        return true;
    }

    private void a(MotionEvent motionEvent) {
        this.b.set(this.a);
        this.a.set(motionEvent.getX(), motionEvent.getY());
        this.a = ((BarLineChartBase)this.mChart).getDataSetByTouchPoint(motionEvent.getX(), motionEvent.getY());
    }

    private void b(MotionEvent motionEvent) {
        float f;
        float f2;
        this.mLastGesture = ChartTouchListener.ChartGesture.DRAG;
        this.a.set(this.b);
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (((BarLineChartBase)this.mChart).isAnyAxisInverted() && this.a != null && ((BarLineChartBase)this.mChart).getAxis(this.a.getAxisDependency()).isInverted()) {
            if (this.mChart instanceof HorizontalBarChart) {
                f2 = -(motionEvent.getX() - this.a.x);
                f = motionEvent.getY() - this.a.y;
            } else {
                f2 = motionEvent.getX() - this.a.x;
                f = -(motionEvent.getY() - this.a.y);
            }
        } else {
            f2 = motionEvent.getX() - this.a.x;
            f = motionEvent.getY() - this.a.y;
        }
        this.a.postTranslate(f2, f);
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartTranslate(motionEvent, f2, f);
        }
    }

    private void c(MotionEvent motionEvent) {
        if (motionEvent.getPointerCount() >= 2) {
            boolean bl;
            OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
            float f = BarLineChartTouchListener.spacing(motionEvent);
            float f2 = Math.abs(motionEvent.getX(0) - motionEvent.getX(1));
            float f3 = Math.abs(motionEvent.getY(0) - motionEvent.getY(1));
            boolean bl2 = bl = f3 > f2;
            if (f > this.e) {
                PointF pointF = this.getTrans(this.b.x, this.b.y);
                ViewPortHandler viewPortHandler = ((BarLineChartBase)this.mChart).getViewPortHandler();
                if (this.mTouchMode == 4) {
                    float f4;
                    this.mLastGesture = ChartTouchListener.ChartGesture.PINCH_ZOOM;
                    float f5 = f / this.c;
                    boolean bl3 = f5 < 1.0f;
                    boolean bl4 = bl3 ? viewPortHandler.canZoomOutMoreX() : viewPortHandler.canZoomInMoreX();
                    boolean bl5 = bl3 ? viewPortHandler.canZoomOutMoreY() : viewPortHandler.canZoomInMoreY();
                    float f6 = ((BarLineChartBase)this.mChart).isScaleXEnabled() && !bl ? f5 : 1.0f;
                    float f7 = f4 = ((BarLineChartBase)this.mChart).isScaleYEnabled() && bl ? f5 : 1.0f;
                    if (bl5 || bl4) {
                        this.a.set(this.b);
                        this.a.postScale(f6, f4, pointF.x, pointF.y);
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(motionEvent, f6, f4);
                        }
                    }
                } else if (this.mTouchMode == 2 && ((BarLineChartBase)this.mChart).isScaleXEnabled()) {
                    boolean bl6;
                    this.mLastGesture = ChartTouchListener.ChartGesture.X_ZOOM;
                    float f8 = BarLineChartTouchListener.getXDist(motionEvent);
                    float f9 = f8 / this.a;
                    boolean bl7 = f9 < 1.0f;
                    boolean bl8 = bl6 = bl7 ? viewPortHandler.canZoomOutMoreX() : viewPortHandler.canZoomInMoreX();
                    if (bl6) {
                        this.a.set(this.b);
                        this.a.postScale(f9, 1.0f, pointF.x, pointF.y);
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(motionEvent, f9, 1.0f);
                        }
                    }
                } else if (this.mTouchMode == 3 && ((BarLineChartBase)this.mChart).isScaleYEnabled()) {
                    boolean bl9;
                    this.mLastGesture = ChartTouchListener.ChartGesture.Y_ZOOM;
                    float f10 = BarLineChartTouchListener.getYDist(motionEvent);
                    float f11 = f10 / this.b;
                    boolean bl10 = f11 < 1.0f;
                    boolean bl11 = bl9 = bl10 ? viewPortHandler.canZoomOutMoreY() : viewPortHandler.canZoomInMoreY();
                    if (bl9) {
                        this.a.set(this.b);
                        this.a.postScale(1.0f, f11, pointF.x, pointF.y);
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(motionEvent, 1.0f, f11);
                        }
                    }
                }
            }
        }
    }

    private void d(MotionEvent motionEvent) {
        Highlight highlight = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(motionEvent.getX(), motionEvent.getY());
        if (highlight != null && !highlight.equalTo(this.mLastHighlighted)) {
            this.mLastHighlighted = highlight;
            ((BarLineChartBase)this.mChart).highlightValue(highlight, true);
        }
    }

    private static void midPoint(PointF pointF, MotionEvent motionEvent) {
        float f = motionEvent.getX(0) + motionEvent.getX(1);
        float f2 = motionEvent.getY(0) + motionEvent.getY(1);
        pointF.set(f / 2.0f, f2 / 2.0f);
    }

    private static float spacing(MotionEvent motionEvent) {
        float f = motionEvent.getX(0) - motionEvent.getX(1);
        float f2 = motionEvent.getY(0) - motionEvent.getY(1);
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    private static float getXDist(MotionEvent motionEvent) {
        float f = Math.abs(motionEvent.getX(0) - motionEvent.getX(1));
        return f;
    }

    private static float getYDist(MotionEvent motionEvent) {
        float f = Math.abs(motionEvent.getY(0) - motionEvent.getY(1));
        return f;
    }

    public PointF getTrans(float f, float f2) {
        ViewPortHandler viewPortHandler = ((BarLineChartBase)this.mChart).getViewPortHandler();
        float f3 = f - viewPortHandler.offsetLeft();
        float f4 = 0.0f;
        f4 = ((BarLineChartBase)this.mChart).isAnyAxisInverted() && this.a != null && ((BarLineChartBase)this.mChart).isInverted(this.a.getAxisDependency()) ? -(f2 - viewPortHandler.offsetTop()) : -((float)((BarLineChartBase)this.mChart).getMeasuredHeight() - f2 - viewPortHandler.offsetBottom());
        return new PointF(f3, f4);
    }

    public Matrix getMatrix() {
        return this.a;
    }

    public boolean onDoubleTap(MotionEvent motionEvent) {
        this.mLastGesture = ChartTouchListener.ChartGesture.DOUBLE_TAP;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartDoubleTapped(motionEvent);
        }
        if (((BarLineChartBase)this.mChart).isDoubleTapToZoomEnabled()) {
            PointF pointF = this.getTrans(motionEvent.getX(), motionEvent.getY());
            ((BarLineChartBase)this.mChart).zoom(((BarLineChartBase)this.mChart).isScaleXEnabled() ? 1.4f : 1.0f, ((BarLineChartBase)this.mChart).isScaleYEnabled() ? 1.4f : 1.0f, pointF.x, pointF.y);
            if (((BarLineChartBase)this.mChart).isLogEnabled()) {
                Log.i((String)"BarlineChartTouch", (String)("Double-Tap, Zooming In, x: " + pointF.x + ", y: " + pointF.y));
            }
        }
        return super.onDoubleTap(motionEvent);
    }

    public void onLongPress(MotionEvent motionEvent) {
        this.mLastGesture = ChartTouchListener.ChartGesture.LONG_PRESS;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartLongPressed(motionEvent);
        }
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        this.mLastGesture = ChartTouchListener.ChartGesture.SINGLE_TAP;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartSingleTapped(motionEvent);
        }
        if (!((BarLineChartBase)this.mChart).isHighlightPerTapEnabled()) {
            return false;
        }
        Highlight highlight = ((BarLineChartBase)this.mChart).getHighlightByTouchPoint(motionEvent.getX(), motionEvent.getY());
        this.performHighlight(highlight, motionEvent);
        this.callOnChartItemHighLightListeners(highlight);
        return super.onSingleTapUp(motionEvent);
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        this.mLastGesture = ChartTouchListener.ChartGesture.FLING;
        OnChartGestureListener onChartGestureListener = ((BarLineChartBase)this.mChart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartFling(motionEvent, motionEvent2, f, f2);
        }
        return super.onFling(motionEvent, motionEvent2, f, f2);
    }

    public void stopDeceleration() {
        this.d = new PointF(0.0f, 0.0f);
    }

    public void computeScroll() {
        if (this.d.x == 0.0f && this.d.y == 0.0f) {
            return;
        }
        long l = AnimationUtils.currentAnimationTimeMillis();
        this.d.x *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        this.d.y *= ((BarLineChartBase)this.mChart).getDragDecelerationFrictionCoef();
        float f = (float)(l - this.a) / 1000.0f;
        float f2 = this.d.x * f;
        float f3 = this.d.y * f;
        this.c.x += f2;
        this.c.y += f3;
        MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)2, (float)this.c.x, (float)this.c.y, (int)0);
        this.b(motionEvent);
        motionEvent.recycle();
        this.a = ((BarLineChartBase)this.mChart).getViewPortHandler().refresh(this.a, (View)this.mChart, false);
        this.a = l;
        if ((double)Math.abs(this.d.x) >= 0.01 || (double)Math.abs(this.d.y) >= 0.01) {
            Utils.postInvalidateOnAnimation((View)this.mChart);
        } else {
            ((BarLineChartBase)this.mChart).calculateOffsets();
            ((BarLineChartBase)this.mChart).postInvalidate();
            this.stopDeceleration();
        }
    }
}

