/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BubbleDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class BubbleChartRenderer
extends DataRenderer {
    protected BubbleDataProvider mChart;
    private float[] a = new float[4];
    private float[] b = new float[2];
    private float[] c = new float[3];

    public BubbleChartRenderer(BubbleDataProvider bubbleDataProvider, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.mChart = bubbleDataProvider;
        this.mRenderPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
        this.mHighlightPaint.setStrokeWidth(Utils.convertDpToPixel(1.5f));
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(Canvas canvas) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        for (IBubbleDataSet iBubbleDataSet : bubbleData.getDataSets()) {
            if (!iBubbleDataSet.isVisible() || iBubbleDataSet.getEntryCount() <= 0) continue;
            this.drawDataSet(canvas, iBubbleDataSet);
        }
    }

    protected float getShapeSize(float f, float f2, float f3) {
        float f4 = f2 == 0.0f ? 1.0f : (float)Math.sqrt(f / f2);
        float f5 = f3 * f4;
        return f5;
    }

    protected void drawDataSet(Canvas canvas, IBubbleDataSet iBubbleDataSet) {
        Transformer transformer = this.mChart.getTransformer(iBubbleDataSet.getAxisDependency());
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        BubbleEntry bubbleEntry = (BubbleEntry)iBubbleDataSet.getEntryForXIndex(this.mMinX);
        BubbleEntry bubbleEntry2 = (BubbleEntry)iBubbleDataSet.getEntryForXIndex(this.mMaxX);
        int n = Math.max(iBubbleDataSet.getEntryIndex(bubbleEntry), 0);
        int n2 = Math.min(iBubbleDataSet.getEntryIndex(bubbleEntry2) + 1, iBubbleDataSet.getEntryCount());
        this.a[0] = 0.0f;
        this.a[2] = 1.0f;
        transformer.pointValuesToPixel(this.a);
        float f3 = Math.abs(this.a[2] - this.a[0]);
        float f4 = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
        float f5 = Math.min(f4, f3);
        int n3 = n;
        while (n3 < n2) {
            BubbleEntry bubbleEntry3 = (BubbleEntry)iBubbleDataSet.getEntryForIndex(n3);
            this.b[0] = (float)(bubbleEntry3.getXIndex() - n) * f + (float)n;
            this.b[1] = bubbleEntry3.getVal() * f2;
            transformer.pointValuesToPixel(this.b);
            float f6 = this.getShapeSize(bubbleEntry3.getSize(), iBubbleDataSet.getMaxSize(), f5) / 2.0f;
            if (this.mViewPortHandler.isInBoundsTop(this.b[1] + f6) && this.mViewPortHandler.isInBoundsBottom(this.b[1] - f6) && this.mViewPortHandler.isInBoundsLeft(this.b[0] + f6)) {
                if (!this.mViewPortHandler.isInBoundsRight(this.b[0] - f6)) break;
                int n4 = iBubbleDataSet.getColor(bubbleEntry3.getXIndex());
                this.mRenderPaint.setColor(n4);
                canvas.drawCircle(this.b[0], this.b[1], f6, this.mRenderPaint);
            }
            ++n3;
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        if (bubbleData == null) {
            return;
        }
        if (bubbleData.getYValCount() < (int)Math.ceil((float)this.mChart.getMaxVisibleCount() * this.mViewPortHandler.getScaleX())) {
            List list = bubbleData.getDataSets();
            float f = Utils.calcTextHeight(this.mValuePaint, "1");
            int n = 0;
            while (n < list.size()) {
                IBubbleDataSet iBubbleDataSet = (IBubbleDataSet)list.get(n);
                if (iBubbleDataSet.isDrawValuesEnabled() && iBubbleDataSet.getEntryCount() != 0) {
                    this.applyValueTextStyle(iBubbleDataSet);
                    float f2 = this.mAnimator.getPhaseX();
                    float f3 = this.mAnimator.getPhaseY();
                    BubbleEntry bubbleEntry = (BubbleEntry)iBubbleDataSet.getEntryForXIndex(this.mMinX);
                    BubbleEntry bubbleEntry2 = (BubbleEntry)iBubbleDataSet.getEntryForXIndex(this.mMaxX);
                    int n2 = iBubbleDataSet.getEntryIndex(bubbleEntry);
                    int n3 = Math.min(iBubbleDataSet.getEntryIndex(bubbleEntry2) + 1, iBubbleDataSet.getEntryCount());
                    float[] fArray = this.mChart.getTransformer(iBubbleDataSet.getAxisDependency()).generateTransformedValuesBubble(iBubbleDataSet, f2, f3, n2, n3);
                    float f4 = f2 == 1.0f ? f3 : f2;
                    int n4 = 0;
                    while (n4 < fArray.length) {
                        int n5 = iBubbleDataSet.getValueTextColor(n4 / 2 + n2);
                        n5 = Color.argb((int)Math.round(255.0f * f4), (int)Color.red((int)n5), (int)Color.green((int)n5), (int)Color.blue((int)n5));
                        float f5 = fArray[n4];
                        float f6 = fArray[n4 + 1];
                        if (!this.mViewPortHandler.isInBoundsRight(f5)) break;
                        if (this.mViewPortHandler.isInBoundsLeft(f5) && this.mViewPortHandler.isInBoundsY(f6)) {
                            BubbleEntry bubbleEntry3 = (BubbleEntry)iBubbleDataSet.getEntryForIndex(n4 / 2 + n2);
                            this.drawValue(canvas, iBubbleDataSet.getValueFormatter(), bubbleEntry3.getSize(), bubbleEntry3, n, f5, f6 + 0.5f * f, n5);
                        }
                        n4 += 2;
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        BubbleData bubbleData = this.mChart.getBubbleData();
        float f = this.mAnimator.getPhaseX();
        float f2 = this.mAnimator.getPhaseY();
        Highlight[] highlightArray2 = highlightArray;
        int n = highlightArray.length;
        int n2 = 0;
        while (n2 < n) {
            Highlight highlight = highlightArray2[n2];
            IBubbleDataSet iBubbleDataSet = (IBubbleDataSet)bubbleData.getDataSetByIndex(highlight.getDataSetIndex());
            if (iBubbleDataSet != null && iBubbleDataSet.isHighlightEnabled()) {
                BubbleEntry bubbleEntry = (BubbleEntry)iBubbleDataSet.getEntryForXIndex(this.mMinX);
                BubbleEntry bubbleEntry2 = (BubbleEntry)iBubbleDataSet.getEntryForXIndex(this.mMaxX);
                int n3 = iBubbleDataSet.getEntryIndex(bubbleEntry);
                int n4 = Math.min(iBubbleDataSet.getEntryIndex(bubbleEntry2) + 1, iBubbleDataSet.getEntryCount());
                BubbleEntry bubbleEntry3 = (BubbleEntry)bubbleData.getEntryForHighlight(highlight);
                if (bubbleEntry3 != null && bubbleEntry3.getXIndex() == highlight.getXIndex()) {
                    Transformer transformer = this.mChart.getTransformer(iBubbleDataSet.getAxisDependency());
                    this.a[0] = 0.0f;
                    this.a[2] = 1.0f;
                    transformer.pointValuesToPixel(this.a);
                    float f3 = Math.abs(this.a[2] - this.a[0]);
                    float f4 = Math.abs(this.mViewPortHandler.contentBottom() - this.mViewPortHandler.contentTop());
                    float f5 = Math.min(f4, f3);
                    this.b[0] = (float)(bubbleEntry3.getXIndex() - n3) * f + (float)n3;
                    this.b[1] = bubbleEntry3.getVal() * f2;
                    transformer.pointValuesToPixel(this.b);
                    float f6 = this.getShapeSize(bubbleEntry3.getSize(), iBubbleDataSet.getMaxSize(), f5) / 2.0f;
                    if (this.mViewPortHandler.isInBoundsTop(this.b[1] + f6) && this.mViewPortHandler.isInBoundsBottom(this.b[1] - f6) && this.mViewPortHandler.isInBoundsLeft(this.b[0] + f6)) {
                        if (!this.mViewPortHandler.isInBoundsRight(this.b[0] - f6)) break;
                        if (highlight.getXIndex() >= n3 && highlight.getXIndex() < n4) {
                            int n5 = iBubbleDataSet.getColor(bubbleEntry3.getXIndex());
                            Color.RGBToHSV((int)Color.red((int)n5), (int)Color.green((int)n5), (int)Color.blue((int)n5), (float[])this.c);
                            this.c[2] = this.c[2] * 0.5f;
                            int n6 = Color.HSVToColor((int)Color.alpha((int)n5), (float[])this.c);
                            this.mHighlightPaint.setColor(n6);
                            this.mHighlightPaint.setStrokeWidth(iBubbleDataSet.getHighlightCircleWidth());
                            canvas.drawCircle(this.b[0], this.b[1], f6, this.mHighlightPaint);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

