/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.BarLineScatterCandleBubbleDataProvider;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.BubbleChartRenderer;
import com.github.mikephil.charting.renderer.CandleStickChartRenderer;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import com.github.mikephil.charting.renderer.ScatterChartRenderer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.List;

public class CombinedChartRenderer
extends DataRenderer {
    protected List<DataRenderer> mRenderers;

    public CombinedChartRenderer(CombinedChart combinedChart, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        super(chartAnimator, viewPortHandler);
        this.createRenderers(combinedChart, chartAnimator, viewPortHandler);
    }

    protected void createRenderers(CombinedChart combinedChart, ChartAnimator chartAnimator, ViewPortHandler viewPortHandler) {
        CombinedChart.DrawOrder[] drawOrderArray;
        this.mRenderers = new ArrayList<DataRenderer>();
        CombinedChart.DrawOrder[] drawOrderArray2 = drawOrderArray = combinedChart.getDrawOrder();
        int n = drawOrderArray.length;
        int n2 = 0;
        while (n2 < n) {
            CombinedChart.DrawOrder drawOrder = drawOrderArray2[n2];
            switch (drawOrder) {
                case BAR: {
                    if (combinedChart.getBarData() == null) break;
                    this.mRenderers.add(new BarChartRenderer(combinedChart, chartAnimator, viewPortHandler));
                    break;
                }
                case BUBBLE: {
                    if (combinedChart.getBubbleData() == null) break;
                    this.mRenderers.add(new BubbleChartRenderer(combinedChart, chartAnimator, viewPortHandler));
                    break;
                }
                case LINE: {
                    if (combinedChart.getLineData() == null) break;
                    this.mRenderers.add(new LineChartRenderer(combinedChart, chartAnimator, viewPortHandler));
                    break;
                }
                case CANDLE: {
                    if (combinedChart.getCandleData() == null) break;
                    this.mRenderers.add(new CandleStickChartRenderer(combinedChart, chartAnimator, viewPortHandler));
                    break;
                }
                case SCATTER: {
                    if (combinedChart.getScatterData() == null) break;
                    this.mRenderers.add(new ScatterChartRenderer(combinedChart, chartAnimator, viewPortHandler));
                }
            }
            ++n2;
        }
    }

    @Override
    public void initBuffers() {
        for (DataRenderer dataRenderer : this.mRenderers) {
            dataRenderer.initBuffers();
        }
    }

    @Override
    public void drawData(Canvas canvas) {
        for (DataRenderer dataRenderer : this.mRenderers) {
            dataRenderer.drawData(canvas);
        }
    }

    @Override
    public void drawValues(Canvas canvas) {
        for (DataRenderer dataRenderer : this.mRenderers) {
            dataRenderer.drawValues(canvas);
        }
    }

    @Override
    public void drawExtras(Canvas canvas) {
        for (DataRenderer dataRenderer : this.mRenderers) {
            dataRenderer.drawExtras(canvas);
        }
    }

    @Override
    public void drawHighlighted(Canvas canvas, Highlight[] highlightArray) {
        for (DataRenderer dataRenderer : this.mRenderers) {
            dataRenderer.drawHighlighted(canvas, highlightArray);
        }
    }

    @Override
    public void calcXBounds(BarLineScatterCandleBubbleDataProvider barLineScatterCandleBubbleDataProvider, int n) {
        for (DataRenderer dataRenderer : this.mRenderers) {
            dataRenderer.calcXBounds(barLineScatterCandleBubbleDataProvider, n);
        }
    }

    public DataRenderer getSubRenderer(int n) {
        if (n >= this.mRenderers.size() || n < 0) {
            return null;
        }
        return this.mRenderers.get(n);
    }

    public List<DataRenderer> getSubRenderers() {
        return this.mRenderers;
    }

    public void setSubRenderers(List<DataRenderer> list) {
        this.mRenderers = list;
    }
}

